/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import com.notasoftwarecompany.ekasa.RequestObject;
import com.notasoftwarecompany.ekasa.receipt.Receipt;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.chdu.SfsDataRequest;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.CashIn;
import sk.singularisdev.ekasask.command.CashOut;
import sk.singularisdev.ekasask.command.Correction;
import sk.singularisdev.ekasask.command.EKasaServerMessageInterface;
import sk.singularisdev.ekasask.command.InvalidReceipt;
import sk.singularisdev.ekasask.command.Location;
import sk.singularisdev.ekasask.command.PaymentOfClaim;
import sk.singularisdev.ekasask.command.PrintInterface;
import sk.singularisdev.ekasask.command.Receipt;
import sk.singularisdev.ekasask.db.TransactionStatus;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer1;
import sk.singularisdev.ekasask.utils.EKasaXML;

public class CorrectHelper
extends AbstractCommand
implements EKasaServerMessageInterface,
PrintInterface {
    private TransactionStatus correctionTransactionStatus;
    private Correction correction;
    private Object sfsMessage;
    private String vatTableText;

    public CorrectHelper(Correction correction, TransactionStatus correctionTransactionStatus) throws EKasaException {
        try {
            this.correction = correction;
            this.correctionTransactionStatus = correctionTransactionStatus;
            if (correctionTransactionStatus.getRequestType() == SfsDataRequest.RequestType.RECEIPT) {
                com.notasoftwarecompany.ekasa.receipt.Receipt receipt = com.notasoftwarecompany.ekasa.receipt.Receipt.getInstance(correctionTransactionStatus.getRequest());
                receipt.setCounter("" + correctionTransactionStatus.getCounter() + 1);
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyyHHmmss");
                block2 : switch (correctionTransactionStatus.getStatus()) {
                    case -999997: 
                    case -132: 
                    case -111: 
                    case -102: 
                    case -101: 
                    case -100: 
                    case -13: 
                    case -12: 
                    case -10: 
                    case -8: 
                    case -2: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            throw new EKasaException(48L);
                        }
                        receipt.setIssueDate(EKasaXML.formatDate(EKasaXML.parseDate(receipt.getIssueDate())));
                        receipt.setCreateDate(EKasaXML.formatDate(EKasaXML.parseDate(receipt.getCreateDate())));
                        break;
                    }
                    case -129: 
                    case -128: 
                    case -127: 
                    case -122: 
                    case -121: 
                    case -120: 
                    case -119: 
                    case -116: 
                    case -110: 
                    case -109: 
                    case -108: {
                        throw new EKasaException(48L);
                    }
                    case -106: 
                    case -103: {
                        Date d = sdf.parse(correction.getCorrectedValue());
                        receipt.setIssueDate(EKasaXML.formatDate(d));
                        break;
                    }
                    case -107: 
                    case -105: 
                    case -104: {
                        Date d = sdf.parse(correction.getCorrectedValue());
                        receipt.setCreateDate(EKasaXML.formatDate(d));
                        break;
                    }
                    case -112: {
                        receipt.setInvoiceNumber(correction.getCorrectedValue());
                        break;
                    }
                    case -113: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            throw new EKasaException(48L);
                        }
                        receipt.setBasicVatAmount("0.00");
                        receipt.setReducedVatAmount("0.00");
                        receipt.setTaxBaseBasic("0.00");
                        receipt.setTaxBaseReduced("0.00");
                        receipt.setTaxFreeAmount("0.00");
                        break;
                    }
                    case -114: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            throw new EKasaException(48L);
                        }
                        receipt.getItem().clear();
                        break;
                    }
                    case -115: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            throw new EKasaException(48L);
                        }
                        receipt.setInvoiceNumber(null);
                        break;
                    }
                    case -117: {
                        List<Receipt.Item> items = receipt.getItem();
                        for (Receipt.Item item : items) {
                            if (item.getItemType().equals("V") && (item.getReferenceReceiptId() == null || item.getReferenceReceiptId().equals(""))) {
                                item.setReferenceReceiptId(correction.getCorrectedValue());
                                break block2;
                            }
                            if (!item.getItemType().equals("O") || item.getReferenceReceiptId() != null && !item.getReferenceReceiptId().equals("")) continue;
                            item.setReferenceReceiptId(correction.getCorrectedValue());
                            break block2;
                        }
                        break;
                    }
                    case -118: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            throw new EKasaException(48L);
                        }
                        List<Receipt.Item> items = receipt.getItem();
                        for (Receipt.Item item : items) {
                            if (!item.getItemType().equals("K") && !item.getItemType().equals("VO") && !item.getItemType().equals("OZ") && !item.getItemType().equals("Z") && !item.getItemType().equals("VP") || item.getReferenceReceiptId() == null || item.getReferenceReceiptId().equals("")) continue;
                            item.setReferenceReceiptId(null);
                        }
                        break;
                    }
                    case -123: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            throw new EKasaException(48L);
                        }
                        receipt.setCustomerId(null);
                        receipt.setCustomerIdType(null);
                        break;
                    }
                    case -125: 
                    case -124: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            receipt.setParagon(EKasaXML.formatBoolean(true));
                            receipt.setParagonNumber(correction.getCorrectedValue());
                            break;
                        }
                        receipt.setParagon(EKasaXML.formatBoolean(false));
                        receipt.setParagonNumber(null);
                        break;
                    }
                    case -126: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            throw new EKasaException(48L);
                        }
                        receipt.setParagon(EKasaXML.formatBoolean(false));
                        receipt.setParagonNumber(null);
                        break;
                    }
                    case -130: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            throw new EKasaException(48L);
                        }
                        List<Receipt.Item> items = receipt.getItem();
                        for (Receipt.Item item : items) {
                            try {
                                BigDecimal vat = new BigDecimal(item.getVatRate());
                                if (vat.compareTo(new BigDecimal(10)) != 0 && vat.compareTo(new BigDecimal(20)) != 0) continue;
                                item.setSpecialRegulation(null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    case -131: {
                        if (correction.getCorrectedValue() != null && !correction.getCorrectedValue().equals("")) {
                            throw new EKasaException(48L);
                        }
                        List<Receipt.Item> items = receipt.getItem();
                        for (Receipt.Item item : items) {
                            if (!item.getItemType().equals("K") && !item.getItemType().equals("VO") && !item.getItemType().equals("OZ") && !item.getItemType().equals("Z") && !item.getItemType().equals("V")) continue;
                            item.setVoucherNumber(null);
                        }
                        break;
                    }
                }
                this.sfsMessage = receipt;
            } else {
                com.notasoftwarecompany.ekasa.location.Location location = com.notasoftwarecompany.ekasa.location.Location.getInstance(correctionTransactionStatus.getRequest());
                location.setCounter("" + correctionTransactionStatus.getCounter() + 1);
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyyHHmmss");
                switch (correctionTransactionStatus.getStatus()) {
                    case -999997: 
                    case -132: 
                    case -111: 
                    case -102: 
                    case -101: 
                    case -100: 
                    case -13: 
                    case -12: 
                    case -10: 
                    case -8: 
                    case -2: {
                        if (correction.getCorrectedValue() == null || correction.getCorrectedValue().equals("")) break;
                        throw new EKasaException(48L);
                    }
                    case -131: 
                    case -130: 
                    case -129: 
                    case -128: 
                    case -127: 
                    case -126: 
                    case -125: 
                    case -124: 
                    case -123: 
                    case -122: 
                    case -121: 
                    case -120: 
                    case -119: 
                    case -118: 
                    case -117: 
                    case -116: 
                    case -115: 
                    case -114: 
                    case -113: 
                    case -112: 
                    case -106: 
                    case -105: 
                    case -104: 
                    case -103: {
                        throw new EKasaException(48L);
                    }
                    case -110: 
                    case -109: 
                    case -108: {
                        Date d = sdf.parse(correction.getCorrectedValue());
                        location.setCreateDate(EKasaXML.formatDate(d));
                    }
                }
                this.sfsMessage = location;
            }
        }
        catch (Exception e) {
            throw new EKasaException(48L);
        }
    }

    @Override
    public int generQrCodeBlock(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String uid, String pkp, String okp, String qrCode) throws EKasaException {
        row = Printer1.generQRCode(printer, configuration, baos, row, false, uid, pkp, okp, qrCode);
        return row;
    }

    @Override
    public int generReceiptBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, long deviceId, ByteArrayOutputStream baos, int row) throws EKasaException {
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            int row1 = row;
            if (this.sfsMessage instanceof com.notasoftwarecompany.ekasa.receipt.Receipt) {
                com.notasoftwarecompany.ekasa.receipt.Receipt receipt = (com.notasoftwarecompany.ekasa.receipt.Receipt)this.sfsMessage;
                if (receipt.getReceiptType().equals("PD")) {
                    try {
                        Receipt r = Receipt.getInstance();
                        r.parse(receipt, configuration);
                        data.reset();
                        row1 = r.generReceiptBlock(tpg, printer, configuration, deviceId, data, row);
                        baos.write(data.toByteArray());
                        this.vatTableText = r.getVatTable(configuration).getVatTableText();
                        return row1;
                    }
                    catch (EKasaException e) {
                        if (e.getErrorCode() == 18L) {
                            Receipt r = Receipt.getInstance(false);
                            r.parse(receipt, configuration);
                            data.reset();
                            row1 = r.generReceiptBlock(tpg, printer, configuration, deviceId, data, row);
                            baos.write(data.toByteArray());
                            this.vatTableText = r.getVatTable(configuration).getVatTableText();
                            return row1;
                        }
                        throw e;
                    }
                }
                if (receipt.getReceiptType().equals("UF")) {
                    PaymentOfClaim r = PaymentOfClaim.getInstance();
                    r.parse(receipt, configuration);
                    data.reset();
                    row1 = r.generReceiptBlock(tpg, printer, configuration, deviceId, data, row);
                    baos.write(data.toByteArray());
                    this.vatTableText = null;
                    return row1;
                }
                if (receipt.getReceiptType().equals("ND")) {
                    try {
                        InvalidReceipt r = InvalidReceipt.getInstance();
                        r.parse(receipt, configuration);
                        data.reset();
                        row1 = r.generReceiptBlock(tpg, printer, configuration, deviceId, data, row);
                        baos.write(data.toByteArray());
                        this.vatTableText = r.getVatTable(configuration).getVatTableText();
                        return row1;
                    }
                    catch (EKasaException e) {
                        if (e.getErrorCode() == 18L) {
                            InvalidReceipt r = InvalidReceipt.getInstance(false);
                            r.parse(receipt, configuration);
                            data.reset();
                            row1 = r.generReceiptBlock(tpg, printer, configuration, deviceId, data, row);
                            baos.write(data.toByteArray());
                            this.vatTableText = r.getVatTable(configuration).getVatTableText();
                            return row1;
                        }
                        throw e;
                    }
                }
                if (receipt.getReceiptType().equals("VY")) {
                    CashOut r = CashOut.getInstance();
                    r.parse(receipt, configuration);
                    data.reset();
                    row1 = r.generReceiptBlock(tpg, printer, configuration, deviceId, data, row);
                    baos.write(data.toByteArray());
                    this.vatTableText = null;
                    return row1;
                }
                if (receipt.getReceiptType().equals("VK")) {
                    CashIn r = CashIn.getInstance();
                    r.parse(receipt, configuration);
                    data.reset();
                    row1 = r.generReceiptBlock(tpg, printer, configuration, deviceId, data, row);
                    baos.write(data.toByteArray());
                    this.vatTableText = null;
                    return row1;
                }
            } else if (this.sfsMessage instanceof com.notasoftwarecompany.ekasa.location.Location) {
                com.notasoftwarecompany.ekasa.location.Location location = (com.notasoftwarecompany.ekasa.location.Location)this.sfsMessage;
                Location r = Location.getInstance();
                r.parse(location, configuration);
                data.reset();
                row1 = r.generReceiptBlock(tpg, printer, configuration, deviceId, data, row);
                baos.write(data.toByteArray());
                this.vatTableText = null;
                return row1;
            }
            return row;
        }
        catch (EKasaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    @Override
    public void generFooterBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos) throws EKasaException {
    }

    @Override
    public boolean isAutoCutter() {
        return true;
    }

    @Override
    public UUID getUUID() {
        return this.correctionTransactionStatus.getMessageUuid();
    }

    @Override
    public RequestObject getSFSObject(PPEKKSetup configuration) {
        if (this.sfsMessage instanceof com.notasoftwarecompany.ekasa.receipt.Receipt) {
            return (com.notasoftwarecompany.ekasa.receipt.Receipt)this.sfsMessage;
        }
        if (this.sfsMessage instanceof com.notasoftwarecompany.ekasa.location.Location) {
            return (com.notasoftwarecompany.ekasa.location.Location)this.sfsMessage;
        }
        return null;
    }

    @Override
    public String getType() {
        if (this.sfsMessage instanceof com.notasoftwarecompany.ekasa.receipt.Receipt) {
            return ((com.notasoftwarecompany.ekasa.receipt.Receipt)this.sfsMessage).getReceiptType();
        }
        return null;
    }

    public TransactionStatus getCorrectionTransactionStatus() {
        return this.correctionTransactionStatus;
    }

    public String getVatTableText() {
        return this.vatTableText;
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
    }
}

