/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.enumeration.CUSTOMER_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer1;

public class Customer {
    private String customerId;
    private CUSTOMER_TYPE customerType;

    private Customer(CUSTOMER_TYPE type, String customerId) {
        this.customerType = type;
        this.customerId = customerId;
    }

    public static Customer getInstance(CUSTOMER_TYPE type, String customerId) {
        return new Customer(type, customerId);
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public CUSTOMER_TYPE getCustomerType() {
        return this.customerType;
    }

    public void setCustomerType(CUSTOMER_TYPE customerType) {
        this.customerType = customerType;
    }

    public int generPrintData(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid) throws EKasaException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            sb.append(Localization.getString("paragon.customer.title"));
            switch (this.customerType) {
                case ICO: {
                    sb.append(" - ");
                    sb.append(Localization.getString("paragon.customer.ico"));
                    sb.append(":");
                    break;
                }
                case DIC: {
                    sb.append(" - ");
                    sb.append(Localization.getString("paragon.customer.dic"));
                    sb.append(":");
                    break;
                }
                case IC_DPH: {
                    sb.append(" - ");
                    sb.append(Localization.getString("paragon.customer.icdph"));
                    sb.append(":");
                    break;
                }
                case INE: {
                    sb.append(":");
                }
            }
            row = Printer1.printField(printer.getCharPerRow(), configuration, invalid, printer, baos, row, true, new String[]{sb.toString(), this.customerId});
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public void validate(PPEKKConfiguration configuration) throws EKasaException {
        if (this.customerId == null || !Pattern.matches("[0-9a-zA-Z]{1,50}", this.customerId)) {
            throw new EKasaException(52L);
        }
    }
}

