/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.ItemBarcode;
import sk.singularisdev.ekasask.command.ItemPrint;
import sk.singularisdev.ekasask.command.ItemPrintBinary;
import sk.singularisdev.ekasask.command.MessageItemInterface;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.command.PrintInterface;
import sk.singularisdev.ekasask.printer.AbstractPrinter;

public class InternalDocument
extends AbstractCommand
implements PrintInterface {
    private List<MessageItemInterfaceParagon> items = new ArrayList<MessageItemInterfaceParagon>();
    private int logoHeader = 0;
    private int logoFooter = 0;
    private boolean autoCutter = true;

    private InternalDocument() {
    }

    public static InternalDocument getInstance() {
        return new InternalDocument();
    }

    public void setLogoHeader(int index) {
        this.logoHeader = index;
    }

    public int getLogoHeader() {
        return this.logoHeader;
    }

    public void setLogoFooter(int index) {
        this.logoFooter = index;
    }

    public int getLogoFooter() {
        return this.logoFooter;
    }

    public void addItem(MessageItemInterfaceParagon item) throws EKasaException {
        if (!(item instanceof ItemPrint || item instanceof ItemBarcode || item instanceof ItemPrintBinary)) {
            throw new EKasaException(5L);
        }
        this.items.add(item);
    }

    @Override
    public int generReceiptBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, long deviceId, ByteArrayOutputStream baos, int row) throws EKasaException {
        try {
            if (this.logoHeader > 0) {
                baos.write(printer.printNvImage(this.logoHeader));
            }
            int l = this.items.size();
            int i = 0;
            while (i < l) {
                row = this.items.get(i).generPrintData(printer, configuration, baos, row, "", false, MessageItemInterface.SECTION_TYPE.INTERNAL_DOCUMENT);
                ++i;
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    @Override
    public int generQrCodeBlock(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String uid, String pkp, String okp, String qrCode) throws EKasaException {
        return row;
    }

    @Override
    public void generFooterBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos) throws EKasaException {
        try {
            if (this.logoFooter > 0) {
                baos.write(printer.printNvImage(this.logoFooter));
            }
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public void setAutoCutter(boolean autoCutter) {
        this.autoCutter = autoCutter;
    }

    @Override
    public boolean isAutoCutter() {
        return this.autoCutter;
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
    }
}

