/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import com.notasoftwarecompany.ekasa.receipt.Receipt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import sk.singularisdev.ekasask.Constant;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.EKasaServerMessageInterface;
import sk.singularisdev.ekasask.command.ItemBarcode;
import sk.singularisdev.ekasask.command.ItemPrint;
import sk.singularisdev.ekasask.command.MessageItemInterface;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagonVat;
import sk.singularisdev.ekasask.command.ReceiptItemContainerReturn;
import sk.singularisdev.ekasask.command.ReceiptItemCorrect;
import sk.singularisdev.ekasask.command.ReceiptItemDepositReturn;
import sk.singularisdev.ekasask.command.ReceiptItemDiscount;
import sk.singularisdev.ekasask.command.ReceiptItemReturn;
import sk.singularisdev.ekasask.command.ReceiptItemSale;
import sk.singularisdev.ekasask.command.ReceiptItemVoucher;
import sk.singularisdev.ekasask.command.ReceiptNumberInterface;
import sk.singularisdev.ekasask.command.ReceiptVatTable;
import sk.singularisdev.ekasask.command.ReceiptVatTableNeplatca;
import sk.singularisdev.ekasask.command.Seller;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.SELLER_TYPE;
import sk.singularisdev.ekasask.enumeration.SPECIAL_REGULATION;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.Printer1;
import sk.singularisdev.ekasask.utils.EKasaXML;
import sk.singularisdev.ekasask.xmlparser.IdentityData;

public class InvalidReceipt
extends AbstractCommand
implements ReceiptNumberInterface,
EKasaServerMessageInterface {
    public static final String RECEIPT_TYPE = "ND";
    private static final boolean PRINT_INVALID = true;
    private List<MessageItemInterfaceParagon> items = new ArrayList<MessageItemInterfaceParagon>();
    private List<MessageItemInterfaceParagon> payments = new ArrayList<MessageItemInterfaceParagon>();
    private List<MessageItemInterfaceParagon> finalTexts = new ArrayList<MessageItemInterfaceParagon>();
    private int logoHeader = 0;
    private int logoFooter = 0;
    private boolean autoCutter = true;
    private Date issueDate;
    private Date createDate;
    private long receiptNumber;
    private String additionalHeader;
    private String additionalFooter;
    private Long paragonNumber;
    private long basicVatAmount = 0L;
    private long reducedVatAmount = 0L;
    private long taxFreeAmount = 0L;
    private long taxBaseBasic = 0L;
    private long taxBaseReduced = 0L;
    private boolean retail = true;

    private InvalidReceipt(boolean retail) {
        this.retail = retail;
    }

    public static InvalidReceipt getInstance() {
        return new InvalidReceipt(true);
    }

    public static InvalidReceipt getInstance(boolean retail) {
        return new InvalidReceipt(retail);
    }

    @Override
    public String getType() {
        return RECEIPT_TYPE;
    }

    public void setLogoHeader(int index) {
        this.logoHeader = index;
    }

    public int getLogoHeader() {
        return this.logoHeader;
    }

    public void setLogoFooter(int index) {
        this.logoFooter = index;
    }

    public int getLogoFooter() {
        return this.logoFooter;
    }

    public boolean isRetail() {
        return this.retail;
    }

    public void addItem(MessageItemInterfaceParagon item) throws EKasaException {
        if (item instanceof ReceiptItemVoucher ? this.items.size() == 0 : this.items.size() > 0 && this.items.get(this.items.size() - 1) instanceof ReceiptItemVoucher) {
            throw new EKasaException(5L);
        }
        this.items.add(item);
    }

    public void addPayment(MessageItemInterfaceParagon item) throws EKasaException {
        if (!(item instanceof ItemPrint) && !(item instanceof ItemBarcode)) {
            throw new EKasaException(5L);
        }
        this.payments.add(item);
    }

    public void addFinalText(MessageItemInterfaceParagon item) throws EKasaException {
        if (!(item instanceof ItemPrint) && !(item instanceof ItemBarcode)) {
            throw new EKasaException(5L);
        }
        this.finalTexts.add(item);
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    @Override
    public Date getCreateDate() {
        return this.createDate;
    }

    @Override
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Override
    public long getReceiptNumber() {
        return this.receiptNumber;
    }

    @Override
    public void setReceiptNumber(long receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public String getAdditionalHeader() {
        return this.additionalHeader;
    }

    public void setAdditionalHeader(String additionalHeader) {
        this.additionalHeader = additionalHeader;
    }

    public String getAdditionalFooter() {
        return this.additionalFooter;
    }

    public void setAdditionalFooter(String additionalFooter) {
        this.additionalFooter = additionalFooter;
    }

    public boolean isParagon() {
        return false;
    }

    public long getBasicVatAmount() {
        return this.basicVatAmount;
    }

    public void setBasicVatAmount(long basicVatAmount) {
        this.basicVatAmount = basicVatAmount;
    }

    public long getReducedVatAmount() {
        return this.reducedVatAmount;
    }

    public void setReducedVatAmount(long reducedVatAmount) {
        this.reducedVatAmount = reducedVatAmount;
    }

    public long getTaxFreeAmount() {
        return this.taxFreeAmount;
    }

    public void setTaxFreeAmount(long taxFreeAmount) {
        this.taxFreeAmount = taxFreeAmount;
    }

    public long getTaxBaseBasic() {
        return this.taxBaseBasic;
    }

    public void setTaxBaseBasic(long taxBaseBasic) {
        this.taxBaseBasic = taxBaseBasic;
    }

    public long getTaxBaseReduced() {
        return this.taxBaseReduced;
    }

    public void setTaxBaseReduced(long taxBaseReduced) {
        this.taxBaseReduced = taxBaseReduced;
    }

    public long getAmount() {
        long amount = 0L;
        amount += this.basicVatAmount;
        amount += this.reducedVatAmount;
        amount += this.taxFreeAmount;
        amount += this.taxBaseBasic;
        return amount += this.taxBaseReduced;
    }

    @Override
    public Receipt getSFSObject(PPEKKSetup configuration) {
        boolean isPlatca = configuration.getIdentity().getIdentity().isPlatcaDph();
        Receipt receipt = new Receipt();
        receipt.setAmount(EKasaXML.formatNumber(this.getAmount(), 2));
        receipt.setCreateDate(EKasaXML.formatDate(this.getCreateDate()));
        receipt.setReceiptNumber("" + this.receiptNumber);
        receipt.setIssueDate(EKasaXML.formatDate(this.getIssueDate()));
        receipt.setReceiptType(RECEIPT_TYPE);
        receipt.setParagon(EKasaXML.formatBoolean(this.isParagon()));
        if (this.isParagon()) {
            receipt.setParagonNumber("" + this.paragonNumber);
        }
        receipt.setBasicVatAmount(EKasaXML.formatNumber(this.getBasicVatAmount(), 2));
        receipt.setReducedVatAmount(EKasaXML.formatNumber(this.reducedVatAmount, 2));
        receipt.setTaxBaseBasic(EKasaXML.formatNumber(this.taxBaseBasic, 2));
        receipt.setTaxBaseReduced(EKasaXML.formatNumber(this.taxBaseReduced, 2));
        receipt.setTaxFreeAmount(EKasaXML.formatNumber(this.taxFreeAmount, 2));
        ArrayList<Receipt.Item> receiptItems = new ArrayList<Receipt.Item>();
        int index = 0;
        while (index < this.items.size()) {
            MessageItemInterfaceParagonVat itemReturn;
            Receipt.Item receiptItem;
            String vat;
            MessageItemInterfaceParagon item = this.items.get(index);
            if (item instanceof ReceiptItemSale) {
                ReceiptItemSale itemSale = (ReceiptItemSale)item;
                vat = isPlatca ? EKasaXML.formatVat(configuration, itemSale.getVat()) : EKasaXML.formatNumber(0L, 2);
                receiptItem = receipt.new Receipt.Item();
                receiptItem.setItemType("K");
                receiptItem.setName(itemSale.getName());
                receiptItem.setPrice(EKasaXML.formatNumber(itemSale.getPrice(), 2));
                receiptItem.setQuantity(EKasaXML.formatNumber(itemSale.getQuantity(), 4));
                receiptItem.setVatRate(vat);
                if (itemSale.getSeller() != null) {
                    receiptItem.setSellerId(itemSale.getSeller().getSellerId());
                    receiptItem.setSellerIdType(itemSale.getSeller().getSellerType().name());
                }
                if (itemSale.getSpecialRegulation() != SPECIAL_REGULATION.NONE) {
                    receiptItem.setSpecialRegulation(itemSale.getSpecialRegulation().name());
                }
                receiptItems.add(receiptItem);
            } else if (item instanceof ReceiptItemContainerReturn) {
                itemReturn = (ReceiptItemContainerReturn)item;
                vat = isPlatca ? EKasaXML.formatVat(configuration, ((ReceiptItemContainerReturn)itemReturn).getVat()) : EKasaXML.formatNumber(0L, 2);
                receiptItem = receipt.new Receipt.Item();
                receiptItem.setItemType("VO");
                receiptItem.setName(((ReceiptItemContainerReturn)itemReturn).getName());
                receiptItem.setPrice(EKasaXML.formatNumber(-((ReceiptItemContainerReturn)itemReturn).getPrice(), 2));
                receiptItem.setQuantity(EKasaXML.formatNumber(((ReceiptItemContainerReturn)itemReturn).getQuantity(), 4));
                receiptItem.setVatRate(vat);
                if (((ReceiptItemContainerReturn)itemReturn).getSeller() != null) {
                    receiptItem.setSellerId(((ReceiptItemContainerReturn)itemReturn).getSeller().getSellerId());
                    receiptItem.setSellerIdType(((ReceiptItemContainerReturn)itemReturn).getSeller().getSellerType().name());
                }
                if (((ReceiptItemContainerReturn)itemReturn).getSpecialRegulation() != SPECIAL_REGULATION.NONE) {
                    receiptItem.setSpecialRegulation(((ReceiptItemContainerReturn)itemReturn).getSpecialRegulation().name());
                }
                receiptItems.add(receiptItem);
            } else if (item instanceof ReceiptItemDepositReturn) {
                itemReturn = (ReceiptItemDepositReturn)item;
                vat = isPlatca ? EKasaXML.formatVat(configuration, ((ReceiptItemDepositReturn)itemReturn).getVat()) : EKasaXML.formatNumber(0L, 2);
                receiptItem = receipt.new Receipt.Item();
                receiptItem.setItemType("OZ");
                receiptItem.setName(((ReceiptItemDepositReturn)itemReturn).getName());
                receiptItem.setPrice(EKasaXML.formatNumber(-((ReceiptItemDepositReturn)itemReturn).getPrice(), 2));
                receiptItem.setQuantity(EKasaXML.formatNumber(((ReceiptItemDepositReturn)itemReturn).getQuantity(), 4));
                receiptItem.setVatRate(vat);
                if (((ReceiptItemDepositReturn)itemReturn).getSeller() != null) {
                    receiptItem.setSellerId(((ReceiptItemDepositReturn)itemReturn).getSeller().getSellerId());
                    receiptItem.setSellerIdType(((ReceiptItemDepositReturn)itemReturn).getSeller().getSellerType().name());
                }
                if (((ReceiptItemDepositReturn)itemReturn).getSpecialRegulation() != SPECIAL_REGULATION.NONE) {
                    receiptItem.setSpecialRegulation(((ReceiptItemDepositReturn)itemReturn).getSpecialRegulation().name());
                }
                receiptItems.add(receiptItem);
            } else if (item instanceof ReceiptItemDiscount) {
                ReceiptItemDiscount itemDiscount = (ReceiptItemDiscount)item;
                vat = isPlatca ? EKasaXML.formatVat(configuration, itemDiscount.getVat()) : EKasaXML.formatNumber(0L, 2);
                receiptItem = receipt.new Receipt.Item();
                if (itemDiscount.getPrice() < 0L) {
                    receiptItem.setItemType("K");
                } else {
                    receiptItem.setItemType("Z");
                }
                receiptItem.setName(itemDiscount.getName());
                receiptItem.setPrice(EKasaXML.formatNumber(-itemDiscount.getPrice(), 2));
                receiptItem.setQuantity(EKasaXML.formatNumber(itemDiscount.getQuantity(), 4));
                receiptItem.setVatRate(vat);
                if (itemDiscount.getSeller() != null) {
                    receiptItem.setSellerIdType(itemDiscount.getSeller().getSellerType().name());
                    receiptItem.setSellerId(itemDiscount.getSeller().getSellerId());
                }
                if (itemDiscount.getSpecialRegulation() != SPECIAL_REGULATION.NONE) {
                    receiptItem.setSpecialRegulation(itemDiscount.getSpecialRegulation().name());
                }
                receiptItems.add(receiptItem);
            } else if (item instanceof ReceiptItemReturn) {
                itemReturn = (ReceiptItemReturn)item;
                vat = isPlatca ? EKasaXML.formatVat(configuration, ((ReceiptItemReturn)itemReturn).getVat()) : EKasaXML.formatNumber(0L, 2);
                receiptItem = receipt.new Receipt.Item();
                receiptItem.setItemType("V");
                receiptItem.setName(((ReceiptItemReturn)itemReturn).getName());
                receiptItem.setPrice(EKasaXML.formatNumber(-((ReceiptItemReturn)itemReturn).getPrice(), 2));
                receiptItem.setQuantity(EKasaXML.formatNumber(((ReceiptItemReturn)itemReturn).getQuantity(), 4));
                receiptItem.setVatRate(vat);
                receiptItem.setReferenceReceiptId(((ReceiptItemReturn)itemReturn).getReferenceReceiptId());
                if (((ReceiptItemReturn)itemReturn).getSeller() != null) {
                    receiptItem.setSellerIdType(((ReceiptItemReturn)itemReturn).getSeller().getSellerType().name());
                    receiptItem.setSellerId(((ReceiptItemReturn)itemReturn).getSeller().getSellerId());
                }
                if (((ReceiptItemReturn)itemReturn).getSpecialRegulation() != SPECIAL_REGULATION.NONE) {
                    receiptItem.setSpecialRegulation(((ReceiptItemReturn)itemReturn).getSpecialRegulation().name());
                }
                receiptItems.add(receiptItem);
            } else if (item instanceof ReceiptItemCorrect) {
                ReceiptItemCorrect itemCorrect = (ReceiptItemCorrect)item;
                vat = isPlatca ? EKasaXML.formatVat(configuration, itemCorrect.getVat()) : EKasaXML.formatNumber(0L, 2);
                receiptItem = receipt.new Receipt.Item();
                receiptItem.setItemType("O");
                receiptItem.setName(itemCorrect.getName());
                receiptItem.setPrice(EKasaXML.formatNumber(-itemCorrect.getPrice(), 2));
                receiptItem.setQuantity(EKasaXML.formatNumber(itemCorrect.getQuantity(), 4));
                receiptItem.setVatRate(vat);
                receiptItem.setReferenceReceiptId(itemCorrect.getReferenceReceiptId());
                if (itemCorrect.getSeller() != null) {
                    receiptItem.setSellerIdType(itemCorrect.getSeller().getSellerType().name());
                    receiptItem.setSellerId(itemCorrect.getSeller().getSellerId());
                }
                if (itemCorrect.getSpecialRegulation() != SPECIAL_REGULATION.NONE) {
                    receiptItem.setSpecialRegulation(itemCorrect.getSpecialRegulation().name());
                }
                receiptItems.add(receiptItem);
            } else if (item instanceof ReceiptItemVoucher) {
                ReceiptItemVoucher itemVoucher = (ReceiptItemVoucher)item;
                vat = isPlatca ? EKasaXML.formatVat(configuration, itemVoucher.getVat()) : EKasaXML.formatNumber(0L, 2);
                receiptItem = receipt.new Receipt.Item();
                receiptItem.setItemType("VP");
                receiptItem.setName(itemVoucher.getName());
                receiptItem.setPrice(EKasaXML.formatNumber(-itemVoucher.getPrice(), 2));
                receiptItem.setQuantity(EKasaXML.formatNumber(itemVoucher.getQuantity(), 4));
                receiptItem.setVatRate(vat);
                receiptItem.setVoucherNumber(itemVoucher.getVoucherNumber());
                receiptItems.add(receiptItem);
            }
            ++index;
        }
        receipt.setItem(receiptItems);
        return receipt;
    }

    @Override
    public int generReceiptBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, long deviceId, ByteArrayOutputStream baos, int row) throws EKasaException {
        try {
            if (this.createDate.before(Constant.EKASA_START_DATE)) {
                throw new EKasaException(47L);
            }
            if (this.issueDate.before(Constant.EKASA_START_DATE)) {
                throw new EKasaException(47L);
            }
            if (this.items.size() == 0) {
                throw new EKasaException(50L);
            }
            int chars = printer.getCharPerRow();
            String mark = this.retail ? "" : "@";
            IdentityData identity = configuration.getIdentity().getIdentity();
            if (identity == null) {
                throw new EKasaException(28L);
            }
            if (this.logoHeader > 0) {
                baos.write(printer.printNvImage(this.logoHeader));
            }
            Printer1.addInvalidText(printer, configuration, baos, row, true);
            row = Printer1.generHeader(printer, configuration, deviceId, baos, row, true);
            StringBuilder sb = new StringBuilder();
            if (this.isParagon()) {
                row = Printer1.printField(chars, configuration, true, printer, baos, row, true, new String[]{Localization.getString("paragon.paragon_number"), "" + this.paragonNumber});
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                row = Printer1.printField(chars, configuration, true, printer, baos, row, false, new String[]{Localization.getString("paragon.paragon_date"), sdf.format(this.issueDate).replace(' ', ',')});
            }
            row = Printer1.generAdditionalHeader(printer, configuration, baos, row, true, this.additionalHeader);
            ReceiptVatTable vatTable = this.getVatTable(configuration);
            int l = this.items.size();
            int index = 0;
            while (index < l) {
                MessageItemInterfaceParagon item = this.items.get(index);
                row = item.generPrintData(printer, configuration, baos, row, mark, true, MessageItemInterface.SECTION_TYPE.MAIN);
                ++index;
            }
            sb.setLength(0);
            if (this.retail) {
                sb.append(Printer.formatString(Localization.getString("paragon.total"), chars - 9 - 4, true));
            } else {
                sb.append(Printer.formatString(Localization.getString("paragon.total_with_vat"), chars - 9 - 4, true));
            }
            sb.append(Printer.formatNumber(this.getAmount(), 2, 9));
            sb.append(" EUR");
            baos.write(Printer.replaceEsc(printer, sb.toString()).getBytes(printer.getCharset()));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            Printer1.addInvalidText(printer, configuration, baos, ++row, true);
            baos.write(Printer.replaceEsc(printer, printer.getDoubleSeparator()).getBytes(printer.getCharset()));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            Printer1.addInvalidText(printer, configuration, baos, ++row, true);
            if (this.payments.size() > 0) {
                index = 0;
                while (index < this.payments.size()) {
                    row = this.payments.get(index).generPrintData(printer, configuration, baos, row, mark, true, MessageItemInterface.SECTION_TYPE.PAYMENT);
                    ++index;
                }
                baos.write(Printer.replaceEsc(printer, printer.getDoubleSeparator()).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                Printer1.addInvalidText(printer, configuration, baos, ++row, true);
            }
            if (vatTable.getBasicVatAmount() != this.basicVatAmount || vatTable.getReducedVatAmount() != this.reducedVatAmount || vatTable.getTaxBaseBasic() != this.taxBaseBasic || vatTable.getTaxBaseReduced() != this.taxBaseReduced || vatTable.getTaxFreeAmount() != this.taxFreeAmount) {
                throw new EKasaException(18L);
            }
            if (configuration.getIdentity().getIdentity().isPlatcaDph()) {
                row = vatTable.generVatTable(printer, configuration, baos, row, true);
                baos.write(Printer.replaceEsc(printer, printer.getDoubleSeparator()).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                Printer1.addInvalidText(printer, configuration, baos, ++row, true);
            }
            index = 0;
            while (index < this.finalTexts.size()) {
                row = this.finalTexts.get(index).generPrintData(printer, configuration, baos, row, mark, true, MessageItemInterface.SECTION_TYPE.FINAL_TEXT);
                ++index;
            }
            sb.setLength(0);
            sb.append(Localization.getString("paragon.dkp"));
            sb.append(Localization.getString(":"));
            sb.append(Printer.formatString(identity.getOrganizationUnit().getCashRegisterCode(), 18, true));
            StringBuilder sb1 = new StringBuilder();
            sb1.append(Localization.getString("paragon.sn"));
            sb1.append(Localization.getString(":"));
            sb1.append(Printer.formatString(tpg, 12, true));
            row = Printer1.printField(chars, configuration, true, printer, baos, row, true, new String[]{sb.toString(), sb1.toString()});
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            sb.setLength(0);
            sb.append(Printer.formatString(sdf.format(this.createDate), 20, true));
            sb1.setLength(0);
            sb1.append(Printer.formatString(Localization.getString("paragon.number"), 3, false));
            sb1.append(":");
            sdf = new SimpleDateFormat("yyyyMM");
            sb1.append(sdf.format(this.createDate));
            sb1.append("/");
            sb1.append(String.format("%05d", this.receiptNumber));
            row = Printer1.printField(chars, configuration, true, printer, baos, row, true, new String[]{sb.toString(), sb1.toString()});
            row = Printer1.generFooter(printer, configuration, baos, row, true, this.additionalFooter);
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    @Override
    public int generQrCodeBlock(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String uid, String pkp, String okp, String qrCode) throws EKasaException {
        row = Printer1.generQRCode(printer, configuration, baos, row, true, uid, pkp, okp, qrCode);
        return row;
    }

    @Override
    public void generFooterBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos) throws EKasaException {
        try {
            if (this.logoFooter > 0) {
                baos.write(printer.printNvImage(this.logoFooter));
            }
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public ReceiptVatTable getVatTable(PPEKKSetup configuration) throws EKasaException {
        ReceiptVatTable vatTable = configuration.getIdentity().getIdentity().isPlatcaDph() ? new ReceiptVatTable(configuration, this.retail) : new ReceiptVatTableNeplatca(configuration, this.retail);
        int l = this.items.size();
        int index = 0;
        while (index < l) {
            MessageItemInterfaceParagonVat itemData;
            MessageItemInterfaceParagon item = this.items.get(index);
            if (item instanceof ReceiptItemSale) {
                itemData = (ReceiptItemSale)item;
                vatTable.addAmount(((ReceiptItemSale)itemData).getVat(), ((ReceiptItemSale)itemData).getPrice());
            } else if (item instanceof ReceiptItemContainerReturn) {
                itemData = (ReceiptItemContainerReturn)item;
                vatTable.addAmount(((ReceiptItemContainerReturn)itemData).getVat(), -((ReceiptItemContainerReturn)itemData).getPrice());
            } else if (item instanceof ReceiptItemDepositReturn) {
                itemData = (ReceiptItemDepositReturn)item;
                vatTable.addAmount(((ReceiptItemDepositReturn)itemData).getVat(), -((ReceiptItemDepositReturn)itemData).getPrice());
            } else if (item instanceof ReceiptItemDiscount) {
                itemData = (ReceiptItemDiscount)item;
                vatTable.addAmount(((ReceiptItemDiscount)itemData).getVat(), -((ReceiptItemDiscount)itemData).getPrice());
            } else if (item instanceof ReceiptItemReturn) {
                itemData = (ReceiptItemReturn)item;
                vatTable.addAmount(((ReceiptItemReturn)itemData).getVat(), -((ReceiptItemReturn)itemData).getPrice());
            } else if (item instanceof ReceiptItemCorrect) {
                itemData = (ReceiptItemCorrect)item;
                vatTable.addAmount(((ReceiptItemCorrect)itemData).getVat(), -((ReceiptItemCorrect)itemData).getPrice());
            } else if (item instanceof ReceiptItemVoucher) {
                itemData = (ReceiptItemVoucher)item;
                long amount = vatTable.getAmount(((ReceiptItemVoucher)itemData).getVat());
                if (((ReceiptItemVoucher)itemData).getPrice() > amount) {
                    vatTable.addAmount(((ReceiptItemVoucher)itemData).getVat(), -amount);
                } else {
                    vatTable.addAmount(((ReceiptItemVoucher)itemData).getVat(), -((ReceiptItemVoucher)itemData).getPrice());
                }
            }
            ++index;
        }
        return vatTable;
    }

    public void setAutoCutter(boolean autoCutter) {
        this.autoCutter = autoCutter;
    }

    @Override
    public boolean isAutoCutter() {
        return this.autoCutter;
    }

    public void parse(Receipt receipt, PPEKKSetup configuration) throws Exception {
        InvalidReceipt r = this;
        r.setIssueDate(EKasaXML.parseDate(receipt.getIssueDate()));
        r.setBasicVatAmount(EKasaXML.getLongValue(receipt.getBasicVatAmount(), 100));
        r.setCreateDate(EKasaXML.parseDate(receipt.getCreateDate()));
        r.setReceiptNumber(EKasaXML.getLongValue(receipt.getReceiptNumber(), 1));
        r.setReducedVatAmount(EKasaXML.getLongValue(receipt.getReducedVatAmount(), 100));
        r.setTaxBaseBasic(EKasaXML.getLongValue(receipt.getTaxBaseBasic(), 100));
        r.setTaxBaseReduced(EKasaXML.getLongValue(receipt.getTaxBaseReduced(), 100));
        r.setTaxFreeAmount(EKasaXML.getLongValue(receipt.getTaxFreeAmount(), 100));
        List<Receipt.Item> items = receipt.getItem();
        for (Receipt.Item item : items) {
            VAT_LEVEL vat;
            BigDecimal price;
            BigDecimal quantity;
            String name;
            block223: {
                MessageItemInterfaceParagonVat polozka;
                Seller seller;
                SPECIAL_REGULATION specialRegulation;
                Object vat2;
                BigDecimal unitPrice;
                long lPrice;
                String unit;
                block226: {
                    block224: {
                        block218: {
                            Seller seller2;
                            SPECIAL_REGULATION specialRegulation2;
                            long lPrice2;
                            block221: {
                                block219: {
                                    block213: {
                                        MessageItemInterfaceParagonVat polozka2;
                                        String referenceId;
                                        block216: {
                                            block214: {
                                                block208: {
                                                    block211: {
                                                        block209: {
                                                            block203: {
                                                                block206: {
                                                                    block204: {
                                                                        block198: {
                                                                            block201: {
                                                                                block199: {
                                                                                    if (!item.getItemType().equals("K")) break block198;
                                                                                    name = item.getName();
                                                                                    quantity = new BigDecimal(item.getQuantity());
                                                                                    unit = "";
                                                                                    BigDecimal price2 = new BigDecimal(item.getPrice());
                                                                                    lPrice = EKasaXML.getLongValue(item.getPrice(), 100);
                                                                                    unitPrice = price2.divide(quantity, 5, 4).stripTrailingZeros();
                                                                                    if (unitPrice.scale() > 5) {
                                                                                        unitPrice.setScale(5, 4);
                                                                                    }
                                                                                    vat2 = EKasaXML.getVatLevel(new BigDecimal(item.getVatRate()).intValue(), configuration);
                                                                                    specialRegulation = SPECIAL_REGULATION.NONE;
                                                                                    if (item.getSpecialRegulation() == null) break block199;
                                                                                    switch (item.getSpecialRegulation()) {
                                                                                        case "PDP": {
                                                                                            specialRegulation = SPECIAL_REGULATION.PDP;
                                                                                            break;
                                                                                        }
                                                                                        case "OOD": {
                                                                                            specialRegulation = SPECIAL_REGULATION.OOD;
                                                                                            break;
                                                                                        }
                                                                                        case "CK": {
                                                                                            specialRegulation = SPECIAL_REGULATION.CK;
                                                                                            break;
                                                                                        }
                                                                                        case "PT": {
                                                                                            specialRegulation = SPECIAL_REGULATION.PT;
                                                                                            break;
                                                                                        }
                                                                                        case "UD": {
                                                                                            specialRegulation = SPECIAL_REGULATION.UD;
                                                                                            break;
                                                                                        }
                                                                                        case "ZPS": {
                                                                                            specialRegulation = SPECIAL_REGULATION.ZPS;
                                                                                        }
                                                                                    }
                                                                                }
                                                                                seller = null;
                                                                                if (item.getSellerId() == null || item.getSellerIdType() == null) break block201;
                                                                                switch (item.getSellerIdType()) {
                                                                                    case "DIC": {
                                                                                        seller = Seller.getInstance(SELLER_TYPE.DIC, item.getSellerId());
                                                                                        break;
                                                                                    }
                                                                                    case "IC_DPH": {
                                                                                        seller = Seller.getInstance(SELLER_TYPE.IC_DPH, item.getSellerId());
                                                                                    }
                                                                                }
                                                                            }
                                                                            polozka = ReceiptItemSale.getInstance(name, unitPrice, quantity, unit, lPrice, (VAT_LEVEL)((Object)vat2), seller, specialRegulation);
                                                                            r.addItem(polozka);
                                                                            continue;
                                                                        }
                                                                        if (!item.getItemType().equals("VO")) break block203;
                                                                        name = item.getName();
                                                                        quantity = new BigDecimal(item.getQuantity());
                                                                        unit = "";
                                                                        BigDecimal price3 = new BigDecimal(item.getPrice());
                                                                        lPrice = EKasaXML.getLongValue(item.getPrice(), 100);
                                                                        unitPrice = price3.divide(quantity);
                                                                        if (unitPrice.scale() > 5) {
                                                                            unitPrice.setScale(5, 4);
                                                                        }
                                                                        vat2 = EKasaXML.getVatLevel(new BigDecimal(item.getVatRate()).intValue(), configuration);
                                                                        specialRegulation = SPECIAL_REGULATION.NONE;
                                                                        if (item.getSpecialRegulation() == null) break block204;
                                                                        switch (item.getSpecialRegulation()) {
                                                                            case "PDP": {
                                                                                specialRegulation = SPECIAL_REGULATION.PDP;
                                                                                break;
                                                                            }
                                                                            case "OOD": {
                                                                                specialRegulation = SPECIAL_REGULATION.OOD;
                                                                                break;
                                                                            }
                                                                            case "CK": {
                                                                                specialRegulation = SPECIAL_REGULATION.CK;
                                                                                break;
                                                                            }
                                                                            case "PT": {
                                                                                specialRegulation = SPECIAL_REGULATION.PT;
                                                                                break;
                                                                            }
                                                                            case "UD": {
                                                                                specialRegulation = SPECIAL_REGULATION.UD;
                                                                                break;
                                                                            }
                                                                            case "ZPS": {
                                                                                specialRegulation = SPECIAL_REGULATION.ZPS;
                                                                            }
                                                                        }
                                                                    }
                                                                    seller = null;
                                                                    if (item.getSellerId() == null || item.getSellerIdType() == null) break block206;
                                                                    switch (item.getSellerIdType()) {
                                                                        case "DIC": {
                                                                            seller = Seller.getInstance(SELLER_TYPE.DIC, item.getSellerId());
                                                                            break;
                                                                        }
                                                                        case "IC_DPH": {
                                                                            seller = Seller.getInstance(SELLER_TYPE.IC_DPH, item.getSellerId());
                                                                        }
                                                                    }
                                                                }
                                                                polozka = ReceiptItemContainerReturn.getInstance(name, unitPrice, quantity, unit, lPrice, (VAT_LEVEL)((Object)vat2), seller, specialRegulation);
                                                                r.addItem(polozka);
                                                                continue;
                                                            }
                                                            if (!item.getItemType().equals("V")) break block208;
                                                            name = item.getName();
                                                            quantity = new BigDecimal(item.getQuantity());
                                                            unit = "";
                                                            BigDecimal price4 = new BigDecimal(item.getPrice());
                                                            lPrice = EKasaXML.getLongValue(item.getPrice(), 100);
                                                            unitPrice = price4.divide(quantity);
                                                            if (unitPrice.scale() > 5) {
                                                                unitPrice.setScale(5, 4);
                                                            }
                                                            vat2 = EKasaXML.getVatLevel(new BigDecimal(item.getVatRate()).intValue(), configuration);
                                                            specialRegulation = SPECIAL_REGULATION.NONE;
                                                            if (item.getSpecialRegulation() == null) break block209;
                                                            switch (item.getSpecialRegulation()) {
                                                                case "PDP": {
                                                                    specialRegulation = SPECIAL_REGULATION.PDP;
                                                                    break;
                                                                }
                                                                case "OOD": {
                                                                    specialRegulation = SPECIAL_REGULATION.OOD;
                                                                    break;
                                                                }
                                                                case "CK": {
                                                                    specialRegulation = SPECIAL_REGULATION.CK;
                                                                    break;
                                                                }
                                                                case "PT": {
                                                                    specialRegulation = SPECIAL_REGULATION.PT;
                                                                    break;
                                                                }
                                                                case "UD": {
                                                                    specialRegulation = SPECIAL_REGULATION.UD;
                                                                    break;
                                                                }
                                                                case "ZPS": {
                                                                    specialRegulation = SPECIAL_REGULATION.ZPS;
                                                                }
                                                            }
                                                        }
                                                        seller = null;
                                                        if (item.getSellerId() == null || item.getSellerIdType() == null) break block211;
                                                        switch (item.getSellerIdType()) {
                                                            case "DIC": {
                                                                seller = Seller.getInstance(SELLER_TYPE.DIC, item.getSellerId());
                                                                break;
                                                            }
                                                            case "IC_DPH": {
                                                                seller = Seller.getInstance(SELLER_TYPE.IC_DPH, item.getSellerId());
                                                            }
                                                        }
                                                    }
                                                    referenceId = item.getReferenceReceiptId();
                                                    polozka2 = ReceiptItemReturn.getInstance(name, unitPrice, quantity, unit, lPrice, (VAT_LEVEL)((Object)vat2), referenceId, seller, specialRegulation);
                                                    r.addItem(polozka2);
                                                    continue;
                                                }
                                                if (!item.getItemType().equals("O")) break block213;
                                                name = item.getName();
                                                quantity = new BigDecimal(item.getQuantity());
                                                unit = "";
                                                BigDecimal price5 = new BigDecimal(item.getPrice());
                                                lPrice = EKasaXML.getLongValue(item.getPrice(), 100);
                                                unitPrice = price5.divide(quantity);
                                                if (unitPrice.scale() > 5) {
                                                    unitPrice.setScale(5, 4);
                                                }
                                                vat2 = EKasaXML.getVatLevel(new BigDecimal(item.getVatRate()).intValue(), configuration);
                                                specialRegulation = SPECIAL_REGULATION.NONE;
                                                if (item.getSpecialRegulation() == null) break block214;
                                                switch (item.getSpecialRegulation()) {
                                                    case "PDP": {
                                                        specialRegulation = SPECIAL_REGULATION.PDP;
                                                        break;
                                                    }
                                                    case "OOD": {
                                                        specialRegulation = SPECIAL_REGULATION.OOD;
                                                        break;
                                                    }
                                                    case "CK": {
                                                        specialRegulation = SPECIAL_REGULATION.CK;
                                                        break;
                                                    }
                                                    case "PT": {
                                                        specialRegulation = SPECIAL_REGULATION.PT;
                                                        break;
                                                    }
                                                    case "UD": {
                                                        specialRegulation = SPECIAL_REGULATION.UD;
                                                        break;
                                                    }
                                                    case "ZPS": {
                                                        specialRegulation = SPECIAL_REGULATION.ZPS;
                                                    }
                                                }
                                            }
                                            seller = null;
                                            if (item.getSellerId() == null || item.getSellerIdType() == null) break block216;
                                            switch (item.getSellerIdType()) {
                                                case "DIC": {
                                                    seller = Seller.getInstance(SELLER_TYPE.DIC, item.getSellerId());
                                                    break;
                                                }
                                                case "IC_DPH": {
                                                    seller = Seller.getInstance(SELLER_TYPE.IC_DPH, item.getSellerId());
                                                }
                                            }
                                        }
                                        referenceId = item.getReferenceReceiptId();
                                        polozka2 = ReceiptItemCorrect.getInstance(name, unitPrice, quantity, unit, lPrice, (VAT_LEVEL)((Object)vat2), referenceId, seller, specialRegulation);
                                        r.addItem(polozka2);
                                        continue;
                                    }
                                    if (!item.getItemType().equals("Z")) break block218;
                                    name = item.getName();
                                    quantity = new BigDecimal(item.getQuantity());
                                    price = new BigDecimal(item.getPrice()).negate();
                                    lPrice2 = -EKasaXML.getLongValue(item.getPrice(), 100);
                                    vat = EKasaXML.getVatLevel(new BigDecimal(item.getVatRate()).intValue(), configuration);
                                    specialRegulation2 = SPECIAL_REGULATION.NONE;
                                    if (item.getSpecialRegulation() == null) break block219;
                                    switch (item.getSpecialRegulation()) {
                                        case "PDP": {
                                            specialRegulation2 = SPECIAL_REGULATION.PDP;
                                            break;
                                        }
                                        case "OOD": {
                                            specialRegulation2 = SPECIAL_REGULATION.OOD;
                                            break;
                                        }
                                        case "CK": {
                                            specialRegulation2 = SPECIAL_REGULATION.CK;
                                            break;
                                        }
                                        case "PT": {
                                            specialRegulation2 = SPECIAL_REGULATION.PT;
                                            break;
                                        }
                                        case "UD": {
                                            specialRegulation2 = SPECIAL_REGULATION.UD;
                                            break;
                                        }
                                        case "ZPS": {
                                            specialRegulation2 = SPECIAL_REGULATION.ZPS;
                                        }
                                    }
                                }
                                seller2 = null;
                                if (item.getSellerId() == null || item.getSellerIdType() == null) break block221;
                                switch (item.getSellerIdType()) {
                                    case "DIC": {
                                        seller2 = Seller.getInstance(SELLER_TYPE.DIC, item.getSellerId());
                                        break;
                                    }
                                    case "IC_DPH": {
                                        seller2 = Seller.getInstance(SELLER_TYPE.IC_DPH, item.getSellerId());
                                    }
                                }
                            }
                            ReceiptItemDiscount polozka3 = ReceiptItemDiscount.getInstance(name, quantity, lPrice2, vat, seller2, specialRegulation2);
                            r.addItem(polozka3);
                            continue;
                        }
                        if (!item.getItemType().equals("OZ")) break block223;
                        name = item.getName();
                        quantity = new BigDecimal(item.getQuantity());
                        unit = "";
                        BigDecimal price6 = new BigDecimal(item.getPrice());
                        lPrice = EKasaXML.getLongValue(item.getPrice(), 100);
                        unitPrice = price6.divide(quantity);
                        if (unitPrice.scale() > 5) {
                            unitPrice.setScale(5, 4);
                        }
                        vat2 = EKasaXML.getVatLevel(new BigDecimal(item.getVatRate()).intValue(), configuration);
                        specialRegulation = SPECIAL_REGULATION.NONE;
                        if (item.getSpecialRegulation() == null) break block224;
                        switch (item.getSpecialRegulation()) {
                            case "PDP": {
                                specialRegulation = SPECIAL_REGULATION.PDP;
                                break;
                            }
                            case "OOD": {
                                specialRegulation = SPECIAL_REGULATION.OOD;
                                break;
                            }
                            case "CK": {
                                specialRegulation = SPECIAL_REGULATION.CK;
                                break;
                            }
                            case "PT": {
                                specialRegulation = SPECIAL_REGULATION.PT;
                                break;
                            }
                            case "UD": {
                                specialRegulation = SPECIAL_REGULATION.UD;
                                break;
                            }
                            case "ZPS": {
                                specialRegulation = SPECIAL_REGULATION.ZPS;
                            }
                        }
                    }
                    seller = null;
                    if (item.getSellerId() == null || item.getSellerIdType() == null) break block226;
                    switch (item.getSellerIdType()) {
                        case "DIC": {
                            seller = Seller.getInstance(SELLER_TYPE.DIC, item.getSellerId());
                            break;
                        }
                        case "IC_DPH": {
                            seller = Seller.getInstance(SELLER_TYPE.IC_DPH, item.getSellerId());
                        }
                    }
                }
                polozka = ReceiptItemDepositReturn.getInstance(name, unitPrice, quantity, unit, lPrice, (VAT_LEVEL)((Object)vat2), seller, specialRegulation);
                r.addItem(polozka);
                continue;
            }
            if (!item.getItemType().equals("VP")) continue;
            name = item.getName();
            quantity = new BigDecimal(item.getQuantity());
            price = new BigDecimal(item.getPrice());
            long lPrice = EKasaXML.getLongValue(item.getPrice(), 100);
            vat = EKasaXML.getVatLevel(new BigDecimal(item.getVatRate()).intValue(), configuration);
            String voucherNumber = item.getVoucherNumber();
            ReceiptItemVoucher polozka = ReceiptItemVoucher.getInstance(name, quantity, lPrice, vat, voucherNumber);
            r.addItem(polozka);
        }
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
        if (this.createDate.before(Constant.EKASA_START_DATE)) {
            throw new EKasaException(47L);
        }
        if (this.issueDate.before(Constant.EKASA_START_DATE)) {
            throw new EKasaException(47L);
        }
        boolean containFiscalItem = false;
        for (MessageItemInterfaceParagon item : this.items) {
            if (!(item instanceof ReceiptItemContainerReturn) && !(item instanceof ReceiptItemCorrect) && !(item instanceof ReceiptItemDepositReturn) && !(item instanceof ReceiptItemDiscount) && !(item instanceof ReceiptItemReturn) && !(item instanceof ReceiptItemSale) && !(item instanceof ReceiptItemVoucher)) continue;
            containFiscalItem = true;
            break;
        }
        if (!containFiscalItem) {
            throw new EKasaException(50L);
        }
        for (MessageItemInterfaceParagon item : this.items) {
            item.validate(configuration);
        }
        if (this.paragonNumber != null && this.paragonNumber < 1L) {
            throw new EKasaException(52L);
        }
        if (this.basicVatAmount < -1000000000L || this.basicVatAmount > 1000000000L) {
            throw new EKasaException(52L);
        }
        if (this.reducedVatAmount < -1000000000L || this.reducedVatAmount > 1000000000L) {
            throw new EKasaException(52L);
        }
        if (this.taxBaseBasic < -1000000000L || this.taxBaseBasic > 1000000000L) {
            throw new EKasaException(52L);
        }
        if (this.taxBaseReduced < -1000000000L || this.taxBaseReduced > 1000000000L) {
            throw new EKasaException(52L);
        }
        if (this.taxFreeAmount < -1000000000L || this.taxFreeAmount > 1000000000L) {
            throw new EKasaException(52L);
        }
    }
}

