/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.MessageItemInterface;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.enumeration.BARCODE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer1;

public class ItemBarcode
implements MessageItemInterfaceParagon {
    private String barcode;
    private BARCODE_TYPE barcodeType;
    private BARCODE_TEXT_POSITION textPosition;
    private BARCODE_FONT_SIZE fontSize;
    private int bcHeight;
    private int bcWidth;

    private ItemBarcode(String barcode, BARCODE_TYPE barcodeType, BARCODE_TEXT_POSITION textPosition, BARCODE_FONT_SIZE fontSize, int bcHeight, int bcWidth) {
        this.barcode = barcode;
        this.textPosition = textPosition;
        this.fontSize = fontSize;
        this.bcHeight = bcHeight;
        this.bcWidth = bcWidth;
        this.barcodeType = barcodeType;
    }

    public static ItemBarcode getInstance(String barcode, BARCODE_TYPE barcodeType, BARCODE_TEXT_POSITION textPosition, BARCODE_FONT_SIZE fontSize, int bcHeight, int bcWidth) {
        return new ItemBarcode(barcode, barcodeType, textPosition, fontSize, bcHeight, bcWidth);
    }

    @Override
    public int generPrintData(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String mark, boolean invalid, MessageItemInterface.SECTION_TYPE sectionType) throws EKasaException {
        try {
            baos.write(printer.getBarcode(this.barcode, this.barcodeType, this.textPosition, this.fontSize, this.bcHeight, this.bcWidth));
            Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
    }
}

