/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.MessageItemInterface;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagon;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.Printer1;

public class ItemPrint
implements MessageItemInterfaceParagon {
    private String printText;

    private ItemPrint(String printText) {
        this.printText = printText;
    }

    public static ItemPrint getInstance(String printText) {
        return new ItemPrint(printText);
    }

    @Override
    public int generPrintData(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String mark, boolean invalid, MessageItemInterface.SECTION_TYPE sectionType) throws EKasaException {
        try {
            int chars = printer.getCharPerRow();
            int printedChars = Printer.getPrintableLength(printer, this.printText, true);
            if (printedChars > chars) {
                throw new EKasaException(14L);
            }
            baos.write(Printer.replaceEsc(printer, this.printText, true).getBytes(printer.getCharset()));
            if (sectionType == MessageItemInterface.SECTION_TYPE.MAIN) {
                if (printedChars < chars) {
                    baos.write(String.format("%-" + (chars - printedChars) + "s", "").getBytes());
                }
                baos.write(Printer.NON_FISCAL_MARK);
            }
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
    }
}

