/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.Constant;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.AbstractCommand;
import sk.singularisdev.ekasask.command.EKasaServerMessageInterface;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.utils.EKasaXML;
import sk.singularisdev.ekasask.utils.Utility;

public class Location
extends AbstractCommand
implements EKasaServerMessageInterface {
    public static final String RECEIPT_TYPE = "L";
    private Date createDate;
    private String other;
    private String axisX;
    private String axisY;
    private String city;
    private String street;
    private String zip;
    private String buildingNumber;
    private String propertyRegistrationNumber;
    private boolean autoCutter = true;

    private Location() {
    }

    public static Location getInstance() {
        return new Location();
    }

    @Override
    public String getType() {
        return RECEIPT_TYPE;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public String getGpsX() {
        return this.axisX;
    }

    public String getGpsY() {
        return this.axisY;
    }

    public String getCity() {
        return this.city;
    }

    public String getStreet() {
        return this.street;
    }

    public String getZip() {
        return this.zip;
    }

    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public String getPropertyRegistrationNumber() {
        return this.propertyRegistrationNumber;
    }

    public void setGps(String x, String y) {
        this.axisX = x;
        this.axisY = y;
    }

    public void setAddress(String street, String buildingNumber, String propertyRegistrationNumber, String municipality, String zip) {
        this.street = street;
        this.buildingNumber = buildingNumber;
        this.propertyRegistrationNumber = propertyRegistrationNumber;
        this.city = municipality;
        this.zip = zip;
    }

    @Override
    public com.notasoftwarecompany.ekasa.location.Location getSFSObject(PPEKKSetup configuration) {
        com.notasoftwarecompany.ekasa.location.Location location = new com.notasoftwarecompany.ekasa.location.Location();
        location.setAxisX(this.axisX);
        location.setAxisY(this.axisY);
        location.setBuildingNumber(this.buildingNumber);
        location.setCreateDate(EKasaXML.formatDate(this.getCreateDate()));
        location.setMunicipality(this.city);
        location.setOther(this.other);
        location.setPostalCode(this.zip);
        location.setPropertyRegistrationNumber(this.propertyRegistrationNumber);
        location.setStreetName(this.street);
        return location;
    }

    @Override
    public int generQrCodeBlock(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String uid, String pkp, String okp, String qrCode) throws EKasaException {
        return row;
    }

    @Override
    public void generFooterBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos) throws EKasaException {
    }

    @Override
    public int generReceiptBlock(String tpg, AbstractPrinter printer, PPEKKSetup configuration, long deviceId, ByteArrayOutputStream baos, int row) throws EKasaException {
        try {
            if (this.createDate.before(Constant.EKASA_START_DATE)) {
                throw new EKasaException(47L);
            }
            int chars = printer.getCharPerRow();
            ArrayList<String> lines = new ArrayList<String>();
            Printer.splitText(lines, Localization.getString("paragon.location.title"), chars);
            Printer.splitText(lines, printer.getDoubleSeparator(), chars);
            Printer.splitText(lines, String.valueOf(Localization.getString("paragon.location.GPS")) + ":" + Utility.getValue(this.axisX) + "," + Utility.getValue(this.axisY), chars);
            Printer.splitText(lines, String.valueOf(Localization.getString("paragon.location.street")) + ":" + Utility.getValue(this.street) + " " + (this.propertyRegistrationNumber == null || this.propertyRegistrationNumber.equals("") ? "" : String.valueOf(Utility.getValue(this.propertyRegistrationNumber)) + "/") + Utility.getValue(this.buildingNumber), chars);
            Printer.splitText(lines, String.valueOf(Localization.getString("paragon.location.municipality")) + ":" + Utility.getValue(this.city), chars);
            Printer.splitText(lines, String.valueOf(Localization.getString("paragon.location.zip")) + ":" + Utility.getValue(this.zip), chars);
            Printer.splitText(lines, String.valueOf(Localization.getString("paragon.location.other")) + ":" + Utility.getValue(this.other), chars);
            for (String line : lines) {
                baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public void setAutoCutter(boolean autoCutter) {
        this.autoCutter = autoCutter;
    }

    @Override
    public boolean isAutoCutter() {
        return this.autoCutter;
    }

    public void parse(com.notasoftwarecompany.ekasa.location.Location location, PPEKKSetup configuration) throws Exception {
        Location l = this;
        l.setGps(location.getAxisX(), location.getAxisY());
        l.setAddress(location.getStreetName(), location.getBuildingNumber(), location.getPropertyRegistrationNumber(), location.getMunicipality(), location.getPostalCode());
        l.setCreateDate(EKasaXML.parseDate(location.getCreateDate()));
        l.setOther(location.getOther());
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
        if (this.createDate.before(Constant.EKASA_START_DATE)) {
            throw new EKasaException(47L);
        }
        if (this.other != null && (this.other.length() < 1 || this.other.length() > 255)) {
            throw new EKasaException(52L);
        }
        if (this.city != null && (this.city.length() < 1 || this.city.length() > 100)) {
            throw new EKasaException(52L);
        }
        if (this.street != null && (this.street.length() < 1 || this.street.length() > 100)) {
            throw new EKasaException(52L);
        }
        if (this.buildingNumber != null && (this.buildingNumber.length() < 1 || this.buildingNumber.length() > 20)) {
            throw new EKasaException(52L);
        }
        if (this.propertyRegistrationNumber != null && (this.propertyRegistrationNumber.length() < 1 || this.propertyRegistrationNumber.length() > 10)) {
            throw new EKasaException(52L);
        }
        if (this.zip != null && !Pattern.matches("[0-9]{5}", this.zip)) {
            throw new EKasaException(52L);
        }
        if (!(this.axisX == null || Pattern.matches("[0-9]{1,20}[.]{0,1}[0-9]{0,10}", this.axisX) && this.axisX.length() <= 20)) {
            throw new EKasaException(52L);
        }
        if (!(this.axisY == null || Pattern.matches("[0-9]{1,20}[.]{0,1}[0-9]{0,10}", this.axisY) && this.axisY.length() <= 20)) {
            throw new EKasaException(52L);
        }
        if (this.axisX == null && this.axisY != null) {
            throw new EKasaException(52L);
        }
        if (this.axisY == null && this.axisX != null) {
            throw new EKasaException(52L);
        }
        if (this.city == null && this.street != null) {
            throw new EKasaException(52L);
        }
        if (this.street == null && this.city != null) {
            throw new EKasaException(52L);
        }
        if (this.other == null && this.axisX == null && this.axisY == null && this.city == null && this.street == null && this.buildingNumber == null && this.propertyRegistrationNumber == null && this.zip == null) {
            throw new EKasaException(52L);
        }
    }
}

