/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.MessageItemInterface;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagonVat;
import sk.singularisdev.ekasask.command.Seller;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.SPECIAL_REGULATION;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.Printer1;

public class ReceiptItemCorrect
implements MessageItemInterfaceParagonVat {
    private SPECIAL_REGULATION specialRegulation = SPECIAL_REGULATION.NONE;
    private Seller seller = null;
    private BigDecimal unitPrice;
    private long price;
    private BigDecimal quantity;
    private String unit;
    private String name;
    private VAT_LEVEL vat = VAT_LEVEL.A;
    private String referenceReceiptId;

    private ReceiptItemCorrect(String name, BigDecimal unitPrice, BigDecimal quantity, String unit, long price, VAT_LEVEL vat, String referenceReceiptId, Seller seller, SPECIAL_REGULATION specialRegulation) throws EKasaException {
        if (quantity.compareTo(BigDecimal.ZERO) < 0) {
            throw new EKasaException(25L);
        }
        if (unitPrice.compareTo(BigDecimal.ZERO) < 0) {
            throw new EKasaException(26L);
        }
        if (unitPrice.scale() > 5) {
            throw new EKasaException(26L);
        }
        if (unitPrice.scale() < 2) {
            unitPrice = unitPrice.setScale(2);
        }
        if (price < 0L) {
            throw new EKasaException(27L);
        }
        this.name = name;
        this.unitPrice = unitPrice;
        this.quantity = quantity;
        this.unit = unit;
        this.price = price;
        this.vat = vat;
        this.referenceReceiptId = referenceReceiptId;
        this.seller = seller;
        this.specialRegulation = specialRegulation;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public Seller getSeller() {
        return this.seller;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public long getPrice() {
        return this.price;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VAT_LEVEL getVat() {
        return this.vat;
    }

    public String getReferenceReceiptId() {
        return this.referenceReceiptId;
    }

    public SPECIAL_REGULATION getSpecialRegulation() {
        return this.specialRegulation;
    }

    public static ReceiptItemCorrect getInstance(String name, BigDecimal unitPrice, BigDecimal quantity, String unit, long price, VAT_LEVEL vat, String referenceReceiptId, Seller seller, SPECIAL_REGULATION specialRegulation) throws EKasaException {
        return new ReceiptItemCorrect(name, unitPrice, quantity, unit, price, vat, referenceReceiptId, seller, specialRegulation);
    }

    public static ReceiptItemCorrect getInstance(String name, BigDecimal unitPrice, BigDecimal quantity, String unit, long price, VAT_LEVEL vat, String referenceReceiptId, Seller seller) throws EKasaException {
        return new ReceiptItemCorrect(name, unitPrice, quantity, unit, price, vat, referenceReceiptId, seller, SPECIAL_REGULATION.NONE);
    }

    public static ReceiptItemCorrect getInstance(String name, BigDecimal unitPrice, BigDecimal quantity, String unit, long price, VAT_LEVEL vat, String referenceReceiptId, SPECIAL_REGULATION specialRegulation) throws EKasaException {
        return new ReceiptItemCorrect(name, unitPrice, quantity, unit, price, vat, referenceReceiptId, null, specialRegulation);
    }

    public static ReceiptItemCorrect getInstance(String name, BigDecimal unitPrice, BigDecimal quantity, String unit, long price, VAT_LEVEL vat, String referenceReceiptId) throws EKasaException {
        return new ReceiptItemCorrect(name, unitPrice, quantity, unit, price, vat, referenceReceiptId, null, SPECIAL_REGULATION.NONE);
    }

    @Override
    public int generPrintData(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String mark, boolean invalid, MessageItemInterface.SECTION_TYPE sectionType) throws EKasaException {
        try {
            int chars = printer.getCharPerRow();
            if (Printer.getPrintableLength(printer, this.name, false) > chars) {
                throw new EKasaException(14L);
            }
            int lName = Printer.getPrintableLength(printer, this.name, false);
            if (lName > chars) {
                throw new EKasaException(14L);
            }
            int lUnit = Printer.getPrintableLength(printer, this.unit, false);
            if (lUnit > 3) {
                throw new EKasaException(14L);
            }
            StringBuilder sb = new StringBuilder();
            baos.write(Printer.replaceEsc(printer, Localization.getString("paragon.item.correct")).getBytes(printer.getCharset()));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            ++row;
            row = Printer1.addInvalidText(printer, configuration, baos, row, invalid);
            sb.setLength(0);
            sb.append(Localization.getString("paragon.item.reference"));
            sb.append(this.referenceReceiptId);
            ArrayList<String> list = new ArrayList<String>();
            Printer.splitText(list, sb.toString(), printer.getCharPerRow());
            for (String txt : list) {
                baos.write(Printer.replaceEsc(printer, txt).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                ++row;
                row = Printer1.addInvalidText(printer, configuration, baos, row, invalid);
            }
            sb.setLength(0);
            String txtName = this.name;
            String txtUnitPrice = this.unitPrice.toString();
            String txtQuantity = this.quantity.toString();
            String txtUnit = this.unit;
            String txtPrice = Printer.formatNumber(-this.price, 2, 0);
            String txtMark = mark;
            String txtVat = this.vat.name();
            String format = configuration.getIdentity().getIdentity().isPlatcaDph() ? Printer.getParagonItemSaleFormat(printer, true) : Printer.getParagonItemSaleFormat(printer, false);
            sb.append(String.format(format, txtName, txtUnitPrice, txtQuantity, txtUnit, txtPrice, txtMark, txtVat));
            String txt = sb.toString();
            ArrayList<String> lines = new ArrayList<String>();
            Printer.splitText(lines, txt, printer.getCharPerRow());
            for (String line : lines) {
                baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
            }
            if (this.seller != null) {
                row = this.seller.generPrintData(printer, configuration, baos, row, invalid);
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
        if (this.name == null || this.name.length() < 0 || this.name.length() > 255) {
            throw new EKasaException(52L);
        }
        if (this.price < -1000000000L || this.price > 1000000000L) {
            throw new EKasaException(52L);
        }
        if (this.quantity.scale() > 4 || this.quantity.compareTo(BigDecimal.ZERO) < 0 || this.quantity.compareTo(new BigDecimal("10000000")) > 0) {
            throw new EKasaException(52L);
        }
        if (this.seller != null) {
            this.seller.validate(configuration);
        }
        if (this.referenceReceiptId.length() < 1 || this.referenceReceiptId.length() > 44) {
            throw new EKasaException(52L);
        }
        int v = configuration.getVat(this.vat);
        if (v != 0 && v != 10 && v != 20) {
            throw new EKasaException(52L);
        }
        if (v != 0 && this.specialRegulation != SPECIAL_REGULATION.NONE) {
            throw new EKasaException(52L);
        }
    }
}

