/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.MessageItemInterface;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagonVat;
import sk.singularisdev.ekasask.command.Seller;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.SPECIAL_REGULATION;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.Printer1;

public class ReceiptItemDiscount
implements MessageItemInterfaceParagonVat {
    private SPECIAL_REGULATION specialRegulation = SPECIAL_REGULATION.NONE;
    private Seller seller = null;
    private long price;
    private BigDecimal quantity;
    private String name;
    private VAT_LEVEL vat = VAT_LEVEL.A;

    private ReceiptItemDiscount(String name, BigDecimal quantity, long price, VAT_LEVEL vat, Seller seller, SPECIAL_REGULATION specialRegulation) throws EKasaException {
        if (quantity.compareTo(BigDecimal.ZERO) < 0) {
            throw new EKasaException(25L);
        }
        if (price == 0L) {
            throw new EKasaException(27L);
        }
        this.name = name;
        this.quantity = quantity;
        this.price = price;
        this.vat = vat;
        this.seller = seller;
        this.specialRegulation = specialRegulation;
    }

    public Seller getSeller() {
        return this.seller;
    }

    @Override
    public String getUnit() {
        return "";
    }

    @Override
    public long getPrice() {
        return this.price;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VAT_LEVEL getVat() {
        return this.vat;
    }

    public SPECIAL_REGULATION getSpecialRegulation() {
        return this.specialRegulation;
    }

    public static ReceiptItemDiscount getInstance(String name, BigDecimal quantity, long price, VAT_LEVEL vat, Seller seller, SPECIAL_REGULATION specialRegulation) throws EKasaException {
        return new ReceiptItemDiscount(name, quantity, price, vat, seller, specialRegulation);
    }

    public static ReceiptItemDiscount getInstance(String name, BigDecimal quantity, long price, VAT_LEVEL vat, Seller seller) throws EKasaException {
        return new ReceiptItemDiscount(name, quantity, price, vat, seller, SPECIAL_REGULATION.NONE);
    }

    public static ReceiptItemDiscount getInstance(String name, BigDecimal quantity, long price, VAT_LEVEL vat, SPECIAL_REGULATION specialRegulation) throws EKasaException {
        return new ReceiptItemDiscount(name, quantity, price, vat, null, specialRegulation);
    }

    public static ReceiptItemDiscount getInstance(String name, BigDecimal quantity, long price, VAT_LEVEL vat) throws EKasaException {
        return new ReceiptItemDiscount(name, quantity, price, vat, null, SPECIAL_REGULATION.NONE);
    }

    @Override
    public int generPrintData(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String mark, boolean invalid, MessageItemInterface.SECTION_TYPE sectionType) throws EKasaException {
        try {
            int chars = printer.getCharPerRow();
            int lName = Printer.getPrintableLength(printer, this.name, false);
            if (lName > chars) {
                throw new EKasaException(14L);
            }
            int unitPriceSize = printer.getParagonItemDiscountPriceSize();
            if (lName > chars - unitPriceSize - 4) {
                baos.write(Printer.replaceEsc(printer, this.name).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                ++row;
                row = Printer1.addInvalidText(printer, configuration, baos, row, invalid);
                baos.write(Printer.replaceEsc(printer, Printer.formatNumber(-this.price, 2, chars - 4)).getBytes(printer.getCharset()));
            } else {
                baos.write(Printer.alignText(printer, this.name, PRINT_ALIGNMENT.LEFT, chars - unitPriceSize - 4, true, false));
                baos.write(Printer.replaceEsc(printer, Printer.formatNumber(-this.price, 2, unitPriceSize)).getBytes(printer.getCharset()));
            }
            if (configuration.getIdentity().getIdentity().isPlatcaDph()) {
                baos.write((String.valueOf(mark) + "   ").substring(0, 3).getBytes(printer.getCharset()));
                baos.write(this.vat.name().getBytes(printer.getCharset()));
            } else {
                baos.write((String.valueOf(mark) + " ").substring(0, 1).getBytes(printer.getCharset()));
                baos.write(Localization.getString("paragon.no_vat").getBytes(printer.getCharset()));
            }
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            ++row;
            row = Printer1.addInvalidText(printer, configuration, baos, row, invalid);
            if (this.seller != null) {
                row = this.seller.generPrintData(printer, configuration, baos, row, invalid);
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
        int v;
        if (this.name == null || this.name.length() < 0 || this.name.length() > 255) {
            throw new EKasaException(52L);
        }
        if (this.price < -1000000000L || this.price > 1000000000L) {
            throw new EKasaException(52L);
        }
        if (this.quantity.scale() > 4 || this.quantity.compareTo(BigDecimal.ZERO) < 0 || this.quantity.compareTo(new BigDecimal("10000000")) > 0) {
            throw new EKasaException(52L);
        }
        if (this.seller != null) {
            this.seller.validate(configuration);
        }
        if ((v = configuration.getVat(this.vat)) != 0 && v != 10 && v != 20) {
            throw new EKasaException(52L);
        }
        if (v != 0 && this.specialRegulation != SPECIAL_REGULATION.NONE) {
            throw new EKasaException(52L);
        }
    }
}

