/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.MessageItemInterface;
import sk.singularisdev.ekasask.command.MessageItemInterfaceParagonVat;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.Printer1;

public class ReceiptItemVoucher
implements MessageItemInterfaceParagonVat {
    private long price;
    private BigDecimal quantity;
    private String name;
    private VAT_LEVEL vat = VAT_LEVEL.A;
    private String voucherNumber;

    private ReceiptItemVoucher(String name, BigDecimal quantity, long price, VAT_LEVEL vat, String voucherNumber) throws EKasaException {
        if (quantity.compareTo(BigDecimal.ZERO) < 0) {
            throw new EKasaException(25L);
        }
        if (price < 0L) {
            throw new EKasaException(27L);
        }
        this.name = name;
        this.quantity = quantity;
        this.price = price;
        this.vat = vat;
        this.voucherNumber = voucherNumber;
    }

    @Override
    public long getPrice() {
        return this.price;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VAT_LEVEL getVat() {
        return this.vat;
    }

    @Override
    public String getUnit() {
        return "";
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public static ReceiptItemVoucher getInstance(String name, BigDecimal quantity, long price, VAT_LEVEL vat, String voucherNumber) throws EKasaException {
        return new ReceiptItemVoucher(name, quantity, price, vat, voucherNumber);
    }

    @Override
    public int generPrintData(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, String mark, boolean invalid, MessageItemInterface.SECTION_TYPE sectionType) throws EKasaException {
        try {
            int chars = printer.getCharPerRow();
            if (Printer.getPrintableLength(printer, this.name, false) > chars) {
                throw new EKasaException(14L);
            }
            int lName = Printer.getPrintableLength(printer, this.name, false);
            if (lName > chars) {
                throw new EKasaException(14L);
            }
            int lVoucherNumber = Printer.getPrintableLength(printer, this.voucherNumber, false);
            if (lVoucherNumber > 50) {
                throw new EKasaException(14L);
            }
            StringBuilder sb = new StringBuilder();
            baos.write(Printer.replaceEsc(printer, Localization.getString("paragon.item.voucher")).getBytes(printer.getCharset()));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            if (lName + 1 + 4 + lVoucherNumber > chars) {
                baos.write(Printer.replaceEsc(printer, this.name).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                ++row;
                row = Printer1.addInvalidText(printer, configuration, baos, row, invalid);
                sb.append(Localization.getString("paragon.jup"));
                sb.append(":");
                sb.append(this.voucherNumber);
            } else {
                sb.append(this.name);
                sb.append(Printer.formatString(String.valueOf(Localization.getString("paragon.jup")) + ":" + this.voucherNumber, chars - lName - 1, false));
            }
            ArrayList<String> list = new ArrayList<String>();
            Printer.splitText(list, sb.toString(), printer.getCharPerRow());
            for (String txt : list) {
                baos.write(Printer.replaceEsc(printer, txt).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                ++row;
                row = Printer1.addInvalidText(printer, configuration, baos, row, invalid);
            }
            sb.setLength(0);
            String txtQuantity = this.quantity.toString();
            String txtUnit = this.getUnit();
            String txtPrice = Printer.formatNumber(-this.price, 2, 0);
            String txtMark = mark;
            String txtVat = this.vat.name();
            String format = configuration.getIdentity().getIdentity().isPlatcaDph() ? Printer.getParagonItemVoucherFormat(printer, true) : Printer.getParagonItemVoucherFormat(printer, false);
            sb.append(String.format(format, "", "", txtQuantity, txtUnit, txtPrice, txtMark, txtVat));
            String txt = sb.toString();
            ArrayList<String> lines = new ArrayList<String>();
            Printer.splitText(lines, txt, printer.getCharPerRow());
            for (String line : lines) {
                baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    @Override
    public void validate(PPEKKConfiguration configuration) throws EKasaException {
        if (this.name == null || this.name.length() < 0 || this.name.length() > 255) {
            throw new EKasaException(52L);
        }
        if (this.price < -1000000000L || this.price > 1000000000L) {
            throw new EKasaException(52L);
        }
        if (this.quantity.scale() > 4 || this.quantity.compareTo(BigDecimal.ZERO) < 0 || this.quantity.compareTo(new BigDecimal("10000000")) > 0) {
            throw new EKasaException(52L);
        }
        if (this.voucherNumber.length() < 1 || this.voucherNumber.length() > 50) {
            throw new EKasaException(52L);
        }
        int v = configuration.getVat(this.vat);
        if (v != 0 && v != 10 && v != 20) {
            throw new EKasaException(52L);
        }
    }
}

