/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.Printer1;

public class ReceiptVatTable {
    private Map<Integer, Vat> vatTable = new TreeMap<Integer, Vat>(new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }
    });
    protected PPEKKSetup configuration;
    private boolean retail = true;
    private boolean jup;
    protected long basicVatAmount = 0L;
    protected long reducedVatAmount = 0L;
    protected long taxFreeAmount = 0L;
    protected long taxBaseBasic = 0L;
    protected long taxBaseReduced = 0L;

    public ReceiptVatTable(PPEKKSetup configuration, boolean retail) throws EKasaException {
        this.configuration = configuration;
        this.retail = retail;
        this.addToTable(configuration.getConfiguration().getVatA(), configuration.getConfiguration().getVatTypeA(), 'A');
        this.addToTable(configuration.getConfiguration().getVatB(), configuration.getConfiguration().getVatTypeB(), 'B');
        this.addToTable(configuration.getConfiguration().getVatC(), configuration.getConfiguration().getVatTypeC(), 'C');
        this.addToTable(configuration.getConfiguration().getVatD(), configuration.getConfiguration().getVatTypeD(), 'D');
        this.addToTable(configuration.getConfiguration().getVatE(), configuration.getConfiguration().getVatTypeE(), 'E');
        this.addToTable(configuration.getConfiguration().getVatF(), configuration.getConfiguration().getVatTypeF(), 'F');
        this.addToTable(configuration.getConfiguration().getVatG(), configuration.getConfiguration().getVatTypeG(), 'G');
        this.addToTable(configuration.getConfiguration().getVatH(), configuration.getConfiguration().getVatTypeH(), 'H');
    }

    public boolean isRetail() {
        return this.retail;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addToTable(Integer vat, VAT_TYPE vatType, char charVat) throws EKasaException {
        if (vat == null) return;
        if (this.vatTable.containsKey(vat)) {
            Vat v = this.vatTable.get(vat);
            if (!v.getVatType().equals((Object)vatType)) throw new EKasaException(17L);
            v.addVatChar(charVat);
            return;
        } else {
            this.vatTable.put(vat, new Vat(vat, vatType, charVat));
        }
    }

    public void addAmount(Integer vat, long amount) throws EKasaException {
        if (vat == null) {
            throw new EKasaException(17L);
        }
        if (!this.vatTable.containsKey(vat)) {
            throw new EKasaException(17L);
        }
        this.vatTable.get(vat).addAmount(amount);
        this.recalc();
    }

    public void addAmount(VAT_LEVEL vatLevel, long amount) throws EKasaException {
        Integer vat = null;
        switch (vatLevel) {
            case A: {
                vat = this.configuration.getConfiguration().getVatA();
                break;
            }
            case B: {
                vat = this.configuration.getConfiguration().getVatB();
                break;
            }
            case C: {
                vat = this.configuration.getConfiguration().getVatC();
                break;
            }
            case D: {
                vat = this.configuration.getConfiguration().getVatD();
                break;
            }
            case E: {
                vat = this.configuration.getConfiguration().getVatE();
                break;
            }
            case F: {
                vat = this.configuration.getConfiguration().getVatF();
                break;
            }
            case G: {
                vat = this.configuration.getConfiguration().getVatG();
                break;
            }
            case H: {
                vat = this.configuration.getConfiguration().getVatH();
            }
        }
        this.addAmount(vat, amount);
    }

    private void recalc() {
        this.basicVatAmount = 0L;
        this.reducedVatAmount = 0L;
        this.taxFreeAmount = 0L;
        this.taxBaseBasic = 0L;
        this.taxBaseReduced = 0L;
        for (Integer v : this.vatTable.keySet()) {
            Vat vat = this.vatTable.get(v);
            switch (vat.getVatType()) {
                case FREE: {
                    this.taxFreeAmount = this.taxFreeAmount + vat.getBaseAmount() + vat.getVatAmount();
                    break;
                }
                case BASED: {
                    this.basicVatAmount += vat.getVatAmount();
                    this.taxBaseBasic += vat.getBaseAmount();
                    break;
                }
                case REDUCED: {
                    this.reducedVatAmount += vat.getVatAmount();
                    this.taxBaseReduced += vat.getBaseAmount();
                }
            }
        }
    }

    public long getBasicVatAmount() {
        return this.basicVatAmount;
    }

    public long getReducedVatAmount() {
        return this.reducedVatAmount;
    }

    public long getTaxFreeAmount() {
        return this.taxFreeAmount;
    }

    public long getTaxBaseBasic() {
        return this.taxBaseBasic;
    }

    public long getTaxBaseReduced() {
        return this.taxBaseReduced;
    }

    public long getAmount() {
        return this.basicVatAmount + this.reducedVatAmount + this.taxFreeAmount + this.taxBaseBasic + this.taxBaseReduced;
    }

    public long getAmount(VAT_LEVEL vatLevel) throws EKasaException {
        Integer vat = null;
        switch (vatLevel) {
            case A: {
                vat = this.configuration.getConfiguration().getVatA();
                break;
            }
            case B: {
                vat = this.configuration.getConfiguration().getVatB();
                break;
            }
            case C: {
                vat = this.configuration.getConfiguration().getVatC();
                break;
            }
            case D: {
                vat = this.configuration.getConfiguration().getVatD();
                break;
            }
            case E: {
                vat = this.configuration.getConfiguration().getVatE();
                break;
            }
            case F: {
                vat = this.configuration.getConfiguration().getVatF();
                break;
            }
            case G: {
                vat = this.configuration.getConfiguration().getVatG();
                break;
            }
            case H: {
                vat = this.configuration.getConfiguration().getVatH();
            }
        }
        if (vat == null) {
            throw new EKasaException(17L);
        }
        if (this.vatTable.containsKey(vat)) {
            Vat v = this.vatTable.get(vat);
            return v.getBaseAmount() + v.getVatAmount();
        }
        return 0L;
    }

    public int generVatTable(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid) throws EKasaException {
        try {
            if (!this.jup || !this.isZero()) {
                StringBuilder sb;
                String obrat;
                baos.write(Printer.alignText(printer, Localization.getString("paragon.vat.title"), PRINT_ALIGNMENT.CENTER));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                ArrayList<String> lines = new ArrayList<String>();
                Printer.splitText(lines, printer.getVatTableTitle(), printer.getCharPerRow());
                for (String line : lines) {
                    baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                    Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                }
                boolean printEmptyVatRow = printer.printEmptyVatTableRow();
                String format = Printer.getVatTableFormat(printer);
                for (int key : this.vatTable.keySet()) {
                    Vat vat = this.vatTable.get(key);
                    if (vat.getCounter() == 0 && !printEmptyVatRow) continue;
                    String sadzba = String.valueOf(Printer.formatNumber(vat.getVat(), 0, 2)) + "%";
                    String zaklad = Printer.formatNumber(vat.getBaseAmount(), 2, 0);
                    String dph = Printer.formatNumber(vat.getVatAmount(), 2, 0);
                    obrat = Printer.formatNumber(vat.getBaseAmount() + vat.getVatAmount(), 2, 0);
                    sb = new StringBuilder();
                    sb.append(String.format(format, sadzba, zaklad, dph, obrat, vat.vatChar));
                    lines.clear();
                    Printer.splitText(lines, sb.toString(), printer.getCharPerRow());
                    for (String line : lines) {
                        baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                        baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                    }
                }
                long zaklad = this.taxBaseReduced + this.taxBaseBasic + this.taxFreeAmount;
                long dan = this.basicVatAmount + this.reducedVatAmount;
                String txtZaklad = Printer.formatNumber(zaklad, 2, 0);
                String txtDph = Printer.formatNumber(dan, 2, 0);
                obrat = Printer.formatNumber(zaklad + dan, 2, 0);
                sb = new StringBuilder();
                sb.append(String.format(format, printer.getVatTableTotalText(), txtZaklad, txtDph, obrat, ""));
                lines.clear();
                Printer.splitText(lines, sb.toString(), printer.getCharPerRow());
                for (String line : lines) {
                    baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                    Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                }
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public String getVatTableText() {
        StringBuilder sb = new StringBuilder();
        if (!this.jup || !this.isZero()) {
            for (int key : this.vatTable.keySet()) {
                Vat vat = this.vatTable.get(key);
                String sadzba = String.valueOf(vat.getVat()) + "%";
                String zaklad = Printer.formatNumber(vat.getBaseAmount(), 2, 0);
                String dph = Printer.formatNumber(vat.getVatAmount(), 2, 0);
                sb.append(zaklad);
                sb.append(";");
                sb.append(sadzba);
                sb.append(";");
                sb.append(dph);
                sb.append(";");
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public boolean isZero() {
        for (int key : this.vatTable.keySet()) {
            Vat vat = this.vatTable.get(key);
            if (vat.getBaseAmount() != 0L) {
                return false;
            }
            if (vat.getVatAmount() == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isJUP() {
        return this.jup;
    }

    public void setJUP(boolean jup) {
        this.jup = jup;
    }

    public class Vat {
        private int vat;
        private VAT_TYPE vatType;
        private long amount = 0L;
        private String vatChar = "";
        private long baseAmount = 0L;
        private long vatAmount = 0L;
        private int counter = 0;

        private Vat(int vat, VAT_TYPE vatType, char vatChar) {
            this.vat = vat;
            this.vatType = vatType;
            this.vatChar = String.valueOf(this.vatChar) + vatChar;
        }

        public int getCounter() {
            return this.counter;
        }

        public void addVatChar(char vatChar) {
            this.vatChar = String.valueOf(this.vatChar) + vatChar;
        }

        public void addAmount(long amount) {
            if (ReceiptVatTable.this.isRetail()) {
                this.amount += amount;
                BigDecimal a = new BigDecimal(this.amount);
                BigDecimal v = a.multiply(new BigDecimal(this.vat)).divide(new BigDecimal(100 + this.vat), 0, 4);
                this.vatAmount = v.longValue();
                this.baseAmount = this.amount - this.vatAmount;
            } else {
                this.amount += amount;
                BigDecimal a = new BigDecimal(this.amount);
                BigDecimal v = a.divide(new BigDecimal(100)).multiply(new BigDecimal(this.vat)).setScale(0, 4);
                this.vatAmount = v.longValue();
                this.baseAmount = this.amount;
            }
            ++this.counter;
        }

        public VAT_TYPE getVatType() {
            return this.vatType;
        }

        public long getBaseAmount() {
            return this.baseAmount;
        }

        public long getVatAmount() {
            return this.vatAmount;
        }

        public int getVat() {
            return this.vat;
        }
    }
}

