/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.SELLER_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.Printer1;

public class Seller {
    private String sellerId;
    private SELLER_TYPE sellerType;

    private Seller(SELLER_TYPE type, String sellerId) {
        this.sellerType = type;
        this.sellerId = sellerId;
    }

    public static Seller getInstance(SELLER_TYPE type, String sellerId) {
        return new Seller(type, sellerId);
    }

    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public SELLER_TYPE getSellerType() {
        return this.sellerType;
    }

    public void setSellerType(SELLER_TYPE sellerType) {
        this.sellerType = sellerType;
    }

    public int generPrintData(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid) throws EKasaException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            sb.append(Localization.getString("paragon.seller"));
            sb.append(" ");
            switch (this.sellerType) {
                case DIC: {
                    sb.append(Localization.getString("paragon.dic"));
                    break;
                }
                case IC_DPH: {
                    sb.append(Localization.getString("paragon.icdph"));
                }
            }
            sb.append(" ");
            sb.append(this.sellerId);
            ArrayList<String> lines = new ArrayList<String>();
            Printer.splitText(lines, sb.toString(), printer.getCharPerRow(), true);
            for (String line : lines) {
                baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public void validate(PPEKKConfiguration configuration) throws EKasaException {
        if (!Pattern.matches("[0-9a-zA-Z]{1,50}", this.sellerId)) {
            throw new EKasaException(52L);
        }
    }
}

