/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.command.setup;

import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;

public class SetupItemVat
implements SetupItemInterface {
    public static String NAME = "VAT";
    private String name;
    private Integer vat = null;
    private VAT_TYPE vatType = VAT_TYPE.FREE;

    private SetupItemVat(String name) {
        this.name = name;
    }

    @Override
    public String getDbName() {
        return this.name;
    }

    @Override
    public String getInternalValue() {
        return String.valueOf(VAT_TYPE.getValue(this.vatType)) + ":" + (this.vat == null ? "-" : this.vat);
    }

    @Override
    public void setInternalValue(String value) {
        String[] p = value.split(":");
        if (p.length == 2) {
            this.vat = p[1].equals("-") ? null : Integer.valueOf(Integer.parseInt(p[1]));
            this.vatType = VAT_TYPE.getVatType(p[0]);
        }
    }

    public Integer getVat() {
        return this.vat;
    }

    public void setVat(Integer vat) {
        this.vat = vat;
    }

    public VAT_TYPE getVatType() {
        return this.vatType;
    }

    public void setVatType(VAT_TYPE vatType) {
        this.vatType = vatType;
    }

    @Override
    public boolean isStoreEncode() {
        return false;
    }

    public static SetupItemVat getInstance(VAT_LEVEL vatLevel) throws EKasaException {
        String name = NAME;
        switch (vatLevel) {
            case A: {
                name = String.valueOf(name) + "A";
                break;
            }
            case B: {
                name = String.valueOf(name) + "B";
                break;
            }
            case C: {
                name = String.valueOf(name) + "C";
                break;
            }
            case D: {
                name = String.valueOf(name) + "D";
                break;
            }
            case E: {
                name = String.valueOf(name) + "E";
                break;
            }
            case F: {
                name = String.valueOf(name) + "F";
                break;
            }
            case G: {
                name = String.valueOf(name) + "G";
                break;
            }
            case H: {
                name = String.valueOf(name) + "H";
            }
        }
        SetupItemVat item = new SetupItemVat(name);
        return item;
    }
}

