/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.db;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import sk.singularisdev.chdu.parameter.Transaction;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKAuthentication;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKIdentity;
import sk.singularisdev.ekasask.chdu.CHDU;
import sk.singularisdev.ekasask.chdu.SfsDataRequest;
import sk.singularisdev.ekasask.command.setup.SetupItemInterface;
import sk.singularisdev.ekasask.db.DbTransactionStatusFetchListenerInterface;
import sk.singularisdev.ekasask.db.TransactionInfo;
import sk.singularisdev.ekasask.db.TransactionStatus;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;
import sk.singularisdev.ekasask.printer.Display;
import sk.singularisdev.ekasask.utils.Base64;
import sk.singularisdev.ekasask.utils.IniFile;
import sk.singularisdev.ekasask.utils.Zip;

public class Database {
    private static final Logger logger = LoggerManager.getLogger(Database.class.getName());
    private static final boolean ENCRYPT_CONFIG_CONTENT = true;
    private Cipher cipherEncrypt;
    private Cipher cipherDecrypt;
    private Base64 base64Encoder = new Base64();
    private Map<Transaction.ID, TransactionHolder> unsendedTransaction = new TreeMap<Transaction.ID, TransactionHolder>();
    private Map<String, Long> receiptNumber = new HashMap<String, Long>();
    private Map<Transaction.ID, TransactionHolder> errorTransaction = new TreeMap<Transaction.ID, TransactionHolder>();
    private PPEKKConfiguration configuration;
    private PPEKKAuthentication auth;
    private PPEKKIdentity ident;
    private UUID instanceUUID;
    private static final String FILE_NAME = "ppekk.ini";
    private File cfgFile;
    private ChduState chduState = new ChduState();

    public Database(File root, long deviceId) throws EKasaException {
        try {
            boolean canOpen;
            block13: {
                this.cfgFile = new File(root.getAbsolutePath(), "ppekk_" + deviceId + ".ini");
                SecretKeySpec secretKey = new SecretKeySpec("P@ssw0rdP@ssw0rd".getBytes(), "AES");
                this.cipherEncrypt = Cipher.getInstance("AES");
                this.cipherEncrypt.init(1, secretKey);
                this.cipherDecrypt = Cipher.getInstance("AES");
                this.cipherDecrypt.init(2, secretKey);
                ZipFile zipFile = null;
                try {
                    try {
                        zipFile = new ZipFile(this.cfgFile);
                        canOpen = true;
                    }
                    catch (Exception ex) {
                        canOpen = false;
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    throw throwable;
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            if (!this.cfgFile.exists() || !canOpen) {
                PPEKKConfiguration cfg = PPEKKConfiguration.getInstance(null, new String[0], null, null, null, new String[0], new Display(), new Display(), 20, VAT_TYPE.BASED, 10, VAT_TYPE.REDUCED, 0, VAT_TYPE.FREE, null, VAT_TYPE.FREE, null, VAT_TYPE.FREE, null, VAT_TYPE.FREE, null, VAT_TYPE.FREE, null, VAT_TYPE.FREE, false);
                PPEKKAuthentication auth = PPEKKAuthentication.getInstance(null, null);
                PPEKKIdentity ident = PPEKKIdentity.getInstance(null);
                UUID instanceUUID = UUID.randomUUID();
                this.setConfiguration(cfg);
                this.setAuthentication(auth);
                this.setIdentity(ident);
                this.setInstanceUUID(instanceUUID);
            }
            this.configuration = this.loadConfiguration();
            this.auth = this.loadAuthentication();
            this.ident = this.loadIdentity();
            try {
                this.instanceUUID = this.loadInstanceUUID();
            }
            catch (Exception e) {
                UUID instanceUUID = UUID.randomUUID();
                this.setInstanceUUID(instanceUUID);
                instanceUUID = this.loadInstanceUUID();
            }
        }
        catch (Exception e) {
            logger.fatal("Database Initialization", e);
            throw new EKasaException(2L, (Throwable)e);
        }
    }

    public boolean isSyncChdu(String sn, String lastTransactionId) throws EKasaException {
        Transaction.ID tID = new Transaction.ID(lastTransactionId);
        return this.chduState.chduSN.equals(sn) && tID.compareTo(this.chduState.lastTransactionId) == 0;
    }

    public PPEKKConfiguration getConfiguration() throws EKasaException {
        return this.configuration;
    }

    public void setConfiguration(PPEKKConfiguration cfg) throws EKasaException {
        this.saveConfiguration(cfg);
        this.configuration = cfg;
    }

    public PPEKKConfiguration loadConfiguration() throws EKasaException {
        try {
            String encryptedContent = Zip.loadFromFile(this.cfgFile, "configuration");
            String content = this.decrypt(encryptedContent);
            IniFile iniFile = new IniFile();
            iniFile.setContent(content);
            return PPEKKConfiguration.getInstance(iniFile);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public void saveConfiguration(PPEKKConfiguration cfg) throws EKasaException {
        try {
            IniFile iniFile = cfg.getConfigFile();
            String content = iniFile.getContent();
            String contentEncrypted = this.encrypt(content);
            Zip.saveToFile(this.cfgFile, "configuration", contentEncrypted);
            this.configuration = cfg;
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public PPEKKAuthentication getAuthentication() throws EKasaException {
        return this.auth;
    }

    public void setAuthentication(PPEKKAuthentication auth) throws EKasaException {
        this.saveAuthentication(auth);
        this.auth = auth;
    }

    public PPEKKAuthentication loadAuthentication() throws EKasaException {
        try {
            String encryptedContent = Zip.loadFromFile(this.cfgFile, "auth");
            String content = this.decrypt(encryptedContent);
            IniFile authFile = new IniFile();
            authFile.setContent(content);
            return PPEKKAuthentication.getInstance(authFile);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public void saveAuthentication(PPEKKAuthentication auth) throws EKasaException {
        try {
            IniFile iniFile = auth.getAuthFile();
            String content = iniFile.getContent();
            String contentEncrypted = this.encrypt(content);
            Zip.saveToFile(this.cfgFile, "auth", contentEncrypted);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public void setIdentity(PPEKKIdentity ident) throws EKasaException {
        this.saveIdentity(ident);
        this.ident = ident;
    }

    public UUID getInstanceUUID() throws EKasaException {
        if (this.instanceUUID == null) {
            this.setInstanceUUID(UUID.randomUUID());
        }
        return this.instanceUUID;
    }

    private void setInstanceUUID(UUID instanceUUID) throws EKasaException {
        this.saveInstanceUUID(instanceUUID);
        this.instanceUUID = instanceUUID;
    }

    public PPEKKIdentity getIdentity() throws EKasaException {
        return this.ident;
    }

    public void saveIdentity(PPEKKIdentity ident) throws EKasaException {
        try {
            IniFile iniFile = ident.getIdentFile();
            String content = iniFile.getContent();
            String contentEncrypted = this.encrypt(content);
            Zip.saveToFile(this.cfgFile, "ident", contentEncrypted);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public PPEKKIdentity loadIdentity() throws EKasaException {
        try {
            String encryptedContent = Zip.loadFromFile(this.cfgFile, "ident");
            String content = this.decrypt(encryptedContent);
            IniFile identFile = new IniFile();
            identFile.setContent(content);
            return PPEKKIdentity.getInstance(identFile);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    private void saveInstanceUUID(UUID instanceUUID) throws EKasaException {
        try {
            String content = instanceUUID.toString();
            String contentEncrypted = this.encrypt(content);
            Zip.saveToFile(this.cfgFile, "uuid", contentEncrypted);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public UUID loadInstanceUUID() throws EKasaException {
        try {
            String encryptedContent = Zip.loadFromFile(this.cfgFile, "uuid");
            String content = this.decrypt(encryptedContent);
            return UUID.fromString(content);
        }
        catch (Exception e) {
            throw new EKasaException(21L, (Throwable)e);
        }
    }

    public void setSetup(SetupItemInterface setup) throws EKasaException {
        this.configuration = PPEKKConfiguration.getInstance(this.configuration, setup);
        this.auth = PPEKKAuthentication.getInstance(this.auth, setup);
        this.ident = PPEKKIdentity.getInstance(this.ident, setup);
        this.saveConfiguration(this.configuration);
        this.saveAuthentication(this.auth);
        this.saveIdentity(this.ident);
    }

    public int getTimeoutedTransactionCount(String chduSn) throws EKasaException {
        return this.unsendedTransaction.size();
    }

    public void resetData(String chduSn, boolean b) throws EKasaException {
        this.unsendedTransaction.clear();
        this.errorTransaction.clear();
        this.chduState.chduSN = "";
        this.chduState.lastTransactionId = new Transaction.ID(0, 0);
    }

    public void setMaxReceiptNumber(String month, long receiptNumber) throws EKasaException {
        long number = this.receiptNumber.containsKey(month) ? this.receiptNumber.get(month) : 0L;
        if (receiptNumber > number) {
            this.receiptNumber.put(month, receiptNumber);
        }
    }

    public void getTimeoutedTransactionsStatus(CHDU chdu, String chduSn, boolean originTransaction, Date dateFrom, Date dateTo, String numberFrom, String numberTo, DbTransactionStatusFetchListenerInterface listener) throws EKasaException {
        Long nTo;
        Long nFrom;
        try {
            nFrom = numberFrom == null ? null : Long.valueOf(Long.parseLong(numberFrom));
            nTo = numberTo == null ? null : Long.valueOf(Long.parseLong(numberTo));
        }
        catch (Exception e) {
            nFrom = null;
            nTo = null;
        }
        this.getTimeoutedTransactionsStatus(chdu, chduSn, originTransaction, dateFrom, dateTo, nFrom, nTo, listener);
    }

    public void getTimeoutedTransactionsStatus(CHDU chdu, String chduSn, boolean originTransaction, Date dateFrom, Date dateTo, Long numberFrom, Long numberTo, DbTransactionStatusFetchListenerInterface listener) throws EKasaException {
        for (Transaction.ID tId : this.unsendedTransaction.keySet()) {
            TransactionStatus tStatus;
            TransactionHolder tHolder = this.unsendedTransaction.get(tId);
            if (!tHolder.isDateBetween(dateFrom, dateTo) || !tHolder.isNumberBetween(numberFrom, numberTo)) continue;
            if (originTransaction) {
                tStatus = tHolder.getOriginTransactionStatus();
                if (tStatus == null) {
                    tStatus = tHolder.getTransactionStatus();
                    if (tStatus == null) {
                        tStatus = chdu.getTransactionStatus(tId.format());
                        tHolder.setTransactionStatus(tStatus);
                    }
                    if (tStatus.getOriginTransactionId() == null || tStatus.getOriginTransactionId().equals(tStatus.getTransactionId())) {
                        tHolder.setOriginTransactionStatus(tStatus);
                    }
                }
                listener.onNextRecord(tStatus);
                continue;
            }
            tStatus = tHolder.getTransactionStatus();
            if (tStatus == null) {
                tStatus = chdu.getTransactionStatus(tId.format());
                tHolder.setTransactionStatus(tStatus);
            }
            listener.onNextRecord(tStatus);
        }
    }

    public void getErroredTransactionsStatus(CHDU chdu, String chduSn, boolean originTransaction, Date dateFrom, Date dateTo, String numberFrom, String numberTo, DbTransactionStatusFetchListenerInterface listener) throws EKasaException {
        Long nTo;
        Long nFrom;
        try {
            nFrom = numberFrom == null ? null : Long.valueOf(Long.parseLong(numberFrom));
            nTo = numberTo == null ? null : Long.valueOf(Long.parseLong(numberTo));
        }
        catch (Exception e) {
            nFrom = null;
            nTo = null;
        }
        this.getErroredTransactionsStatus(chdu, chduSn, originTransaction, dateFrom, dateTo, nFrom, nTo, listener);
    }

    public void getErroredTransactionsStatus(CHDU chdu, String chduSn, boolean originTransaction, Date dateFrom, Date dateTo, Long numberFrom, Long numberTo, DbTransactionStatusFetchListenerInterface listener) throws EKasaException {
        for (Transaction.ID tId : this.errorTransaction.keySet()) {
            TransactionStatus tStatus;
            TransactionHolder tHolder = this.errorTransaction.get(tId);
            if (!tHolder.isDateBetween(dateFrom, dateTo) || !tHolder.isNumberBetween(numberFrom, numberTo)) continue;
            if (originTransaction) {
                tStatus = tHolder.getOriginTransactionStatus();
                if (tStatus == null) {
                    tStatus = tHolder.getTransactionStatus();
                    if (tStatus == null) {
                        tStatus = chdu.getTransactionStatus(tId.format());
                        tHolder.setTransactionStatus(tStatus);
                    }
                    if (tStatus.getOriginTransactionId() == null || tStatus.getOriginTransactionId().equals(tStatus.getTransactionId())) {
                        tHolder.setOriginTransactionStatus(tStatus);
                    }
                }
                listener.onNextRecord(tStatus);
                continue;
            }
            tStatus = tHolder.getTransactionStatus();
            if (tStatus == null) {
                tStatus = chdu.getTransactionStatus(tId.format());
                tHolder.setTransactionStatus(tStatus);
            }
            listener.onNextRecord(tStatus);
        }
    }

    public void setTransactionInfo(TransactionInfo transactionInfo) throws EKasaException {
        if (this.chduState.lastTransactionId.compareTo(transactionInfo.getTransactionId()) < 0) {
            this.chduState.lastTransactionId.setId(transactionInfo.getTransactionId());
        }
        if (transactionInfo.getRetryTransactionId() != null) {
            Transaction.ID id = new Transaction.ID(transactionInfo.getRetryTransactionId());
            this.unsendedTransaction.remove(id);
            this.errorTransaction.remove(id);
        }
        switch (transactionInfo.getStatus()) {
            case 0: {
                this.unsendedTransaction.remove(transactionInfo.getTransactionId());
                this.errorTransaction.remove(transactionInfo.getTransactionId());
                break;
            }
            case -999999: {
                this.unsendedTransaction.put(transactionInfo.getTransactionId(), new TransactionHolder(transactionInfo.getTransactionId().format(), transactionInfo.getTransactionStatus()));
                break;
            }
            default: {
                this.errorTransaction.put(transactionInfo.getTransactionId(), new TransactionHolder(transactionInfo.getTransactionId().format(), transactionInfo.getTransactionStatus()));
            }
        }
        TransactionStatus tStatus = transactionInfo.getTransactionStatus();
        if (tStatus == null) {
            if (transactionInfo.getType() == SfsDataRequest.RequestType.RECEIPT.getShortage()) {
                String[] x = transactionInfo.getPcd().split("/");
                String month = x[0];
                long receiptNumber = Long.parseLong(x[1]);
                this.setMaxReceiptNumber(month, receiptNumber);
            }
        } else if (tStatus.getRequestType() == SfsDataRequest.RequestType.RECEIPT) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            String month = sdf.format(tStatus.getCreationDate());
            long receiptNumber = Long.parseLong(tStatus.getReceiptNumber());
            this.setMaxReceiptNumber(month, receiptNumber);
        }
    }

    public void setTransactionStatus(TransactionStatus[] transactionStatuses) throws EKasaException {
        TransactionStatus[] transactionStatusArray = transactionStatuses;
        int n = transactionStatuses.length;
        int n2 = 0;
        while (n2 < n) {
            Transaction.ID id;
            TransactionStatus transactionStatus = transactionStatusArray[n2];
            Transaction.ID tId1 = new Transaction.ID(transactionStatus.getTransactionId());
            if (this.chduState.lastTransactionId.compareTo(tId1) < 0) {
                this.chduState.lastTransactionId.setId(tId1);
            }
            if (transactionStatus.getRetryTransactionId() != null) {
                id = new Transaction.ID(transactionStatus.getRetryTransactionId());
                this.unsendedTransaction.remove(id);
                this.errorTransaction.remove(id);
            }
            if (transactionStatus.getNextTransactionId() != null) {
                id = new Transaction.ID(transactionStatus.getTransactionId());
                this.unsendedTransaction.remove(id);
                this.errorTransaction.remove(id);
            } else {
                switch (transactionStatus.getStatus()) {
                    case 0: {
                        id = new Transaction.ID(transactionStatus.getTransactionId());
                        this.unsendedTransaction.remove(id);
                        this.errorTransaction.remove(id);
                        break;
                    }
                    case -999999: {
                        id = new Transaction.ID(transactionStatus.getTransactionId());
                        this.unsendedTransaction.put(id, new TransactionHolder(transactionStatus.getTransactionId(), transactionStatus));
                        break;
                    }
                    default: {
                        id = new Transaction.ID(transactionStatus.getTransactionId());
                        this.errorTransaction.put(id, new TransactionHolder(transactionStatus.getTransactionId(), transactionStatus));
                    }
                }
            }
            if (transactionStatus.getRequestType() == SfsDataRequest.RequestType.RECEIPT) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
                String month = sdf.format(transactionStatus.getCreationDate());
                long rn = Long.parseLong(transactionStatus.getReceiptNumber());
                this.setMaxReceiptNumber(month, rn);
            }
            ++n2;
        }
    }

    public void setChduState(String sn, String lastTransactionId) {
        this.chduState.chduSN = sn;
        this.chduState.lastTransactionId = new Transaction.ID(lastTransactionId);
    }

    public TransactionHolder getLastErrorTransaction(String chduSn) throws EKasaException {
        Iterator<Transaction.ID> iterator = this.errorTransaction.keySet().iterator();
        if (iterator.hasNext()) {
            Transaction.ID transactionId = iterator.next();
            return this.errorTransaction.get(transactionId);
        }
        return null;
    }

    public long getLastReceiptNumber(Date createDate) throws EKasaException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String period = sdf.format(createDate);
        if (this.receiptNumber.containsKey(period)) {
            return this.receiptNumber.get(period);
        }
        return 0L;
    }

    public Map<String, Long> getAllMaxReceiptNumber() throws EKasaException {
        return this.receiptNumber;
    }

    public TransactionStatus getFirstTimeoutedTransactionStatus(String chduSn, CHDU chdu) throws EKasaException {
        Iterator<Transaction.ID> iterator = this.unsendedTransaction.keySet().iterator();
        if (iterator.hasNext()) {
            Transaction.ID transactionId = iterator.next();
            TransactionHolder transactionHolder = this.unsendedTransaction.get(transactionId);
            TransactionStatus transactionStatus = transactionHolder.getTransactionStatus();
            if (transactionStatus == null) {
                transactionStatus = chdu.getTransactionStatus(transactionId.format());
                transactionHolder.setTransactionStatus(transactionStatus);
            }
            return transactionStatus;
        }
        return null;
    }

    public synchronized String encrypt(String value) throws EKasaException {
        if (this.cipherEncrypt == null) {
            throw new EKasaException(12L);
        }
        try {
            byte[] plainText = value.getBytes("UTF-8");
            return this.base64Encoder.encode(this.cipherEncrypt.doFinal(plainText));
        }
        catch (Exception e) {
            throw new EKasaException(12L, (Throwable)e);
        }
    }

    public synchronized String decrypt(String value) throws EKasaException {
        if (this.cipherDecrypt == null) {
            throw new EKasaException(12L);
        }
        try {
            byte[] cipherText = this.base64Encoder.decode(value);
            return new String(this.cipherDecrypt.doFinal(cipherText), "UTF8");
        }
        catch (Exception e) {
            throw new EKasaException(12L, (Throwable)e);
        }
    }

    public List<String> getListOfErroredTransaction(String sn) {
        ArrayList<String> data = new ArrayList<String>();
        for (Transaction.ID transactionId : this.errorTransaction.keySet()) {
            TransactionHolder holder = this.errorTransaction.get(transactionId);
            data.add(String.valueOf(transactionId.format()) + ":" + (holder.getTransactionStatus() == null ? "UNKNOWN" : Integer.valueOf(holder.getTransactionStatus().getStatus())));
        }
        return data;
    }

    public List<String> getListOfTimeoutedTransaction(String sn) {
        ArrayList<String> data = new ArrayList<String>();
        for (Transaction.ID transactionId : this.unsendedTransaction.keySet()) {
            data.add(transactionId.format());
        }
        return data;
    }

    private class ChduState {
        private String chduSN = "";
        private Transaction.ID lastTransactionId = new Transaction.ID(0, 0);

        private ChduState() {
        }
    }

    public class TransactionHolder {
        private String transactionId = null;
        private String originTransactionId = null;
        private TransactionStatus transactionStatus = null;
        private TransactionStatus originTransactionStatus = null;

        public TransactionHolder(String transactionId) {
            this(transactionId, null);
        }

        public TransactionHolder(String transactionId, TransactionStatus transactionStatus) {
            this.transactionId = transactionId;
            this.transactionStatus = transactionStatus;
        }

        public boolean isDateBetween(Date dateFrom, Date dateTo) {
            if (dateFrom != null && this.transactionStatus.getCreationDate().before(dateFrom)) {
                return false;
            }
            return dateTo == null || !this.transactionStatus.getCreationDate().after(dateTo);
        }

        public void setTransactionStatus(TransactionStatus transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        public TransactionStatus getTransactionStatus() {
            return this.transactionStatus;
        }

        public void setOriginTransactionStatus(TransactionStatus transactionStatus) {
            this.originTransactionId = transactionStatus.getTransactionId();
            this.originTransactionStatus = transactionStatus;
        }

        public TransactionStatus getOriginTransactionStatus() {
            return this.originTransactionStatus;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public String getOriginTransactionId() {
            return this.originTransactionId;
        }

        public boolean isNumberBetween(Long numberFrom, Long numberTo) {
            block7: {
                long rNumber;
                block8: {
                    block5: {
                        block6: {
                            try {
                                if (numberFrom == null) break block5;
                                if (this.transactionStatus.getReceiptNumber() != null) break block6;
                                return false;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        rNumber = Long.parseLong(this.transactionStatus.getReceiptNumber());
                        if (rNumber >= numberFrom) break block5;
                        return false;
                    }
                    if (numberTo == null) break block7;
                    if (this.transactionStatus.getReceiptNumber() != null) break block8;
                    return false;
                }
                rNumber = Long.parseLong(this.transactionStatus.getReceiptNumber());
                if (rNumber <= numberTo) break block7;
                return false;
            }
            return true;
        }
    }
}

