/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer;

import java.lang.reflect.Method;
import java.nio.charset.Charset;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.enumeration.BARCODE_TYPE;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.QR_CODE_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.PrinterEsc;
import sk.singularisdev.ekasask.printer.PrinterStatus;
import sk.singularisdev.ekasask.printer.driver.BmpPrinter;

public abstract class AbstractPrinter {
    private static Logger logger = LoggerManager.getLogger(AbstractPrinter.class.getName());
    protected Charset charset;
    private String singleSeparator;
    private String doubleSeparator;

    public AbstractPrinter() {
        String emptyLine = String.format("%" + this.getCharPerRow() + "s", "");
        this.singleSeparator = emptyLine.replace(" ", "-");
        this.doubleSeparator = emptyLine.replace(" ", "=");
    }

    public String getSingleSeparator() {
        return this.singleSeparator;
    }

    public String getDoubleSeparator() {
        return this.doubleSeparator;
    }

    public Charset getDefaultCharset() {
        return this.charset;
    }

    public abstract byte[] getAlignment(PRINT_ALIGNMENT var1);

    public abstract int getCharPerRow();

    public abstract boolean isQRsupport();

    public abstract int getDotsPerLine();

    public Charset getCharset() {
        return this.charset;
    }

    public static AbstractPrinter getInstance(String printerType) {
        try {
            Class<?> clazz = Class.forName(printerType);
            Method method = clazz.getMethod("getInstance", null);
            return (AbstractPrinter)method.invoke(null, null);
        }
        catch (Exception e) {
            logger.fatal("Printer driver initialization", e);
            return null;
        }
    }

    public abstract byte[] printImage(int var1, int var2, byte[] var3) throws EKasaException;

    public abstract byte[] loadNvImage(int var1, byte[] var2) throws EKasaException;

    public abstract byte[] printNvImage(int var1) throws EKasaException;

    public abstract byte[] getEscSequence(PRINT_SEQUENCE_TYPE var1);

    public abstract byte[] getBarcode(String var1, BARCODE_TYPE var2, BARCODE_TEXT_POSITION var3, BARCODE_FONT_SIZE var4, int var5, int var6) throws EKasaException;

    public abstract PrinterEsc[] getPrinterStatusEsc();

    public abstract PrinterEsc getPrinterConnectionStatus();

    public abstract PrinterStatus parsePrinterStatus(PrinterEsc[] var1);

    public abstract byte[] getQrCode(String var1, QR_CODE_TYPE var2) throws EKasaException;

    public abstract String rewriteEscSequence(String var1, boolean var2, boolean var3);

    @Deprecated
    public abstract int[] getVatTableCols();

    public String getVatTableTitle() throws EKasaException {
        int[] cols = this.getVatTableCols();
        StringBuilder sb = new StringBuilder();
        if (cols[0] > 0) {
            sb.append(String.format("%" + cols[0] + "s", ""));
        }
        sb.append(new String(Printer.alignText(this, Localization.getString("paragon.vat.rate"), PRINT_ALIGNMENT.RIGHT, cols[1], true, false), this.getCharset()));
        sb.append(new String(Printer.alignText(this, Localization.getString("paragon.vat.base"), PRINT_ALIGNMENT.RIGHT, cols[2]), this.getCharset()));
        sb.append(new String(Printer.alignText(this, Localization.getString("paragon.vat.vat"), PRINT_ALIGNMENT.RIGHT, cols[3]), this.getCharset()));
        sb.append(new String(Printer.alignText(this, Localization.getString("paragon.vat.total"), PRINT_ALIGNMENT.RIGHT, cols[4]), this.getCharset()));
        sb.append(" ");
        if (cols[5] > 0) {
            sb.append(String.format("%" + cols[5] + "s", ""));
        }
        return sb.toString();
    }

    public String getVatTableTotalText() {
        return Localization.getString("paragon.vat.total_amount");
    }

    public int getParagonItemDiscountPriceSize() {
        return 12;
    }

    public String getParagonItemSaleFormat(boolean platca) {
        int unitPrice = this.getCharPerRow() - 11 - 3 - 12 - 4;
        if (platca) {
            return "%1$-" + this.getCharPerRow() + "s" + "%2$" + (unitPrice > 10 ? unitPrice : 10) + "s" + "%3$" + 11 + "s" + "%4$-" + 3 + "s" + "%5$" + 12 + "s" + "%6$3s" + "%7$1s";
        }
        return "%1$-" + this.getCharPerRow() + "s" + "%2$" + (unitPrice > 10 ? unitPrice : 10) + "s" + "%3$" + 11 + "s" + "%4$-" + 3 + "s" + "%5$" + 12 + "s" + "%6$1s" + Localization.getString("paragon.no_vat");
    }

    public String getParagonItemVoucherFormat(boolean platca) {
        int unitPrice = this.getCharPerRow() - 11 - 3 - 12 - 4;
        if (platca) {
            return "%3$" + (unitPrice + 11) + "s" + "%4$-" + 3 + "s" + "%5$" + 12 + "s" + "%6$3s" + "%7$1s";
        }
        return "%3$" + (unitPrice + 11) + "s" + "%4$-" + 3 + "s" + "%5$" + 12 + "s" + "%6$1s" + Localization.getString("paragon.no_vat");
    }

    public String getVatTableFormat() {
        int[] cols = this.getVatTableCols();
        return "%1$" + (cols[0] + cols[1]) + "s" + "%2$" + cols[2] + "s" + "%3$" + cols[3] + "s" + "%4$" + cols[4] + "s" + "%5$1s";
    }

    public boolean printEmptyVatTableRow() {
        return true;
    }

    public BmpPrinter getEmailPrinter() {
        return BmpPrinter.getInstance();
    }
}

