/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer;

import java.util.Arrays;
import sk.singularisdev.ekasask.enumeration.DISPLAY_CONNECTION_TYPE;
import sk.singularisdev.ekasask.enumeration.DISPLAY_TYPE;
import sk.singularisdev.ekasask.utils.Utility;

public class Display {
    private DISPLAY_CONNECTION_TYPE connectionType = DISPLAY_CONNECTION_TYPE.NONE;
    private String connectionSetting = "";
    private DISPLAY_TYPE displayType = DISPLAY_TYPE.BOWA_STANDARD;
    private byte[] initSequence = new byte[0];
    private int initSequenceResponseTimeout = 0;
    private int initSequenceResponseByteCount = 0;
    private String connectionString;

    public Display() {
        this.setConnectionString(this.connectionType, this.displayType, this.connectionSetting, this.initSequence, this.initSequenceResponseTimeout, this.initSequenceResponseByteCount);
    }

    public DISPLAY_CONNECTION_TYPE getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(DISPLAY_CONNECTION_TYPE connectionType) {
        this.connectionType = connectionType;
        this.setConnectionString(connectionType, this.displayType, this.connectionSetting, this.initSequence, this.initSequenceResponseTimeout, this.initSequenceResponseByteCount);
    }

    public String getConnectionSetting() {
        return this.connectionSetting;
    }

    public void setConnectionSetting(String connectionSetting) {
        this.connectionSetting = connectionSetting;
        this.setConnectionString(this.connectionType, this.displayType, connectionSetting, this.initSequence, this.initSequenceResponseTimeout, this.initSequenceResponseByteCount);
    }

    public DISPLAY_TYPE getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DISPLAY_TYPE displayType) {
        this.displayType = displayType;
        this.setConnectionString(this.connectionType, displayType, this.connectionSetting, this.initSequence, this.initSequenceResponseTimeout, this.initSequenceResponseByteCount);
    }

    public byte[] getInitSequence() {
        return this.initSequence;
    }

    public void setInitSequence(byte[] initSequence) {
        this.initSequence = initSequence;
        this.setConnectionString(this.connectionType, this.displayType, this.connectionSetting, initSequence, this.initSequenceResponseTimeout, this.initSequenceResponseByteCount);
    }

    public int getInitSequenceResponseTimeout() {
        return this.initSequenceResponseTimeout;
    }

    public void setInitSequenceResponseTimeout(int initSequenceResponseTimeout) {
        this.initSequenceResponseTimeout = initSequenceResponseTimeout;
        this.setConnectionString(this.connectionType, this.displayType, this.connectionSetting, this.initSequence, initSequenceResponseTimeout, this.initSequenceResponseByteCount);
    }

    public int getInitSequenceResponseByteCount() {
        return this.initSequenceResponseByteCount;
    }

    public void setInitSequenceResponseByteCount(int initSequenceResponseByteCount) {
        this.initSequenceResponseByteCount = initSequenceResponseByteCount;
        this.setConnectionString(this.connectionType, this.displayType, this.connectionSetting, this.initSequence, this.initSequenceResponseTimeout, initSequenceResponseByteCount);
    }

    private void setConnectionString(DISPLAY_CONNECTION_TYPE connectionType, DISPLAY_TYPE displayType, String connectionSetting, byte[] initSequence, int initSequenceResponseTimeout, int initSequenceResponseByteCount) {
        StringBuilder sb = new StringBuilder();
        sb.append(connectionType.name());
        sb.append(":");
        sb.append(displayType.name());
        sb.append(":");
        sb.append(connectionSetting);
        sb.append(":");
        byte[] byArray = initSequence;
        int n = initSequence.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X", b));
            ++n2;
        }
        sb.append(":");
        sb.append(initSequenceResponseTimeout);
        sb.append(":");
        sb.append(initSequenceResponseByteCount);
        this.connectionString = sb.toString();
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String value) {
        DISPLAY_CONNECTION_TYPE connectionType = DISPLAY_CONNECTION_TYPE.NONE;
        String connectionSetting = "";
        DISPLAY_TYPE displayType = DISPLAY_TYPE.BOWA_STANDARD;
        byte[] initSequence = new byte[]{};
        int initSequenceResponseTimeout = 0;
        int initSequenceResponseByteCount = 0;
        this.connectionString = value;
        if (this.connectionString != null) {
            String[] p = this.connectionString.split(":");
            if (p.length > 0) {
                if (p[0].equals(DISPLAY_CONNECTION_TYPE.NONE.name())) {
                    connectionType = DISPLAY_CONNECTION_TYPE.NONE;
                } else if (p[0].equals(DISPLAY_CONNECTION_TYPE.PARALLEL.name())) {
                    connectionType = DISPLAY_CONNECTION_TYPE.PARALLEL;
                } else if (p[0].equals(DISPLAY_CONNECTION_TYPE.SERIAL.name())) {
                    connectionType = DISPLAY_CONNECTION_TYPE.SERIAL;
                }
            }
            if (p.length > 1 && p[1].equals(DISPLAY_TYPE.BOWA_STANDARD.name())) {
                displayType = DISPLAY_TYPE.BOWA_STANDARD;
            }
            if (p.length > 2) {
                connectionSetting = p[2];
            }
            if (p.length > 3) {
                int len = p[3].length();
                try {
                    byte[] data = new byte[len / 2];
                    int i = 0;
                    while (i < len) {
                        data[i / 2] = (byte)((Character.digit(p[3].charAt(i), 16) << 4) + Character.digit(p[3].charAt(i + 1), 16));
                        i += 2;
                    }
                    initSequence = data;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (p.length > 4) {
                try {
                    initSequenceResponseTimeout = Integer.parseInt(p[4]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (p.length > 5) {
                try {
                    initSequenceResponseByteCount = Integer.parseInt(p[5]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.connectionType = connectionType;
        this.connectionSetting = connectionSetting;
        this.displayType = displayType;
        this.initSequence = initSequence;
        this.initSequenceResponseTimeout = initSequenceResponseTimeout;
        this.initSequenceResponseByteCount = initSequenceResponseByteCount;
        this.setConnectionString(connectionType, displayType, connectionSetting, initSequence, initSequenceResponseTimeout, initSequenceResponseByteCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Display display = (Display)o;
        return Utility.equals((Object)this.connectionType, (Object)display.connectionType) && Utility.equals((Object)this.displayType, (Object)display.displayType) && Utility.equals(this.connectionSetting, display.connectionSetting) && Arrays.equals(this.initSequence, display.initSequence) && Utility.equals(this.initSequenceResponseTimeout, display.initSequenceResponseTimeout) && Utility.equals(this.initSequenceResponseByteCount, display.initSequenceResponseByteCount);
    }
}

