/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;

public class Printer {
    private static final Pattern nonPrintableCharPattern;
    public static final byte[] NON_FISCAL_MARK;

    static {
        NON_FISCAL_MARK = "#".getBytes();
        StringBuilder regex = new StringBuilder();
        regex.append(".*[");
        int ch = 0;
        while (ch < 32) {
            regex.append((char)ch);
            ++ch;
        }
        regex.append('\u007f');
        regex.append("]+.*");
        nonPrintableCharPattern = Pattern.compile(regex.toString());
    }

    public static void validateString(AbstractPrinter printer, String text) throws EKasaException {
        Matcher m = nonPrintableCharPattern.matcher(text);
        if (m.matches()) {
            throw new EKasaException(16L);
        }
        if (text.indexOf(126) == -1) {
            return;
        }
        throw new EKasaException(16L);
    }

    public static String replaceEsc(AbstractPrinter printer, String text) throws EKasaException {
        return Printer.replaceEsc(printer, text, false);
    }

    public static String replaceEsc(AbstractPrinter printer, String text, boolean announcement) throws EKasaException {
        return Printer.replaceEsc(printer, text, true, announcement);
    }

    public static String replaceEsc(AbstractPrinter printer, String text, boolean validate, boolean announcement) throws EKasaException {
        Matcher m;
        if (validate && (m = nonPrintableCharPattern.matcher(text)).matches()) {
            throw new EKasaException(16L);
        }
        text = printer.rewriteEscSequence(text, false, announcement);
        if (validate) {
            if (text.indexOf(126) == -1) {
                return text;
            }
            throw new EKasaException(16L);
        }
        return text;
    }

    public static int getPrintableLength(AbstractPrinter printer, String text, boolean announcement) {
        text = printer.rewriteEscSequence(text, true, announcement);
        return text.length();
    }

    public static byte[] alignText(AbstractPrinter printer, String text, PRINT_ALIGNMENT alignment) throws EKasaException {
        return Printer.alignText(printer, text, alignment, printer.getCharPerRow());
    }

    public static byte[] alignText(AbstractPrinter printer, String text, PRINT_ALIGNMENT alignment, int chars) throws EKasaException {
        return Printer.alignText(printer, text, alignment, chars, false, false);
    }

    public static byte[] alignText(AbstractPrinter printer, String text, PRINT_ALIGNMENT alignment, int chars, boolean addEmptyCharsAfter, boolean announcement) throws EKasaException {
        try {
            int emptyCharsAfter;
            int emptyCharsBefore;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            switch (alignment) {
                case CENTER: {
                    int textLen = Printer.getPrintableLength(printer, text, announcement);
                    emptyCharsBefore = (chars - textLen) / 2;
                    emptyCharsAfter = chars - emptyCharsBefore - textLen;
                    break;
                }
                case RIGHT: {
                    emptyCharsBefore = chars - Printer.getPrintableLength(printer, text, announcement);
                    emptyCharsAfter = 0;
                    break;
                }
                default: {
                    emptyCharsBefore = 0;
                    emptyCharsAfter = chars - emptyCharsBefore - Printer.getPrintableLength(printer, text, announcement);
                    break;
                }
            }
            while (emptyCharsBefore > 0) {
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.SPACE));
                --emptyCharsBefore;
            }
            baos.write(Printer.replaceEsc(printer, text).getBytes(printer.getCharset()));
            if (addEmptyCharsAfter) {
                while (emptyCharsAfter > 0) {
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.SPACE));
                    --emptyCharsAfter;
                }
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public static String formatNumber(long amount, int precision, int size) {
        StringBuilder sb = new StringBuilder();
        boolean negate = false;
        if (amount < 0L) {
            negate = true;
            amount = -amount;
        }
        if (precision > 0) {
            int div = (int)Math.pow(10.0, precision);
            String txt = String.valueOf(negate ? "-" : "") + (int)(amount / (long)div);
            int l = size - precision - 1;
            if (l < 1) {
                l = 1;
            }
            sb.append(String.format("%" + l + "s", txt));
            sb.append(".");
            sb.append(String.format("%0" + precision + "d", amount % (long)div));
        } else {
            String txt = String.valueOf(negate ? "-" : "") + (int)amount;
            sb.append(String.format("%" + size + "s", txt));
        }
        return sb.toString();
    }

    public static String formatNumber(BigDecimal amount, int size) {
        return String.format("%" + size + "s", amount.toString());
    }

    public static String formatString(String text, int size, boolean left) {
        return String.format("%" + (left ? "-" : "") + size + "s", text);
    }

    public static void splitText(List<String> list, String text, int width) {
        Printer.splitText(list, text, width, false);
    }

    public static void splitText(List<String> list, String text, int width, boolean splitByWord) {
        int l = text.length();
        int i = 0;
        while (i < l) {
            if (l - i <= width) {
                list.add(text.substring(i));
            } else {
                String txt = text.substring(i, i + width);
                if (splitByWord && text.charAt(i + width) != ' ') {
                    int j = 0;
                    while (j < width) {
                        if (text.charAt(i + width - j - 1) == ' ') {
                            txt = text.substring(i, i + width - j);
                            i -= j;
                            break;
                        }
                        ++j;
                    }
                }
                list.add(txt);
            }
            i += width;
        }
    }

    public static String getParagonItemSaleFormat(AbstractPrinter printer, boolean platca) throws EKasaException {
        String format = printer.getParagonItemSaleFormat(platca);
        if (!format.contains("%1$") || !format.contains("%2$") || !format.contains("%3$") || !format.contains("%5$") || platca && !format.contains("%7$")) {
            throw new EKasaException(13L);
        }
        return format;
    }

    public static String getParagonItemVoucherFormat(AbstractPrinter printer, boolean platca) throws EKasaException {
        String format = printer.getParagonItemVoucherFormat(platca);
        if (!format.contains("%3$") || !format.contains("%5$") || platca && !format.contains("%7$")) {
            throw new EKasaException(13L);
        }
        return format;
    }

    public static String getVatTableFormat(AbstractPrinter printer) throws EKasaException {
        String format = printer.getVatTableFormat();
        if (!(format.contains("%1$") && format.contains("%2$") && format.contains("%3$") && format.contains("%5$"))) {
            throw new EKasaException(13L);
        }
        return format;
    }
}

