/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.QR_CODE_TYPE;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;

public class Printer1 {
    public static int addInvalidText(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid) throws EKasaException {
        try {
            if (invalid && row % 2 == 0) {
                baos.write(Localization.getString("paragon.invalid").getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            }
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
        return row;
    }

    public static int generHeader(AbstractPrinter printer, PPEKKSetup configuration, long deviceId, ByteArrayOutputStream baos, int row, boolean invalid) throws EKasaException {
        try {
            if (configuration.getIdentity() == null || configuration.getIdentity().getIdentity() == null) {
                throw new EKasaException(28L);
            }
            List<String> header = configuration.getIdentity().getIdentity().getHeader(printer.getCharPerRow(), deviceId);
            for (String text : header) {
                ArrayList<String> lines = new ArrayList<String>();
                Printer.splitText(lines, text, printer.getCharPerRow(), true);
                for (String line : lines) {
                    baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                    Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                }
            }
            String[] header1 = configuration.getConfiguration().getHeader();
            int i = header1.length;
            while (i > 0) {
                if (header1[--i] == null || header1[i].equals("")) continue;
                int j = 0;
                while (j < i + 1) {
                    ArrayList<String> lines = new ArrayList<String>();
                    Printer.splitText(lines, header1[j], printer.getCharPerRow(), true);
                    for (String line : lines) {
                        baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                        baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                    }
                    ++j;
                }
                break block4;
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public static int generAdditionalHeader(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid, String additionalHeader) throws EKasaException {
        try {
            if (additionalHeader == null) {
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
            } else {
                String[] h = additionalHeader.split("(~0D)");
                int i = 0;
                while (i < h.length) {
                    String line = h[i].endsWith("~0A") ? h[i].substring(0, h[i].length() - 3) : h[i];
                    baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                    Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                    ++i;
                }
            }
            baos.write(Printer.replaceEsc(printer, printer.getSingleSeparator()).getBytes(printer.getCharset()));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public static int generQRCode(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid, String uid, String pkp, String okp, String qrCode) throws EKasaException {
        return Printer1.generQRCode(printer, configuration, baos, row, invalid, uid, pkp, okp, qrCode, false);
    }

    public static int generQRCode(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid, String uid, String pkp, String okp, String qrCode, boolean onlyQrCode) throws EKasaException {
        try {
            ArrayList<String> lines;
            QR_CODE_TYPE qrCodeType;
            int chars = printer.getCharPerRow();
            StringBuilder sb = new StringBuilder();
            if (uid != null && !uid.equals("")) {
                qrCodeType = QR_CODE_TYPE.V3_CLM;
                if (!onlyQrCode) {
                    sb.setLength(0);
                    sb.append(Localization.getString("paragon.uid"));
                    sb.append(":");
                    sb.append(uid);
                    lines = new ArrayList();
                    Printer.splitText(lines, sb.toString(), chars);
                    for (String line : lines) {
                        baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                        baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                    }
                }
            } else {
                qrCodeType = QR_CODE_TYPE.V5_CLM;
                if (!onlyQrCode) {
                    sb.setLength(0);
                    sb.append(Localization.getString("paragon.pkp"));
                    sb.append(":");
                    sb.append(pkp);
                    lines = new ArrayList<String>();
                    Printer.splitText(lines, sb.toString(), chars);
                    for (String line : lines) {
                        baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                        baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                        Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                    }
                }
            }
            if (!onlyQrCode) {
                sb.setLength(0);
                sb.append(Localization.getString("paragon.okp"));
                sb.append(":");
                sb.append(okp);
                lines = new ArrayList();
                Printer.splitText(lines, sb.toString(), chars);
                for (String line : lines) {
                    baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                    Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                }
            }
            baos.write(printer.getQrCode(qrCode, qrCodeType));
            if (!onlyQrCode) {
                Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                String txt = new String(Printer.alignText(printer, Localization.getString("paragon.check_qrcode"), PRINT_ALIGNMENT.CENTER), printer.getCharset());
                ArrayList<String> lines2 = new ArrayList<String>();
                Printer.splitText(lines2, txt, printer.getCharPerRow(), true);
                for (String line : lines2) {
                    baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                    Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                }
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    public static int generFooter(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid, String additionalFooter) throws EKasaException {
        try {
            if (additionalFooter != null) {
                String[] h = additionalFooter.split("(~0D)");
                int i = 0;
                while (i < h.length) {
                    String line = h[i].endsWith("~0A") ? h[i].substring(0, h[i].length() - 3) : h[i];
                    baos.write(Printer.replaceEsc(printer, line).getBytes(printer.getCharset()));
                    baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                    Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                    ++i;
                }
            }
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public static int alignRight(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid, String text, String addText) throws EKasaException {
        return Printer1.alignRight(printer, configuration, baos, row, invalid, text, addText, printer.getCharPerRow(), false);
    }

    public static int alignRight(AbstractPrinter printer, PPEKKSetup configuration, ByteArrayOutputStream baos, int row, boolean invalid, String text, String addText, int chars, boolean announcement) throws EKasaException {
        try {
            int l = Printer.getPrintableLength(printer, text, announcement);
            int emptyChars = chars - l % chars;
            baos.write(Printer.replaceEsc(printer, text).getBytes(printer.getCharset()));
            if (emptyChars < 9) {
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
                emptyChars = chars;
            }
            baos.write(Printer.alignText(printer, addText, PRINT_ALIGNMENT.RIGHT, emptyChars, false, announcement));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            Printer1.addInvalidText(printer, configuration, baos, ++row, invalid);
            return row;
        }
        catch (IOException e) {
            throw new EKasaException(13L);
        }
    }

    public static int printField(int charPerRow, PPEKKSetup configuration, boolean printInvalid, AbstractPrinter printer, ByteArrayOutputStream baos, int row, boolean space, String[] params) throws EKasaException, IOException {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            if (sb.length() + text.length() > charPerRow) {
                baos.write(Printer.replaceEsc(printer, sb.toString()).getBytes(printer.getCharset()));
                baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                Printer1.addInvalidText(printer, configuration, baos, ++row, printInvalid);
                sb.setLength(0);
            }
            if (space && sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(text);
            ++n2;
        }
        if (sb.length() > 0) {
            baos.write(Printer.replaceEsc(printer, sb.toString()).getBytes(printer.getCharset()));
            baos.write(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            Printer1.addInvalidText(printer, configuration, baos, ++row, printInvalid);
            sb.setLength(0);
        }
        return row;
    }
}

