/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer;

import sk.singularisdev.common.image.Image;
import sk.singularisdev.ekasask.printer.PrinterRenderer;
import sk.singularisdev.ekasask.printer.PrinterRendererFactory;
import sk.singularisdev.ekasask.printer.driver.BmpPrinter;

public class RendererWorker {
    private static PrinterRenderer printerRenderer;

    static {
        String className = System.getProperty("java.specification.vendor").toUpperCase().contains("ANDROID") ? "sk.singularisdev.platform.android.printer.AndroidPrinterRenderer$Factory" : "sk.singularisdev.platform.desktop.printer.AwtPrinterRenderer$Factory";
        try {
            Class<?> clazz = Class.forName(className);
            PrinterRendererFactory printerRendererFactory = (PrinterRendererFactory)clazz.newInstance();
            printerRenderer = printerRendererFactory.createInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static PrinterRenderer getPrinterRenderer() {
        return printerRenderer;
    }

    public static void setPrinterRenderer(PrinterRenderer printerRenderer) {
        RendererWorker.printerRenderer = printerRenderer;
    }

    public static Image render(BmpPrinter emailPrinter, byte[] data) {
        return printerRenderer.render(emailPrinter, data);
    }
}

