/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.db.DbTransactionStatusFetchListenerInterface;
import sk.singularisdev.ekasask.db.TransactionStatus;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.printer.Printer1;

public class UnsendedTransactionPrint
implements DbTransactionStatusFetchListenerInterface {
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private AbstractPrinter printer;
    private PPEKKSetup configuration;

    public UnsendedTransactionPrint(AbstractPrinter printer, PPEKKSetup configuration, byte[] header) throws EKasaException {
        try {
            this.printer = printer;
            this.configuration = configuration;
            this.baos.write(header);
        }
        catch (Exception e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    @Override
    public void onNextRecord(TransactionStatus transactionStatus) throws EKasaException {
        try {
            String[] data;
            int chars = this.printer.getCharPerRow();
            String[] stringArray = data = (transactionStatus.getUnsendReport() == null ? "" : transactionStatus.getUnsendReport()).split("\n");
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                String text = stringArray[n2];
                ArrayList<String> lines = new ArrayList<String>();
                Printer.splitText(lines, text, chars);
                for (String line : lines) {
                    this.baos.write(Printer.replaceEsc(this.printer, line).getBytes(this.printer.getCharset()));
                    this.baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
                }
                ++n2;
            }
            this.baos.write(this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF));
            if (transactionStatus.getQrCode() != null && !transactionStatus.getQrCode().equals("")) {
                Printer1.generQRCode(this.printer, this.configuration, this.baos, 0, false, null, null, null, transactionStatus.getQrCode(), true);
            }
        }
        catch (Exception e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    public byte[] getData() {
        return this.baos.toByteArray();
    }
}

