/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer.driver;

import com.google.zxing.WriterException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import sk.singularisdev.common.image.Image;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.enumeration.BARCODE_TYPE;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.QR_CODE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.PrinterEsc;
import sk.singularisdev.ekasask.printer.PrinterStatus;
import sk.singularisdev.ekasask.printer.RendererWorker;
import sk.singularisdev.ekasask.printer.driver.BMPRewriter;
import sk.singularisdev.ekasask.utils.QRCode;

public class BmpPrinter
extends AbstractPrinter {
    public static String CHARSET_NAME = "CP852";
    private static final byte[] DEFAULT_ESC_CR = new byte[]{13};
    private static final byte[] DEFAULT_ESC_LF = new byte[]{10};
    private static final byte[] DEFAULT_ESC_CRLF = new byte[]{13, 10};
    private static final byte[] DEFAULT_ESC_OREZ = new byte[0];
    private static final byte[] DEFAULT_ESC_LINE_PREFIX = new byte[0];
    private static final byte[] DEFAULT_ESC_FONT_CONDENSE_ON = new byte[]{27, 33, 1};
    private static final byte[] DEFAULT_ESC_FONT_CONDENSE_OFF;
    private static final byte[] DEFAULT_ESC_LINE_CONDENSE_ON;
    private static final byte[] DEFAULT_ESC_LINE_CONDENSE_OFF;
    private static final byte[] DEFAULT_ESC_FONT_SLOVAK;
    private static final byte[] DEFAULT_ESC_EURO;
    private static final byte[] DEFAULT_ESC_DOUBLE_CHAR_ON;
    private static final byte[] DEFAULT_ESC_DOUBLE_CHAR_OFF;
    private static final byte[] DEFAULT_ESC_DEFAULT;
    private static final byte[] DEFAULT_ESC_ALIGNMENT_LEFT;
    private static final byte[] DEFAULT_ESC_ALIGNMENT_CENTER;
    private static final byte[] DEFAULT_ESC_ALIGNMENT_RIGHT;
    private static final byte[] DEFAULT_ESC_SPACE;
    private static final int QR_CODE_SIZE = 180;

    static {
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 33;
        DEFAULT_ESC_FONT_CONDENSE_OFF = byArray;
        DEFAULT_ESC_LINE_CONDENSE_ON = new byte[]{27, 51, 8};
        DEFAULT_ESC_LINE_CONDENSE_OFF = new byte[]{27, 50};
        DEFAULT_ESC_FONT_SLOVAK = new byte[]{27, 116, -1};
        DEFAULT_ESC_EURO = new byte[]{27, 116, 19, -43, 27, 116, -1};
        DEFAULT_ESC_DOUBLE_CHAR_ON = new byte[]{29, 33, 16};
        byte[] byArray2 = new byte[3];
        byArray2[0] = 29;
        byArray2[1] = 33;
        DEFAULT_ESC_DOUBLE_CHAR_OFF = byArray2;
        byte[] byArray3 = new byte[32];
        byArray3[0] = 27;
        byArray3[1] = 32;
        byArray3[3] = 27;
        byArray3[4] = 45;
        byArray3[6] = 27;
        byArray3[7] = 50;
        byArray3[8] = 27;
        byArray3[9] = 69;
        byArray3[11] = 27;
        byArray3[12] = 71;
        byArray3[14] = 29;
        byArray3[15] = 33;
        byArray3[17] = 29;
        byArray3[18] = 80;
        byArray3[21] = 27;
        byArray3[22] = 37;
        byArray3[24] = 27;
        byArray3[25] = 33;
        byArray3[27] = 27;
        byArray3[28] = 50;
        byArray3[29] = 27;
        byArray3[30] = 116;
        byArray3[31] = -1;
        DEFAULT_ESC_DEFAULT = byArray3;
        byte[] byArray4 = new byte[3];
        byArray4[0] = 27;
        byArray4[1] = 97;
        DEFAULT_ESC_ALIGNMENT_LEFT = byArray4;
        DEFAULT_ESC_ALIGNMENT_CENTER = new byte[]{27, 97, 1};
        DEFAULT_ESC_ALIGNMENT_RIGHT = new byte[]{27, 97, 2};
        DEFAULT_ESC_SPACE = new byte[]{32};
    }

    protected BmpPrinter() {
        this.charset = Charset.forName(CHARSET_NAME);
    }

    public static BmpPrinter getInstance() {
        return new BmpPrinter();
    }

    @Override
    public byte[] getEscSequence(PRINT_SEQUENCE_TYPE sequenceType) {
        switch (sequenceType) {
            case CR: {
                return DEFAULT_ESC_CR;
            }
            case LF: {
                return DEFAULT_ESC_LF;
            }
            case CRLF: {
                return DEFAULT_ESC_CRLF;
            }
            case OREZ: {
                return DEFAULT_ESC_OREZ;
            }
            case LINE_PREFIX: {
                return DEFAULT_ESC_LINE_PREFIX;
            }
            case FONT_CONDENSE_ON: {
                return DEFAULT_ESC_FONT_CONDENSE_ON;
            }
            case FONT_CONDENSE_OFF: {
                return DEFAULT_ESC_FONT_CONDENSE_OFF;
            }
            case LINE_CONDENSE_ON: {
                return DEFAULT_ESC_LINE_CONDENSE_ON;
            }
            case LINE_CONDENSE_OFF: {
                return DEFAULT_ESC_LINE_CONDENSE_OFF;
            }
            case FONT_SLOVAK: {
                return DEFAULT_ESC_FONT_SLOVAK;
            }
            case EURO: {
                return DEFAULT_ESC_EURO;
            }
            case DOUBLE_CHAR_ON: {
                return DEFAULT_ESC_DOUBLE_CHAR_ON;
            }
            case DOUBLE_CHAR_OFF: {
                return DEFAULT_ESC_DOUBLE_CHAR_OFF;
            }
            case DEFAULT: {
                return DEFAULT_ESC_DEFAULT;
            }
            case ALIGNMENT_LEFT: {
                return DEFAULT_ESC_ALIGNMENT_LEFT;
            }
            case ALIGNMENT_CENTER: {
                return DEFAULT_ESC_ALIGNMENT_CENTER;
            }
            case ALIGNMENT_RIGHT: {
                return DEFAULT_ESC_ALIGNMENT_RIGHT;
            }
            case SPACE: {
                return DEFAULT_ESC_SPACE;
            }
        }
        return new byte[0];
    }

    @Override
    public byte[] getAlignment(PRINT_ALIGNMENT alignment) {
        switch (alignment) {
            case LEFT: {
                return DEFAULT_ESC_ALIGNMENT_LEFT;
            }
            case CENTER: {
                return DEFAULT_ESC_ALIGNMENT_CENTER;
            }
            case RIGHT: {
                return DEFAULT_ESC_ALIGNMENT_RIGHT;
            }
        }
        return new byte[0];
    }

    @Override
    public int getCharPerRow() {
        return 40;
    }

    @Override
    public boolean isQRsupport() {
        return false;
    }

    @Override
    public int getDotsPerLine() {
        return 512;
    }

    @Override
    public byte[] getBarcode(String barcode, BARCODE_TYPE barcodeType, BARCODE_TEXT_POSITION textPosition, BARCODE_FONT_SIZE fontSize, int bcHeight, int bcWidth) throws EKasaException {
        return new byte[0];
    }

    @Override
    public byte[] printImage(int width, int height, byte[] bmp) throws EKasaException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int w = (width + 7) / 8 * 8;
        int h = (height + 7) / 8;
        int firstY = 0;
        while (firstY < h) {
            int lengthY = firstY + 48 < h ? 48 : h - firstY;
            baos.write(29);
            baos.write(42);
            baos.write((byte)((width + 7) / 8));
            baos.write((byte)lengthY);
            int x = 0;
            while (x < w) {
                int y = 0;
                while (y < lengthY) {
                    int p = (firstY + y) * w + x;
                    baos.write(bmp[p]);
                    ++p;
                    ++y;
                }
                ++x;
            }
            baos.write(29);
            baos.write(47);
            baos.write(3);
            firstY += 48;
        }
        return baos.toByteArray();
    }

    @Override
    public PrinterEsc[] getPrinterStatusEsc() {
        return new PrinterEsc[0];
    }

    @Override
    public PrinterEsc getPrinterConnectionStatus() {
        return null;
    }

    @Override
    public PrinterStatus parsePrinterStatus(PrinterEsc[] esc) {
        PrinterStatus status = new PrinterStatus();
        return status;
    }

    @Override
    public byte[] loadNvImage(int count, byte[] data) throws EKasaException {
        return new byte[0];
    }

    @Override
    public byte[] printNvImage(int index) throws EKasaException {
        return new byte[0];
    }

    @Override
    public byte[] getQrCode(String qrCode, QR_CODE_TYPE qrCodeType) throws EKasaException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int size = 180;
            byte[] bmp = QRCode.generateQRCodeImage(qrCode, size, size, qrCodeType);
            baos.write(this.getAlignment(PRINT_ALIGNMENT.CENTER));
            baos.write(this.printImage(size, size, bmp));
            baos.write(this.getAlignment(PRINT_ALIGNMENT.LEFT));
            return baos.toByteArray();
        }
        catch (EKasaException e) {
            throw e;
        }
        catch (IOException e) {
            throw new EKasaException(13L, (Throwable)e);
        }
        catch (WriterException e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    @Override
    public String rewriteEscSequence(String text, boolean printable, boolean announcement) {
        text = BMPRewriter.REWRITER_ALLOW_PANEL_BUTTON.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_CR.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_CUTTER.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_DOUBLE_STRIKE.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_DOUBLE_WIDTH.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_EMPHASIZED.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_LF.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_REVERSE.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_ROTATE.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_LOGO.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_SHUFFLE.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_UNDERLINE.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_UPSIDE_DOWN.rewrite(text, this.getCharset(), printable, this);
        text = BMPRewriter.REWRITER_EURO.rewrite(text, this.getCharset(), printable, this);
        return text;
    }

    @Override
    public int[] getVatTableCols() {
        int[] nArray = new int[6];
        nArray[1] = 6;
        nArray[2] = 11;
        nArray[3] = 11;
        nArray[4] = 11;
        return nArray;
    }

    @Override
    public String getVatTableFormat() {
        return "%1$6s%2$11s%3$11s%4$11s%5$1s";
    }

    public Image render(byte[] data) {
        return RendererWorker.render(this, data);
    }
}

