/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer.utility;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.printer.AbstractPrinter;

public abstract class Rewriter {
    private Pattern pattern;
    private Matcher matcher;
    private Charset charset;
    private String printableString;

    public Rewriter(String regex, String printableString) {
        this.pattern = Pattern.compile(regex);
        this.printableString = printableString;
    }

    public String group(int i) {
        return this.matcher.group(i);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public abstract String replacement(AbstractPrinter var1);

    public String rewrite(CharSequence original, Charset charset, AbstractPrinter printer) {
        return this.rewrite(original, charset, false, printer);
    }

    public String rewrite(CharSequence original, Charset charset, boolean printable, AbstractPrinter printer) {
        this.charset = charset;
        this.matcher = this.pattern.matcher(original);
        StringBuffer result = new StringBuffer(original.length());
        while (this.matcher.find()) {
            this.matcher.appendReplacement(result, "");
            if (printable) {
                result.append(this.printableString);
                continue;
            }
            result.append(this.replacement(printer));
        }
        this.matcher.appendTail(result);
        return result.toString();
    }
}

