/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.sfs;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import sk.singularisdev.ekasask.utils.EKasaXML;

public final class EKasaReturn {
    public static final int OK = 0;
    public static final int TIMEOUT = -999999;
    public static final int UNKNOWN_RESPONSE_STATUS_ERROR = -999997;
    private int status;
    private String okp;
    private String pkp;
    private String uid;
    private String qrCode;
    private String request;
    private String response;
    private String errorMessage;
    private String originTransactionId;
    private String receiptNumber;
    private String receiptMonth;

    public EKasaReturn(int status, String okp, String pkp, String uid, String qrCode, String request, String response, String errorMessage, String originTransactionId, String receiptNumber, String xmlCreateDate) {
        this.status = status;
        this.okp = okp;
        if (pkp != null) {
            pkp = pkp.replaceAll("\n", "").replaceAll("\r", "");
        }
        this.pkp = pkp;
        this.uid = uid;
        this.qrCode = qrCode;
        this.request = request;
        this.response = response;
        this.errorMessage = errorMessage;
        this.originTransactionId = originTransactionId;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        try {
            this.receiptMonth = sdf.format(EKasaXML.parseDate(xmlCreateDate));
        }
        catch (ParseException e) {
            this.receiptMonth = "";
        }
        this.receiptNumber = receiptNumber;
    }

    public int getStatus() {
        return this.status;
    }

    public String getOkp() {
        return this.okp;
    }

    public String getPkp() {
        return this.pkp;
    }

    public String getUid() {
        return this.uid;
    }

    public String getQRCode() {
        return this.qrCode;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public String getReceiptMonth() {
        return this.receiptMonth;
    }

    public static String generQRCode(String okp, String dkp, String creationDate, String orderNumber, String amount) {
        StringBuilder sb = new StringBuilder();
        sb.append(okp);
        sb.append(":");
        sb.append(dkp);
        sb.append(":");
        creationDate = creationDate.replace("-", "");
        creationDate = creationDate.replace(":", "");
        creationDate = creationDate.replace("T", "");
        creationDate = creationDate.substring(2, 14);
        sb.append(creationDate);
        sb.append(":");
        sb.append(orderNumber);
        sb.append(":");
        sb.append(amount);
        return sb.toString();
    }

    public static String generQRCode(String uid) {
        return uid;
    }

    public String getOriginTransactionId() {
        return this.originTransactionId;
    }
}

