/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.sfs;

import com.notasoftwarecompany.ekasa.PreparedRequest;
import com.notasoftwarecompany.ekasa.RequestObject;
import com.notasoftwarecompany.ekasa.ResponseObject;
import com.notasoftwarecompany.ekasa.location.Location;
import com.notasoftwarecompany.ekasa.receipt.Receipt;
import java.io.ByteArrayInputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.net.ssl.SSLHandshakeException;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.ErrorListenerInterface;
import sk.singularisdev.ekasask.PPEKK;
import sk.singularisdev.ekasask.PPEKKAuthentication;
import sk.singularisdev.ekasask.PPEKKConfiguration;
import sk.singularisdev.ekasask.PPEKKIdentity;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.chdu.ChduTransaction;
import sk.singularisdev.ekasask.chdu.SfsDataRequest;
import sk.singularisdev.ekasask.command.CorrectHelper;
import sk.singularisdev.ekasask.command.EKasaServerMessageInterface;
import sk.singularisdev.ekasask.command.InvalidReceipt;
import sk.singularisdev.ekasask.command.Receipt;
import sk.singularisdev.ekasask.db.TransactionStatus;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.sfs.EKasaReturn;
import sk.singularisdev.ekasask.utils.EKasaXML;
import sk.singularisdev.ekasask.xmlparser.AuthenticationData;
import sk.singularisdev.ekasask.xmlparser.IdentityData;

public final class EKasaServer {
    private static final Logger logger = LoggerManager.getLogger(EKasaServer.class.getName());
    private UUID uuid;
    private PPEKK ppekk;
    private com.notasoftwarecompany.ekasa.Configuration configuration = null;
    private AuthenticationData authentication = null;
    private String password = null;

    private EKasaServer(PPEKK ppekk, UUID uuid) {
        this.ppekk = ppekk;
        this.uuid = uuid;
    }

    public static EKasaServer getInstance(PPEKK ppekk, UUID uuid) {
        return new EKasaServer(ppekk, uuid);
    }

    public EKasaReturn sendToServer(UUID uuid, TransactionStatus correctionTransactionStatus, String transactionId, EKasaServerMessageInterface message, byte[] paragonCopy) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        PPEKKSetup chduConfiguration = this.ppekk.getChduConfiguration(uuid);
        String chduSn = this.ppekk.getCHDU(uuid).getSN();
        if (chduSn == null) {
            throw new EKasaException(41L);
        }
        PPEKKConfiguration cfg = chduConfiguration.getConfiguration();
        if (cfg == null) {
            throw new EKasaException(10L);
        }
        PPEKKAuthentication auth = chduConfiguration.getAuthentication();
        if (auth == null) {
            throw new EKasaException(22L);
        }
        AuthenticationData authentication = auth.getAuthentication();
        if (authentication == null) {
            throw new EKasaException(22L);
        }
        String password = auth.getAuthenticationPassword();
        if (password == null) {
            throw new EKasaException(29L);
        }
        PPEKKIdentity ident = chduConfiguration.getIdentity();
        if (ident == null) {
            throw new EKasaException(28L);
        }
        IdentityData identity = ident.getIdentity();
        if (identity == null) {
            throw new EKasaException(28L);
        }
        if (this.configuration == null || !authentication.equals(this.authentication) || !password.equals(this.password)) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(authentication.getKeystoreData());
                KeyStore keystore = KeyStore.getInstance(authentication.getKeyStoreType());
                keystore.load(stream, password.toCharArray());
                this.configuration = new com.notasoftwarecompany.ekasa.Configuration(keystore, authentication.getCertificateAlias(), password, this.ppekk.getSwId(), Configuration.getSfsUrl(), Configuration.getSfsPort());
                this.configuration.setDebug(false);
                int timeout = Configuration.getSendTimeout();
                this.configuration.setTimeout(timeout < 2000 ? 2000 : timeout);
                this.authentication = authentication;
                this.password = password;
            }
            catch (Exception e) {
                logger.debug("EKasaServer.sendToServer()", e);
                throw new EKasaException(19L, (Throwable)e);
            }
        }
        try {
            TransactionStatus[] transactionStatuses;
            SfsDataRequest sfsData;
            String qrCode;
            String receiptNumber;
            Date createDate;
            int counter;
            SfsDataRequest.RequestType requestType;
            RequestObject requestObject = message.getSFSObject(chduConfiguration);
            String unsendReport = this.getUnsendDataMessage(chduConfiguration, requestObject, message);
            String originTransactionId = null;
            String retryTransactionId = null;
            EKasaReturn rVal = null;
            if (requestObject instanceof com.notasoftwarecompany.ekasa.receipt.Receipt) {
                requestType = SfsDataRequest.RequestType.RECEIPT;
                com.notasoftwarecompany.ekasa.receipt.Receipt receiptObject = (com.notasoftwarecompany.ekasa.receipt.Receipt)requestObject;
                counter = 1;
                createDate = EKasaXML.parseDate(receiptObject.getCreateDate());
                if (correctionTransactionStatus == null) {
                    receiptNumber = receiptObject.getReceiptNumber();
                } else {
                    receiptNumber = correctionTransactionStatus.getReceiptNumber();
                    counter = correctionTransactionStatus.getCounter() + 1;
                    originTransactionId = correctionTransactionStatus.getOriginTransactionId();
                    retryTransactionId = correctionTransactionStatus.getTransactionId();
                }
                receiptObject.setCounter("" + counter);
                receiptObject.setException(EKasaXML.formatBoolean(chduConfiguration.getConfiguration().getException48()));
                receiptObject.setDic(identity.getDic());
                receiptObject.setIcDph(identity.getIcdph());
                receiptObject.setIco(identity.getIco());
                receiptObject.setCashRegisterCode(identity.getOrganizationUnit().getCashRegisterCode());
                PreparedRequest request = receiptObject.prepareRequest(this.configuration);
                qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                sfsData = new SfsDataRequest(requestType, createDate, receiptNumber, request.getRequest(), qrCode, paragonCopy, unsendReport, retryTransactionId, originTransactionId, message.getUUID(), counter);
                ChduTransaction chduTransaction = new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_REQUEST, transactionId, sfsData.serialize());
                this.ppekk.getCHDU(uuid).setChduTransaction(chduTransaction);
                try {
                    ResponseObject responseObject = requestObject.sendData(this.configuration);
                    String errorMessage = null;
                    int status = 0;
                    if (responseObject.getStatus().equalsIgnoreCase("success")) {
                        qrCode = EKasaReturn.generQRCode(responseObject.getUID());
                    } else {
                        if (responseObject.getErrorCode() != null) {
                            status = Integer.parseInt(responseObject.getErrorCode());
                            errorMessage = responseObject.getErrorReason();
                        } else {
                            status = -999997;
                            errorMessage = Localization.getString("error.response.unknown_response_state");
                        }
                        qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    }
                    rVal = new EKasaReturn(status, responseObject.getOkp(), responseObject.getPkp(), responseObject.getUID(), qrCode, responseObject.getRequest(), responseObject.getResponse(), errorMessage, originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (ConnectException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (SocketTimeoutException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (UnknownHostException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (NoRouteToHostException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (SSLHandshakeException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (Exception e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, e.getMessage(), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                    try {
                        ErrorListenerInterface eli = Configuration.getErrorListener();
                        if (eli != null) {
                            eli.errorException(e);
                        }
                    }
                    catch (Exception ex) {
                        logger.fatal("", ex);
                    }
                }
            } else if (requestObject instanceof Location) {
                requestType = SfsDataRequest.RequestType.LOCATION;
                Location locationObject = (Location)requestObject;
                createDate = EKasaXML.parseDate(locationObject.getCreateDate());
                counter = 1;
                if (correctionTransactionStatus == null) {
                    receiptNumber = null;
                } else {
                    receiptNumber = null;
                    counter = correctionTransactionStatus.getCounter() + 1;
                    originTransactionId = correctionTransactionStatus.getOriginTransactionId();
                    retryTransactionId = correctionTransactionStatus.getTransactionId();
                }
                locationObject.setCounter("" + counter);
                locationObject.setDic(identity.getDic());
                locationObject.setCashRegisterCode(identity.getOrganizationUnit().getCashRegisterCode());
                PreparedRequest request = requestObject.prepareRequest(this.configuration);
                sfsData = new SfsDataRequest(requestType, createDate, receiptNumber, request.getRequest(), "", paragonCopy, unsendReport, retryTransactionId, originTransactionId, message.getUUID(), counter);
                this.ppekk.getCHDU(uuid).setChduTransaction(new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_REQUEST, transactionId, sfsData.serialize()));
                qrCode = "";
                try {
                    ResponseObject responseObject = requestObject.sendData(this.configuration);
                    String errorMessage = null;
                    int status = 0;
                    if (!responseObject.getStatus().equalsIgnoreCase("success")) {
                        if (responseObject.getErrorCode() != null) {
                            status = Integer.parseInt(responseObject.getErrorCode());
                            errorMessage = responseObject.getErrorReason();
                        } else {
                            status = -999997;
                            errorMessage = Localization.getString("error.response.unknown_response_state");
                        }
                    }
                    rVal = new EKasaReturn(status, responseObject.getOkp(), responseObject.getPkp(), responseObject.getUID(), qrCode, responseObject.getRequest(), responseObject.getResponse(), errorMessage, originTransactionId, "", locationObject.getCreateDate());
                }
                catch (ConnectException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (SocketTimeoutException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (UnknownHostException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (NoRouteToHostException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (SSLHandshakeException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (Exception e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, e.getMessage(), originTransactionId, "", locationObject.getCreateDate());
                    try {
                        ErrorListenerInterface eli = Configuration.getErrorListener();
                        if (eli != null) {
                            eli.errorException(e);
                        }
                    }
                    catch (Exception ex) {
                        logger.fatal("", ex);
                    }
                }
            } else {
                throw new EKasaException(5L);
            }
            if (correctionTransactionStatus == null) {
                transactionStatuses = new TransactionStatus[]{new TransactionStatus(chduSn, requestType, rVal.getRequest(), message.getUUID(), transactionId, rVal.getStatus(), transactionId, null, null, qrCode, sfsData.getParagonCopyPrint(), unsendReport, createDate, receiptNumber, counter)};
            } else {
                correctionTransactionStatus.setNextTransactionId(transactionId);
                transactionStatuses = new TransactionStatus[]{correctionTransactionStatus, new TransactionStatus(chduSn, requestType, rVal.getRequest(), message.getUUID(), transactionId, rVal.getStatus(), originTransactionId, retryTransactionId, null, qrCode, sfsData.getParagonCopyPrint(), unsendReport, createDate, receiptNumber, counter)};
            }
            this.ppekk.getDb(uuid).setTransactionStatus(transactionStatuses);
            return rVal;
        }
        catch (EKasaException e) {
            logger.debug("EKasaServer.sendToServer()", e);
            throw e;
        }
        catch (Exception e) {
            logger.debug("EKasaServer.sendToServer()", e);
            throw new EKasaException(19L, (Throwable)e);
        }
    }

    public EKasaReturn resendToServer(UUID uuid, String transactionId, SfsDataRequest originRequest, TransactionStatus transactionStatus) throws EKasaException {
        if (!uuid.equals(this.uuid)) {
            throw new EKasaException(6L);
        }
        PPEKKSetup setup = this.ppekk.getChduConfiguration(uuid);
        if (setup == null) {
            throw new EKasaException(10L);
        }
        if (setup.getConfiguration() == null) {
            throw new EKasaException(10L);
        }
        PPEKKAuthentication auth = setup.getAuthentication();
        if (auth == null) {
            throw new EKasaException(22L);
        }
        AuthenticationData authentication = auth.getAuthentication();
        if (authentication == null) {
            throw new EKasaException(22L);
        }
        String password = auth.getAuthenticationPassword();
        if (password == null) {
            throw new EKasaException(29L);
        }
        PPEKKIdentity ident = setup.getIdentity();
        if (ident == null) {
            throw new EKasaException(28L);
        }
        IdentityData identity = ident.getIdentity();
        if (identity == null) {
            throw new EKasaException(28L);
        }
        if (this.configuration == null || !authentication.equals(this.authentication) || !password.equals(this.password)) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(authentication.getKeystoreData());
                KeyStore keystore = KeyStore.getInstance(authentication.getKeyStoreType());
                keystore.load(stream, password.toCharArray());
                this.configuration = new com.notasoftwarecompany.ekasa.Configuration(keystore, authentication.getCertificateAlias(), password, this.ppekk.getSwId(), Configuration.getSfsUrl(), Configuration.getSfsPort());
                int timeout = Configuration.getResendTimeout() < 2000 ? 2000 : Configuration.getResendTimeout();
                this.configuration.setTimeout(timeout);
                this.configuration.setDebug(false);
                this.authentication = authentication;
                this.password = password;
            }
            catch (Exception e) {
                logger.debug("EKasaServer.resendToServer()", e);
                throw new EKasaException(19L, (Throwable)e);
            }
        }
        try {
            PreparedRequest request;
            int counter;
            EKasaReturn rVal = null;
            String originTransactionId = transactionStatus.getOriginTransactionId();
            if (originRequest.getRequestType() == SfsDataRequest.RequestType.RECEIPT) {
                counter = originRequest.getRetryCounter() + 1;
                com.notasoftwarecompany.ekasa.receipt.Receipt receiptObject = com.notasoftwarecompany.ekasa.receipt.Receipt.getInstance(originRequest.getRequest());
                receiptObject.setCounter("" + counter);
                receiptObject.setException(EKasaXML.formatBoolean(setup.getConfiguration().getException48()));
                receiptObject.setDic(identity.getDic());
                receiptObject.setIcDph(identity.getIcdph());
                receiptObject.setIco(identity.getIco());
                receiptObject.setCashRegisterCode(identity.getOrganizationUnit().getCashRegisterCode());
                Date createDate = EKasaXML.parseDate(receiptObject.getCreateDate());
                String receiptNumber = receiptObject.getReceiptNumber();
                request = receiptObject.prepareRequest(this.configuration);
                String qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                SfsDataRequest sfsData = new SfsDataRequest(SfsDataRequest.RequestType.RECEIPT, createDate, receiptNumber, request.getRequest(), qrCode, originRequest.getParagonCopyPrint(), originRequest.getUnsendReport(), transactionStatus.getTransactionId(), originTransactionId, originRequest.getMessageUuid(), counter);
                this.ppekk.getCHDU(uuid).setChduTransaction(new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_REQUEST, transactionId, sfsData.serialize()));
                try {
                    ResponseObject responseObject = receiptObject.sendData(this.configuration);
                    String errorMessage = null;
                    int status = 0;
                    if (responseObject.getStatus().equalsIgnoreCase("success")) {
                        qrCode = EKasaReturn.generQRCode(responseObject.getUID());
                    } else {
                        if (responseObject.getErrorCode() != null) {
                            status = Integer.parseInt(responseObject.getErrorCode());
                            errorMessage = responseObject.getErrorReason();
                        } else {
                            status = -999997;
                            errorMessage = Localization.getString("error.response.unknown_response_state");
                        }
                        qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    }
                    rVal = new EKasaReturn(status, responseObject.getOkp(), responseObject.getPkp(), responseObject.getUID(), qrCode, responseObject.getRequest(), responseObject.getResponse(), errorMessage, originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (ConnectException e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (UnknownHostException e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (NoRouteToHostException e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (SSLHandshakeException e) {
                    logger.debug("EKasaServer.sendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (SocketTimeoutException e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                }
                catch (Exception e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    qrCode = EKasaReturn.generQRCode(request.getOkp(), identity.getOrganizationUnit().getCashRegisterCode(), receiptObject.getCreateDate(), receiptObject.getReceiptNumber(), receiptObject.getAmount());
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, qrCode, request.getRequest(), null, e.getMessage(), originTransactionId, receiptObject.getReceiptNumber(), receiptObject.getCreateDate());
                    try {
                        ErrorListenerInterface eli = Configuration.getErrorListener();
                        if (eli != null) {
                            eli.errorException(e);
                        }
                    }
                    catch (Exception ex) {
                        logger.fatal("", ex);
                    }
                }
            } else if (originRequest.getRequestType() == SfsDataRequest.RequestType.LOCATION) {
                counter = originRequest.getRetryCounter() + 1;
                Location locationObject = Location.getInstance(originRequest.getRequest());
                locationObject.setCounter("" + counter);
                locationObject.setDic(identity.getDic());
                locationObject.setCashRegisterCode(identity.getOrganizationUnit().getCashRegisterCode());
                Date createDate = EKasaXML.parseDate(locationObject.getCreateDate());
                request = locationObject.prepareRequest(this.configuration);
                String qrCode = "";
                SfsDataRequest sfsData = new SfsDataRequest(SfsDataRequest.RequestType.LOCATION, createDate, null, request.getRequest(), qrCode, originRequest.getParagonCopyPrint(), originRequest.getUnsendReport(), transactionStatus.getTransactionId(), originTransactionId, originRequest.getMessageUuid(), counter);
                this.ppekk.getCHDU(uuid).setChduTransaction(new ChduTransaction(ChduTransaction.TRANSACTION_TYPE.SFS_REQUEST, transactionId, sfsData.serialize()));
                try {
                    ResponseObject responseObject = locationObject.sendData(this.configuration);
                    String errorMessage = null;
                    int status = 0;
                    if (!responseObject.getStatus().equalsIgnoreCase("success")) {
                        if (responseObject.getErrorCode() != null) {
                            status = Integer.parseInt(responseObject.getErrorCode());
                            errorMessage = responseObject.getErrorReason();
                        } else {
                            status = -999997;
                            errorMessage = Localization.getString("error.response.unknown_response_state");
                        }
                    }
                    rVal = new EKasaReturn(status, responseObject.getOkp(), responseObject.getPkp(), responseObject.getUID(), "", responseObject.getRequest(), responseObject.getResponse(), errorMessage, originTransactionId, "", locationObject.getCreateDate());
                }
                catch (ConnectException e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (NoRouteToHostException e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (SSLHandshakeException e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (UnknownHostException e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (SocketTimeoutException e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, Localization.getString("error.response.timeout"), originTransactionId, "", locationObject.getCreateDate());
                }
                catch (Exception e) {
                    logger.debug("EKasaServer.resendToServer()", e);
                    rVal = new EKasaReturn(-999999, request.getOkp(), request.getPkp(), null, "", request.getRequest(), null, e.getMessage(), originTransactionId, "", locationObject.getCreateDate());
                    try {
                        ErrorListenerInterface eli = Configuration.getErrorListener();
                        if (eli != null) {
                            eli.errorException(e);
                        }
                    }
                    catch (Exception ex) {
                        logger.fatal("", ex);
                    }
                }
            } else {
                throw new EKasaException(5L);
            }
            transactionStatus.setNextTransactionId(transactionId);
            TransactionStatus[] transactionStatuses = new TransactionStatus[]{transactionStatus, new TransactionStatus(transactionStatus.getChduSn(), originRequest.getRequestType(), request.getRequest(), originRequest.getMessageUuid(), transactionId, rVal.getStatus(), transactionStatus.getOriginTransactionId(), transactionStatus.getTransactionId(), null, null, null, null, transactionStatus.getCreationDate(), transactionStatus.getReceiptNumber(), counter)};
            this.ppekk.getDb(uuid).setTransactionStatus(transactionStatuses);
            return rVal;
        }
        catch (Exception e) {
            logger.debug("EKasaServer.resendToServer()", e);
            throw new EKasaException(19L, (Throwable)e);
        }
    }

    private String getUnsendDataMessage(PPEKKSetup configuration, RequestObject requestObject, EKasaServerMessageInterface command) throws EKasaException {
        StringBuilder sb = new StringBuilder();
        if (requestObject instanceof Location) {
            Location obj = (Location)requestObject;
            sb.append(obj.getAxisX() == null ? "" : obj.getAxisX());
            sb.append(";");
            sb.append(obj.getAxisY() == null ? "" : obj.getAxisY());
            sb.append(";");
            sb.append(obj.getStreetName() == null ? "" : obj.getStreetName());
            if (obj.getBuildingNumber() != null && !obj.getBuildingNumber().equals("")) {
                sb.append(" ");
                sb.append(obj.getBuildingNumber());
                if (obj.getPropertyRegistrationNumber() != null && !obj.getPropertyRegistrationNumber().equals("")) {
                    sb.append("/");
                    sb.append(obj.getPropertyRegistrationNumber());
                }
            }
            sb.append(",");
            sb.append(obj.getPostalCode() == null ? "" : obj.getPostalCode());
            sb.append(" ");
            sb.append(obj.getMunicipality() == null ? "" : obj.getMunicipality());
            sb.append(";");
            sb.append(obj.getOther() == null ? "" : obj.getOther());
        } else if (requestObject instanceof com.notasoftwarecompany.ekasa.receipt.Receipt) {
            String vatTable;
            com.notasoftwarecompany.ekasa.receipt.Receipt obj = (com.notasoftwarecompany.ekasa.receipt.Receipt)requestObject;
            if (obj.getReceiptType().equals("ND")) {
                sb.append("NEPLATN\u00dd DOKLAD");
                sb.append("\n");
            } else if (obj.getReceiptType().equals("VK")) {
                sb.append("VKLAD");
                sb.append("\n");
            } else if (obj.getReceiptType().equals("VY")) {
                sb.append("V\u00ddBER");
                sb.append("\n");
            } else if (obj.getReceiptType().equals(Receipt.RECEIPT_TYPE)) {
                sb.append("POKLADNI\u010cN\u00dd DOKLAD");
                sb.append("\n");
            } else if (obj.getReceiptType().equals("UF")) {
                sb.append("\u00daHRADA FAKT\u00daRY");
                sb.append("\n");
                sb.append(obj.getInvoiceNumber());
                sb.append("\n");
            }
            sb.append(obj.getReceiptNumber());
            sb.append("\n");
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy;HH:mm:ss");
            try {
                sb.append(sdf.format(EKasaXML.parseDate(obj.getCreateDate())));
            }
            catch (Exception e) {
                logger.debug("EKasaServer.getUnsendDataMessage", e);
                sb.append(obj.getCreateDate() == null ? "" : obj.getCreateDate());
            }
            sb.append("\n");
            if (obj.getCustomerId() != null && !obj.getCustomerId().equals("")) {
                sb.append(obj.getCustomerId());
                sb.append("\n");
            }
            if (obj.getItem() != null) {
                for (Receipt.Item item : obj.getItem()) {
                    sb.append(item.getItemType());
                    sb.append(";");
                    sb.append(item.getName());
                    sb.append(";");
                    sb.append(item.getQuantity());
                    sb.append(";");
                    sb.append(item.getVatRate());
                    sb.append(";");
                    sb.append(item.getPrice());
                    sb.append(";");
                    sb.append(item.getReferenceReceiptId() == null ? "" : item.getReferenceReceiptId());
                    sb.append("\n");
                }
            }
            if (obj.getReceiptType().equals("VY")) {
                if (obj.getAmount().length() > 0 && obj.getAmount().charAt(0) == '-') {
                    sb.append(obj.getAmount().substring(1));
                } else {
                    sb.append(obj.getAmount());
                }
            } else {
                sb.append(obj.getAmount());
            }
            sb.append("\n");
            if (command instanceof Receipt) {
                vatTable = ((Receipt)command).getVatTable(configuration).getVatTableText();
                if (vatTable != null) {
                    sb.append(((Receipt)command).getVatTable(configuration).getVatTableText());
                }
            } else if (command instanceof InvalidReceipt) {
                vatTable = ((InvalidReceipt)command).getVatTable(configuration).getVatTableText();
                if (vatTable != null) {
                    sb.append(vatTable);
                }
            } else if (command instanceof CorrectHelper) {
                sb.append(((CorrectHelper)command).getVatTableText());
            }
            if (obj.getParagonNumber() != null && !obj.getParagonNumber().equals("")) {
                try {
                    sb.append(sdf.format(EKasaXML.parseDate(obj.getIssueDate())));
                }
                catch (Exception e) {
                    logger.debug("EKasaServer.getUnsendDataMessage", e);
                    sb.append(obj.getIssueDate() == null ? "" : obj.getIssueDate());
                }
                sb.append(";");
                sb.append(obj.getParagonNumber());
            }
        }
        return sb.toString();
    }
}

