/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.sfs;

import java.text.SimpleDateFormat;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.db.DbTransactionStatusFetchListenerInterface;
import sk.singularisdev.ekasask.db.TransactionStatus;

public class UnsendedTransactionIndex
implements DbTransactionStatusFetchListenerInterface {
    private StringBuilder sb = new StringBuilder();
    private PPEKKSetup configuration;

    public UnsendedTransactionIndex(PPEKKSetup configuration, String lastTransactionId) throws EKasaException {
        try {
            this.configuration = configuration;
            this.sb.append("[INDEX:0-");
            this.sb.append(lastTransactionId);
            this.sb.append("]");
            this.sb.append("\n");
        }
        catch (Exception e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    @Override
    public void onNextRecord(TransactionStatus transactionStatus) throws EKasaException {
        try {
            this.sb.append(transactionStatus.getTransactionId());
            this.sb.append("|");
            this.sb.append(transactionStatus.getStatus());
            this.sb.append("|");
            String retryTransactionId = transactionStatus.getRetryTransactionId();
            this.sb.append(retryTransactionId == null ? "" : retryTransactionId);
            this.sb.append("|");
            this.sb.append(transactionStatus.getRequestType().getShortage());
            this.sb.append("|");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            String pcd = String.valueOf(sdf.format(transactionStatus.getCreationDate())) + "/" + transactionStatus.getReceiptNumber();
            this.sb.append(pcd);
            this.sb.append("|");
            this.sb.append("\n");
        }
        catch (Exception e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    public void addData(String data) {
        this.sb.append(data);
    }

    public String getData() {
        return this.sb.toString();
    }
}

