/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.utils;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import sk.singularisdev.ekasask.xmlparser.AuthenticationData;

public class CertificateValidator {
    private AuthenticationData authentificationData;
    private String password;
    private Date validTo;
    private String dic;
    private String dkp;
    private boolean valid;

    public CertificateValidator(AuthenticationData authentificationData, String password) {
        block4: {
            this.valid = false;
            this.authentificationData = authentificationData;
            this.password = password;
            ByteArrayInputStream stream = new ByteArrayInputStream(authentificationData.getKeystoreData());
            this.valid = false;
            try {
                String[] params;
                KeyStore keystore = KeyStore.getInstance(authentificationData.getKeyStoreType());
                keystore.load(stream, password.toCharArray());
                Certificate c = keystore.getCertificate(authentificationData.getCertificateAlias());
                if (!(c instanceof X509Certificate)) break block4;
                X509Certificate certificate = (X509Certificate)c;
                this.validTo = certificate.getNotAfter();
                X500Principal principal = certificate.getSubjectX500Principal();
                String[] stringArray = params = principal.getName().split(",");
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] p;
                    String param = stringArray[n2];
                    if (param.startsWith("CN=VATSK-") && (p = param.split(" ")).length >= 3 && p[1].equals("POKLADNICA")) {
                        this.dkp = p[2];
                        this.dic = p[0].substring(9);
                        this.valid = true;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                this.valid = false;
            }
        }
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public String getDic() {
        return this.dic;
    }

    public String getDkp() {
        return this.dkp;
    }

    public boolean isValid() {
        return this.valid;
    }
}

