/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class ChduSerialize {
    private Charset charset;
    private Map<String, byte[]> data = new HashMap<String, byte[]>();

    public void setValue(String key, String data) {
        this.data.put(key, data.getBytes(this.charset));
    }

    public void setValue(String key, byte[] data) {
        this.data.put(key, data);
    }

    public ChduSerialize(String charset) throws UnsupportedEncodingException {
        this.charset = Charset.forName(charset);
    }

    public byte[] getContent() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteBuffer bBuff = ByteBuffer.allocate(4);
        bBuff.order(ByteOrder.LITTLE_ENDIAN);
        for (String key : this.data.keySet()) {
            byte[] d = key.getBytes(this.charset);
            int l = d.length;
            bBuff.clear();
            baos.write(bBuff.putInt(l).array());
            baos.write(d);
            d = this.data.get(key);
            l = d.length;
            bBuff.clear();
            baos.write(bBuff.putInt(l).array());
            baos.write(d);
        }
        return baos.toByteArray();
    }

    public void setContent(byte[] data) {
        this.data.clear();
        int pos = 0;
        int dataLength = data.length;
        while (pos < dataLength) {
            ByteBuffer bBuff = ByteBuffer.wrap(data, pos, 4);
            bBuff.order(ByteOrder.LITTLE_ENDIAN);
            int l = bBuff.getInt();
            String key = new String(data, pos += 4, l, this.charset);
            bBuff = ByteBuffer.wrap(data, pos += l, 4);
            bBuff.order(ByteOrder.LITTLE_ENDIAN);
            l = bBuff.getInt();
            byte[] value = new byte[l];
            System.arraycopy(data, pos += 4, value, 0, l);
            this.data.put(key, value);
            pos += l;
        }
    }

    public String getString(String key) {
        if (this.data.containsKey(key)) {
            return new String(this.data.get(key), this.charset);
        }
        return null;
    }

    public byte[] getBytes(String key) {
        return this.data.get(key);
    }
}

