/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.enumeration.VAT_LEVEL;
import sk.singularisdev.ekasask.utils.Utility;

public class EKasaXML {
    public static String formatNumber(long amount, int precision) {
        StringBuilder sb = new StringBuilder();
        int div = (int)Math.pow(10.0, precision);
        boolean negate = false;
        if (amount < 0L) {
            negate = true;
            amount = -amount;
            sb.append("-");
        }
        sb.append(amount / (long)div);
        if (precision > 0) {
            sb.append(".");
            sb.append(String.format("%0" + precision + "d", amount % (long)div));
        }
        return sb.toString();
    }

    public static String formatNumber(BigDecimal amount, int precision) {
        long q = amount.multiply(BigDecimal.TEN.pow(precision)).longValue();
        return EKasaXML.formatNumber(q, precision);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        sb.append(sdfDate.format(date));
        sb.append("T");
        sb.append(sdfTime.format(date));
        sb.append(EKasaXML.getCurrentTimezoneOffset(date));
        return sb.toString();
    }

    private static String getCurrentTimezoneOffset(Date date) {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        cal.setTime(date);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        String offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
        offset = String.valueOf(offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }

    public static long getLongValue(String value, int multiply) {
        if (value == null) {
            return 0L;
        }
        return new BigDecimal(value).multiply(new BigDecimal(multiply)).longValue();
    }

    public static Date parseDate(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return sdf.parse(date.substring(0, 19));
    }

    public static String formatBoolean(boolean value) {
        return "" + value;
    }

    public static String formatVat(PPEKKSetup configuration, VAT_LEVEL vatLevel) {
        Integer vat = null;
        switch (vatLevel) {
            case A: {
                vat = configuration.getConfiguration().getVatA();
                break;
            }
            case B: {
                vat = configuration.getConfiguration().getVatB();
                break;
            }
            case C: {
                vat = configuration.getConfiguration().getVatC();
                break;
            }
            case D: {
                vat = configuration.getConfiguration().getVatD();
                break;
            }
            case E: {
                vat = configuration.getConfiguration().getVatE();
                break;
            }
            case F: {
                vat = configuration.getConfiguration().getVatF();
                break;
            }
            case G: {
                vat = configuration.getConfiguration().getVatG();
                break;
            }
            case H: {
                vat = configuration.getConfiguration().getVatH();
            }
        }
        return EKasaXML.formatNumber(vat * 100, 2);
    }

    public static VAT_LEVEL getVatLevel(int vat, PPEKKSetup configuration) {
        if (vat == configuration.getConfiguration().getVatA()) {
            return VAT_LEVEL.A;
        }
        if (vat == configuration.getConfiguration().getVatB()) {
            return VAT_LEVEL.B;
        }
        if (vat == configuration.getConfiguration().getVatC()) {
            return VAT_LEVEL.C;
        }
        if (vat == configuration.getConfiguration().getVatD()) {
            return VAT_LEVEL.D;
        }
        if (vat == configuration.getConfiguration().getVatE()) {
            return VAT_LEVEL.E;
        }
        if (vat == configuration.getConfiguration().getVatF()) {
            return VAT_LEVEL.F;
        }
        if (vat == configuration.getConfiguration().getVatG()) {
            return VAT_LEVEL.G;
        }
        if (vat == configuration.getConfiguration().getVatH()) {
            return VAT_LEVEL.H;
        }
        return null;
    }

    public static String escapeXML(String value) {
        if (value == null) {
            return null;
        }
        value = Utility.replaceIgnoredChars(value);
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    public static String unescapeXML(String value) {
        if (value == null) {
            return null;
        }
        return value.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'").replaceAll("&amp;", "&");
    }
}

