/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.utils;

import java.util.HashMap;
import java.util.Map;

public class IniFile {
    private static final String LINE_SEPARATOR = "\r\n";
    private Map<String, Section> sections = new HashMap<String, Section>();

    public Section getSection(String name) {
        Section section;
        if (this.sections.containsKey(name)) {
            section = this.sections.get(name);
        } else {
            section = new Section();
            this.sections.put(name, section);
        }
        return section;
    }

    private void addIniSection(StringBuilder sb, String sectionName) {
        sb.append("[");
        sb.append(sectionName);
        sb.append("]");
        sb.append(LINE_SEPARATOR);
    }

    private void addIniParameter(StringBuilder sb, String paramName, int paramValue) {
        this.addIniParameter(sb, paramName, "" + paramValue);
    }

    private void addIniParameter(StringBuilder sb, String paramName, boolean paramValue) {
        this.addIniParameter(sb, paramName, "" + paramValue);
    }

    private void addIniParameter(StringBuilder sb, String paramName, String paramValue) {
        sb.append(paramName.replace("=", "\\="));
        sb.append(" = ");
        if (paramValue == null) {
            sb.append("\\0");
        } else {
            sb.append(paramValue.replace("=", "\\="));
        }
        sb.append(LINE_SEPARATOR);
    }

    public String getContent() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String sectionName : this.sections.keySet()) {
            Section section = this.sections.get(sectionName);
            if (!first) {
                sb.append(LINE_SEPARATOR);
            }
            first = false;
            this.addIniSection(sb, sectionName);
            for (String paramName : section.items.keySet()) {
                this.addIniParameter(sb, paramName, (String)section.items.get(paramName));
            }
        }
        return sb.toString();
    }

    public void setContent(String content) {
        String[] lines;
        this.sections.clear();
        Section section = null;
        String[] stringArray = lines = content.split(LINE_SEPARATOR);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            String line = stringArray[n2];
            String trimLine = line.trim();
            if (trimLine.startsWith("[") && trimLine.endsWith("]")) {
                String sectionName = trimLine.substring(1, trimLine.length() - 1);
                section = this.getSection(sectionName);
            } else if (section != null && (index = line.indexOf(" = ")) != -1) {
                String name = line.substring(0, index);
                String value = line.substring(index + 3);
                section.setValue(name, value);
            }
            ++n2;
        }
    }

    public class Section {
        private Map<String, String> items = new HashMap<String, String>();

        public String getString(String name) {
            String value = this.items.get(name);
            if (value != null && (value = value.replaceAll("\\=", "=")).equals("\\0")) {
                value = null;
            }
            return value;
        }

        public Integer getInteger(String name) {
            String value = this.getString(name);
            if (value == null) {
                return null;
            }
            return Integer.parseInt(value);
        }

        public Boolean getBoolean(String name) {
            String value = this.getString(name);
            if (value == null) {
                return null;
            }
            return Boolean.parseBoolean(value);
        }

        public void setValue(String name, String value) {
            this.items.put(name, value);
        }

        public void setValue(String name, Integer value) {
            if (value == null) {
                this.items.put(name, null);
            } else {
                this.items.put(name, value.toString());
            }
        }

        public void setValue(String name, Boolean value) {
            if (value == null) {
                this.items.put(name, null);
            } else {
                this.items.put(name, value.toString());
            }
        }
    }
}

