/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.IOException;
import java.util.HashMap;
import sk.singularisdev.ekasask.enumeration.QR_CODE_TYPE;

public class QRCode {
    public static byte[] generateQRCodeImage(String text, int width, int height, QR_CODE_TYPE type) throws IOException, WriterException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, ErrorCorrectionLevel> hints = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
        switch (type) {
            case V4_CLL: {
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                break;
            }
            case V5_CLM: {
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
                break;
            }
            case V3_CLM: {
                hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            }
        }
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        int h = (height + 7) / 8;
        int w = (width + 7) / 8 * 8;
        byte[] pixels = new byte[w * 8 * h];
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int h1;
                StringBuilder sb = new StringBuilder();
                if (x < width) {
                    h1 = 0;
                    while (h1 < 8) {
                        if (y * 8 + h1 < height) {
                            if (bitMatrix.get(x, y * 8 + h1)) {
                                sb.append("1");
                            } else {
                                sb.append("0");
                            }
                        } else {
                            sb.append("0");
                        }
                        ++h1;
                    }
                } else {
                    h1 = 0;
                    while (h1 < 8) {
                        sb.append("0");
                        ++h1;
                    }
                }
                pixels[y * w + x] = (byte)Integer.parseInt(sb.toString(), 2);
                ++x;
            }
            ++y;
        }
        return pixels;
    }
}

