/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.utils;

import java.util.Date;
import java.util.HashSet;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.PPEKKSetup;
import sk.singularisdev.ekasask.command.setup.Setup;
import sk.singularisdev.ekasask.command.setup.SetupItemAuthenticationData;
import sk.singularisdev.ekasask.command.setup.SetupItemAuthenticationPassword;
import sk.singularisdev.ekasask.command.setup.SetupItemIdentityData;
import sk.singularisdev.ekasask.command.setup.SetupItemVat;
import sk.singularisdev.ekasask.enumeration.VAT_TYPE;
import sk.singularisdev.ekasask.utils.CertificateValidator;
import sk.singularisdev.ekasask.xmlparser.AuthenticationData;
import sk.singularisdev.ekasask.xmlparser.IdentityData;

public class Validate {
    public static void validateSetup(PPEKKSetup configuration, Setup setup) throws EKasaException {
        CertificateValidator certValid;
        Integer[] vats = new Integer[]{configuration.getConfiguration().getVatA(), configuration.getConfiguration().getVatB(), configuration.getConfiguration().getVatC(), configuration.getConfiguration().getVatD(), configuration.getConfiguration().getVatE(), configuration.getConfiguration().getVatF(), configuration.getConfiguration().getVatG(), configuration.getConfiguration().getVatH()};
        int index = 0;
        while (index < setup.itemCount()) {
            if (setup.getItemAt(index) instanceof SetupItemVat) {
                SetupItemVat v = (SetupItemVat)setup.getItemAt(index);
                if (v.getVat() != null) {
                    if (v.getVat() == 0 && !v.getVatType().equals((Object)VAT_TYPE.FREE)) {
                        throw new EKasaException(17L);
                    }
                    if (v.getVat() != 0 && v.getVat() != 10 && v.getVat() != 20) {
                        throw new EKasaException(17L);
                    }
                }
                if (v.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "A")) {
                    vats[0] = v.getVat();
                }
                if (v.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "B")) {
                    vats[1] = v.getVat();
                }
                if (v.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "C")) {
                    vats[2] = v.getVat();
                }
                if (v.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "D")) {
                    vats[3] = v.getVat();
                }
                if (v.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "E")) {
                    vats[4] = v.getVat();
                }
                if (v.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "F")) {
                    vats[5] = v.getVat();
                }
                if (v.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "G")) {
                    vats[6] = v.getVat();
                }
                if (v.getDbName().equals(String.valueOf(SetupItemVat.NAME) + "H")) {
                    vats[7] = v.getVat();
                }
            }
            ++index;
        }
        HashSet<Integer> x = new HashSet<Integer>();
        int i = 0;
        while (i < vats.length) {
            if (vats[i] != null && vats[i] != 0) {
                if (x.contains(vats[i])) {
                    throw new EKasaException(30L);
                }
                x.add(vats[i]);
            }
            ++i;
        }
        SetupItemAuthenticationData authenticationData = null;
        SetupItemAuthenticationPassword authenticationPassword = null;
        SetupItemIdentityData identityData = null;
        int index2 = 0;
        while (index2 < setup.itemCount()) {
            if (setup.getItemAt(index2) instanceof SetupItemAuthenticationData) {
                authenticationData = (SetupItemAuthenticationData)setup.getItemAt(index2);
            }
            if (setup.getItemAt(index2) instanceof SetupItemIdentityData) {
                identityData = (SetupItemIdentityData)setup.getItemAt(index2);
            }
            if (setup.getItemAt(index2) instanceof SetupItemAuthenticationPassword) {
                authenticationPassword = (SetupItemAuthenticationPassword)setup.getItemAt(index2);
            }
            ++index2;
        }
        if (authenticationData == null && authenticationPassword != null || authenticationData != null && authenticationPassword == null) {
            throw new EKasaException(15L);
        }
        if (identityData != null) {
            IdentityData id = new IdentityData(identityData.getIdentityData());
            if (!id.parse()) {
                throw new EKasaException(35L);
            }
            if (configuration.getAuthentication() != null && configuration.getAuthentication().getAuthentication() != null && configuration.getAuthentication().getAuthenticationPassword() != null && !(certValid = new CertificateValidator(configuration.getAuthentication().getAuthentication(), configuration.getAuthentication().getAuthenticationPassword())).getDic().equals(id.getDic())) {
                throw new EKasaException(36L);
            }
        }
        if (authenticationData != null) {
            AuthenticationData ad = new AuthenticationData(authenticationData.getAuthenticationData());
            if (!ad.parse()) {
                throw new EKasaException(32L);
            }
            certValid = new CertificateValidator(ad, authenticationPassword.getPassword());
            if (certValid.isValid()) {
                if (certValid.getValidTo().before(new Date())) {
                    throw new EKasaException(33L);
                }
                if (configuration.getIdentity().getIdentity() != null && !certValid.getDic().equals(configuration.getIdentity().getIdentity().getDic())) {
                    throw new EKasaException(34L);
                }
            } else {
                throw new EKasaException(32L);
            }
        }
    }
}

