/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sk.singularisdev.ekasask.utils.FileUtils;

public class Zip {
    private File zipFile;

    public Zip(File zipFile) {
        this.zipFile = zipFile;
    }

    public void addFiles(FileHolder[] files) throws IOException {
        ZipInputStream zin = null;
        File tempFile = null;
        if (this.zipFile.exists()) {
            tempFile = File.createTempFile(this.zipFile.getName(), null);
            FileUtils.copyFile(this.zipFile, tempFile);
            if (this.zipFile.exists() && !this.zipFile.delete()) {
                throw new IOException();
            }
            zin = new ZipInputStream(new FileInputStream(tempFile));
        }
        byte[] buf = new byte[1024];
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.zipFile));
        if (zin != null) {
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                boolean notInFiles = true;
                FileHolder[] fileHolderArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    FileHolder f = fileHolderArray[n2];
                    if (f.getName().equals(name)) {
                        notInFiles = false;
                        break;
                    }
                    ++n2;
                }
                if (notInFiles) {
                    int len;
                    out.putNextEntry(new ZipEntry(name));
                    while ((len = zin.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                entry = zin.getNextEntry();
            }
            zin.close();
        }
        FileHolder[] fileHolderArray = files;
        int n = files.length;
        int n3 = 0;
        while (n3 < n) {
            int len;
            FileHolder file = fileHolderArray[n3];
            InputStream in = file.getIn();
            out.putNextEntry(new ZipEntry(file.getName()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
            ++n3;
        }
        out.close();
        if (tempFile != null) {
            tempFile.delete();
        }
    }

    public static String loadFromFile(File cfgFile, String filename) throws Exception {
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(cfgFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String data;
                int l;
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equals(filename)) continue;
                InputStream stream = zipFile.getInputStream(entry);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((l = stream.read(buffer)) != -1) {
                    baos.write(buffer, 0, l);
                }
                String string = data = new String(baos.toByteArray(), "UTF-8");
                return string;
            }
        }
        return null;
    }

    public static void saveToFile(File cfgFile, String filename, String content) throws Exception {
        Zip zip = new Zip(cfgFile);
        FileHolder[] fileHolderArray = new FileHolder[1];
        Zip zip2 = zip;
        zip2.getClass();
        fileHolderArray[0] = zip2.new FileHolder(filename, new ByteArrayInputStream(content.getBytes("UTF-8")));
        FileHolder[] files = fileHolderArray;
        zip.addFiles(files);
    }

    public class FileHolder {
        private InputStream in;
        private String name;

        public FileHolder(String name, InputStream in) {
            this.name = name;
            this.in = in;
        }

        public InputStream getIn() {
            return this.in;
        }

        public String getName() {
            return this.name;
        }
    }
}

