/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.xmlparser;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sk.singularisdev.ekasask.utils.Base64;
import sk.singularisdev.ekasask.utils.Utility;

public class AuthenticationData
extends DefaultHandler {
    private String xml;
    private boolean parsed = false;
    private String keyStoreType;
    private String data;
    private String certificateAlias;
    private byte[] keystoreData;

    public AuthenticationData(String xml) {
        this.xml = xml;
        this.keyStoreType = "";
        this.data = "";
        this.certificateAlias = "";
    }

    public boolean parse() {
        try {
            SAXParserFactory parserFactor = SAXParserFactory.newInstance();
            SAXParser parser = parserFactor.newSAXParser();
            AuthenticationDataParser handler = new AuthenticationDataParser(this);
            handler.state = STATE.ROOT;
            parser.parse(new InputSource(new StringReader(this.xml)), (DefaultHandler)handler);
            this.keystoreData = Base64.toBytes(this.data);
            this.parsed = true;
        }
        catch (Exception e) {
            this.parsed = false;
        }
        return this.parsed;
    }

    public String getXml() {
        return this.xml;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void appendData(String data) {
        this.data = String.valueOf(this.data) + data;
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    public byte[] getKeystoreData() {
        return this.keystoreData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationData obj = (AuthenticationData)o;
        return Utility.equals(this.certificateAlias, obj.certificateAlias) && Utility.equals(this.data, obj.data) && Utility.equals(this.keystoreData, obj.keystoreData) && Utility.equals(this.keyStoreType, obj.keyStoreType) && Utility.equals(this.parsed, obj.parsed) && Utility.equals(this.xml, obj.xml);
    }

    private class AuthenticationDataParser
    extends DefaultHandler {
        private AuthenticationData authenticationData;
        private String text = null;
        private STATE state = STATE.ROOT;

        public AuthenticationDataParser(AuthenticationData authenticationData2) {
            this.authenticationData = authenticationData2;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String[] d = qName.split(":");
            String tag = d[d.length - 1];
            switch (this.state) {
                case ROOT: {
                    if (!tag.equals("AuthData")) break;
                    this.state = STATE.AUTH_DATA;
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String[] d = qName.split(":");
            String tag = d[d.length - 1];
            switch (this.state) {
                case ROOT: 
                case AUTH_DATA: {
                    if (tag.equals("KeyStoreType")) {
                        this.authenticationData.setKeyStoreType(this.text);
                        this.text = "";
                        break;
                    }
                    if (tag.equals("Data")) {
                        this.authenticationData.appendData(this.text);
                        this.text = "";
                        break;
                    }
                    if (tag.equals("CertificateAlias")) {
                        this.authenticationData.setCertificateAlias(this.text);
                        this.text = "";
                        break;
                    }
                    if (!tag.equals("AuthData")) break;
                    this.state = STATE.ROOT;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.text = this.text == null ? String.copyValueOf(ch, start, length).trim() : String.valueOf(this.text) + String.copyValueOf(ch, start, length).trim();
        }
    }

    private static enum STATE {
        ROOT,
        AUTH_DATA;

    }
}

