/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.xmlparser;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.utils.Utility;
import sk.singularisdev.ekasask.xmlparser.OrganizationUnit;
import sk.singularisdev.ekasask.xmlparser.PhysicalAddress;

public class IdentityData
extends DefaultHandler {
    private String xml;
    private boolean parsed = false;
    private String dic;
    private String ico;
    private String icdph;
    private String corporateBodyFullName;
    private OrganizationUnit organizationUnit;
    private PhysicalAddress physicalAddress;
    private Map<Integer, List<String>> generatedHeader = new HashMap<Integer, List<String>>();

    public IdentityData(String xml) {
        this.xml = xml;
    }

    public boolean parse() {
        try {
            SAXParserFactory parserFactor = SAXParserFactory.newInstance();
            SAXParser parser = parserFactor.newSAXParser();
            IdentityDataParser handler = new IdentityDataParser(this);
            handler.state = STATE.ROOT;
            StringBuffer buffer = new StringBuffer(this.xml.length());
            Pattern pattern = Pattern.compile("<(\\S+?)(.*?)>(.*?)</\\1>");
            Matcher matcher = pattern.matcher(this.xml);
            while (matcher.find()) {
                String tag = String.valueOf(matcher.group(1)) + matcher.group(2);
                String content = matcher.group(3);
                content = content.replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&apos;", "'");
                content = content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
                matcher.appendReplacement(buffer, Matcher.quoteReplacement("<" + tag + ">" + content + "</" + tag + ">"));
            }
            matcher.appendTail(buffer);
            String correctedXml = buffer.toString();
            parser.parse(new InputSource(new StringReader(correctedXml)), (DefaultHandler)handler);
            this.parsed = this.isValid();
        }
        catch (Exception e) {
            this.parsed = false;
        }
        return this.parsed;
    }

    public String getXml() {
        return this.xml;
    }

    public boolean isValid() {
        if (this.dic == null || !Pattern.matches("[0-9]{10}", this.dic)) {
            return false;
        }
        if (this.ico != null && !Pattern.matches("[0-9]{8}", this.ico)) {
            return false;
        }
        if (this.icdph != null && !Pattern.matches("SK[0-9]{8,10}", this.icdph)) {
            return false;
        }
        if (this.corporateBodyFullName == null || !Pattern.matches(".{1,1024}", this.corporateBodyFullName)) {
            return false;
        }
        if (this.physicalAddress == null || !this.physicalAddress.isValid()) {
            return false;
        }
        return this.organizationUnit != null && this.organizationUnit.isValid();
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public String getDic() {
        return this.dic;
    }

    public void setDic(String dic) {
        this.dic = dic;
    }

    public String getIco() {
        return this.ico;
    }

    public void setIco(String ico) {
        this.ico = ico;
    }

    public String getIcdph() {
        return this.icdph;
    }

    public void setIcdph(String icdph) {
        this.icdph = icdph;
    }

    public boolean isPlatcaDph() {
        return this.icdph != null && !this.icdph.equals("");
    }

    public String getCorporateBodyFullName() {
        return this.corporateBodyFullName;
    }

    public void setCorporateBodyFullName(String corporateBodyFullName) {
        this.corporateBodyFullName = corporateBodyFullName;
    }

    public OrganizationUnit getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setOrganizationUnit(OrganizationUnit organizationUnit) {
        this.organizationUnit = organizationUnit;
    }

    public PhysicalAddress getPhysicalAddress() {
        return this.physicalAddress;
    }

    public void setPhysicalAddress(PhysicalAddress physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    public synchronized List<String> getHeader(int width, long deviceId) {
        ArrayList<String> h;
        String template = Configuration.getHeaderTemplate(deviceId);
        if (template != null && (h = this.getHeaderFromTemplate(template, width)) != null) {
            return h;
        }
        h = new ArrayList();
        Printer.splitText(h, this.corporateBodyFullName, width);
        h.addAll(this.physicalAddress.getHeader(width));
        List<String> orgUnitHeader = this.organizationUnit.getHeader(width);
        if (orgUnitHeader.size() > 0) {
            h.addAll(orgUnitHeader);
        }
        StringBuilder text = new StringBuilder();
        text.append(Localization.getString("paragon.dic"));
        text.append(Printer.formatString(this.dic, 11, false));
        text.append(" ");
        StringBuilder text1 = new StringBuilder();
        text1.append(Localization.getString("paragon.ico"));
        text1.append(Printer.formatString(this.ico, 11, false));
        if (text.length() + text1.length() > width) {
            h.add(text.toString());
            h.add(text1.toString());
        } else {
            text.append((CharSequence)text1);
            h.add(text.toString());
        }
        if (this.isPlatcaDph()) {
            text.setLength(0);
            text.append(Localization.getString("paragon.icdph"));
            text.append(Printer.formatString(this.icdph, 13, false));
            h.add(text.toString());
        }
        return h;
    }

    private List<String> getHeaderFromTemplate(String template, int width) {
        block34: {
            boolean ouSame;
            block33: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                block24: {
                                                    block23: {
                                                        block22: {
                                                            block21: {
                                                                block20: {
                                                                    if (template.contains("{CorporateBodyFullName}")) break block20;
                                                                    return null;
                                                                }
                                                                if (template.contains("{Dic}")) break block21;
                                                                return null;
                                                            }
                                                            if (template.contains("{Ico}")) break block22;
                                                            return null;
                                                        }
                                                        if (template.contains("{IcDph}")) break block23;
                                                        return null;
                                                    }
                                                    if (template.contains("{Municipality}")) break block24;
                                                    return null;
                                                }
                                                if (template.contains("{StreetName}")) break block25;
                                                return null;
                                            }
                                            if (template.contains("{BuildingNumber}")) break block26;
                                            return null;
                                        }
                                        if (template.contains("{PropertyRegistrationNumber}")) break block27;
                                        return null;
                                    }
                                    if (template.contains("{PostalCode}")) break block28;
                                    return null;
                                }
                                if (template.contains("{OUName}")) break block29;
                                return null;
                            }
                            ouSame = false;
                            if (this.organizationUnit == null || this.organizationUnit.getPhysicalAddress() == null || this.getValue(this.physicalAddress.getMunicipality()).equals(this.getValue(this.organizationUnit.getPhysicalAddress().getMunicipality())) && this.getValue(this.physicalAddress.getStreetName()).equals(this.getValue(this.organizationUnit.getPhysicalAddress().getStreetName())) && this.getValue(this.physicalAddress.getPropertyRegistrationNumber()).equals(this.getValue(this.organizationUnit.getPhysicalAddress().getPropertyRegistrationNumber())) && this.getValue(this.physicalAddress.getBuildingNumber()).equals(this.getValue(this.organizationUnit.getPhysicalAddress().getBuildingNumber())) && this.getValue(this.physicalAddress.getPostalCode()).equals(this.getValue(this.organizationUnit.getPhysicalAddress().getPostalCode()))) {
                                ouSame = true;
                            }
                            if (ouSame || template.contains("{OUMunicipality}")) break block30;
                            return null;
                        }
                        if (ouSame || template.contains("{OUStreetName}")) break block31;
                        return null;
                    }
                    if (ouSame || template.contains("{OUBuildingNumber}")) break block32;
                    return null;
                }
                if (ouSame || template.contains("{OUPropertyRegistrationNumber}")) break block33;
                return null;
            }
            if (ouSame || template.contains("{OUPostalCode}")) break block34;
            return null;
        }
        try {
            String[] lines;
            template = template.replace("{CorporateBodyFullName}", this.getValue(this.corporateBodyFullName));
            template = template.replace("{Dic}", this.getValue(this.dic));
            template = template.replace("{Ico}", this.getValue(this.ico));
            template = template.replace("{IcDph}", this.getValue(this.icdph));
            template = template.replace("{Country}", this.physicalAddress == null ? "" : this.getValue(this.physicalAddress.getCountry()));
            template = template.replace("{Municipality}", this.physicalAddress == null ? "" : this.getValue(this.physicalAddress.getMunicipality()));
            template = template.replace("{StreetName}", this.physicalAddress == null ? "" : this.getValue(this.physicalAddress.getStreetName()));
            template = template.replace("{BuildingNumber}", this.physicalAddress == null ? "" : this.getValue(this.physicalAddress.getBuildingNumber()));
            template = template.replace("{PropertyRegistrationNumber}", this.physicalAddress == null ? "" : this.getValue(this.physicalAddress.getPropertyRegistrationNumber()));
            template = template.replace("{PostalCode}", this.physicalAddress == null ? "" : this.getValue(this.physicalAddress.getPostalCode()));
            template = template.replace("{OUName}", this.organizationUnit == null ? "" : this.getValue(this.organizationUnit.getOrganizationUnitName()));
            template = template.replace("{OUCountry}", this.organizationUnit == null || this.organizationUnit.getPhysicalAddress() == null ? "" : this.getValue(this.organizationUnit.getPhysicalAddress().getCountry()));
            template = template.replace("{OUMunicipality}", this.organizationUnit == null || this.organizationUnit.getPhysicalAddress() == null ? "" : this.getValue(this.organizationUnit.getPhysicalAddress().getMunicipality()));
            template = template.replace("{OUStreetName}", this.organizationUnit == null || this.organizationUnit.getPhysicalAddress() == null ? "" : this.getValue(this.organizationUnit.getPhysicalAddress().getStreetName()));
            template = template.replace("{OUBuildingNumber}", this.organizationUnit == null || this.organizationUnit.getPhysicalAddress() == null ? "" : this.getValue(this.organizationUnit.getPhysicalAddress().getBuildingNumber()));
            template = template.replace("{OUPropertyRegistrationNumber}", this.organizationUnit == null || this.organizationUnit.getPhysicalAddress() == null ? "" : this.getValue(this.organizationUnit.getPhysicalAddress().getPropertyRegistrationNumber()));
            template = template.replace("{OUPostalCode}", this.organizationUnit == null || this.organizationUnit.getPhysicalAddress() == null ? "" : this.getValue(this.organizationUnit.getPhysicalAddress().getPostalCode()));
            ArrayList<String> h = new ArrayList<String>();
            String[] stringArray = lines = template.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.equals("")) {
                    Printer.splitText(h, line, width, true);
                }
                ++n2;
            }
            return h;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getValue(String value) {
        return value == null ? "" : value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        IdentityData obj = (IdentityData)o;
        return Utility.equals(this.corporateBodyFullName, obj.corporateBodyFullName) && Utility.equals(this.dic, obj.dic) && Utility.equals(this.icdph, obj.icdph) && Utility.equals(this.ico, obj.ico) && Utility.equals(this.organizationUnit, obj.organizationUnit) && Utility.equals(this.parsed, obj.parsed) && Utility.equals(this.physicalAddress, obj.physicalAddress) && Utility.equals(this.xml, obj.xml);
    }

    private class IdentityDataParser
    extends DefaultHandler {
        private IdentityData identityData;
        private String text = null;
        private STATE state = STATE.ROOT;

        public IdentityDataParser(IdentityData identityData2) {
            this.identityData = identityData2;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.text = "";
            String[] d = qName.split(":");
            String tag = d[d.length - 1];
            switch (this.state) {
                case ROOT: {
                    if (!tag.equals("IdentityData")) break;
                    this.state = STATE.IDENTITY_DATA;
                    break;
                }
                case IDENTITY_DATA: {
                    if (tag.equals("OrganizationUnit")) {
                        this.identityData.setOrganizationUnit(new OrganizationUnit());
                        this.state = STATE.ORGANIZATION_UNIT;
                        break;
                    }
                    if (!tag.equals("PhysicalAddress")) break;
                    this.identityData.setPhysicalAddress(new PhysicalAddress());
                    this.state = STATE.PHYSICAL_ADDRESS;
                    break;
                }
                case ORGANIZATION_UNIT: {
                    if (!tag.equals("PhysicalAddress")) break;
                    this.identityData.getOrganizationUnit().setPhysicalAddress(new PhysicalAddress());
                    this.state = STATE.ORGANIZATION_UNIT_PHYSICAL_ADDRESS;
                    break;
                }
                case PHYSICAL_ADDRESS: {
                    if (!tag.equals("DeliveryAddress")) break;
                    this.identityData.getPhysicalAddress().setDeliveryAddress(true);
                    this.state = STATE.PHYSICAL_ADDRESS_DELIVERY_ADDRESS;
                    break;
                }
                case PHYSICAL_ADDRESS_DELIVERY_ADDRESS: {
                    break;
                }
                case ORGANIZATION_UNIT_PHYSICAL_ADDRESS: {
                    if (!tag.equals("DeliveryAddress")) break;
                    this.identityData.getOrganizationUnit().getPhysicalAddress().setDeliveryAddress(true);
                    this.state = STATE.ORGANIZATION_UNIT_PHYSICAL_ADDRESS_DELIVERY_ADDRESS;
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String[] d = qName.split(":");
            String tag = d[d.length - 1];
            String trimmedText = this.text.trim();
            switch (this.state) {
                case ROOT: 
                case IDENTITY_DATA: {
                    if (tag.equals("Dic")) {
                        this.identityData.setDic(trimmedText);
                        break;
                    }
                    if (tag.equals("Ico")) {
                        this.identityData.setIco(trimmedText);
                        break;
                    }
                    if (tag.equals("IcDph")) {
                        this.identityData.setIcdph(trimmedText);
                        break;
                    }
                    if (tag.equals("CorporateBodyFullName")) {
                        this.identityData.setCorporateBodyFullName(trimmedText);
                        break;
                    }
                    if (!tag.equals("IdentityData")) break;
                    this.state = STATE.ROOT;
                    break;
                }
                case ORGANIZATION_UNIT: {
                    if (tag.equals("OrganizationUnitName")) {
                        this.identityData.getOrganizationUnit().setOrganizationUnitName(trimmedText);
                        break;
                    }
                    if (tag.equals("CashRegisterCode")) {
                        this.identityData.getOrganizationUnit().setCashRegisterCode(trimmedText);
                        break;
                    }
                    if (tag.equals("CashRegisterType")) {
                        if (trimmedText.equals("STANDARD")) {
                            this.identityData.getOrganizationUnit().setCashRegisterType(OrganizationUnit.CASH_REGISTER_TYPE.STANDARD);
                            break;
                        }
                        if (!trimmedText.equals("PORTABLE")) break;
                        this.identityData.getOrganizationUnit().setCashRegisterType(OrganizationUnit.CASH_REGISTER_TYPE.PORTABLE);
                        break;
                    }
                    if (!tag.equals("OrganizationUnit")) break;
                    this.state = STATE.IDENTITY_DATA;
                    break;
                }
                case PHYSICAL_ADDRESS: {
                    if (tag.equals("Country")) {
                        this.identityData.getPhysicalAddress().setCountry(trimmedText);
                        break;
                    }
                    if (tag.equals("Municipality")) {
                        this.identityData.getPhysicalAddress().setMunicipality(trimmedText);
                        break;
                    }
                    if (tag.equals("StreetName")) {
                        this.identityData.getPhysicalAddress().setStreetName(trimmedText);
                        break;
                    }
                    if (tag.equals("BuildingNumber")) {
                        this.identityData.getPhysicalAddress().setBuildingNumber(trimmedText);
                        break;
                    }
                    if (tag.equals("PropertyRegistrationNumber")) {
                        this.identityData.getPhysicalAddress().setPropertyRegistrationNumber(trimmedText);
                        break;
                    }
                    if (tag.equals("Country")) {
                        this.identityData.getPhysicalAddress().setCountry(trimmedText);
                        break;
                    }
                    if (!tag.equals("PhysicalAddress")) break;
                    this.state = STATE.IDENTITY_DATA;
                    break;
                }
                case PHYSICAL_ADDRESS_DELIVERY_ADDRESS: {
                    if (tag.equals("PostalCode")) {
                        this.identityData.getPhysicalAddress().setPostalCode(trimmedText);
                        break;
                    }
                    if (!tag.equals("DeliveryAddress")) break;
                    this.state = STATE.PHYSICAL_ADDRESS;
                    break;
                }
                case ORGANIZATION_UNIT_PHYSICAL_ADDRESS: {
                    if (tag.equals("Country")) {
                        this.identityData.getOrganizationUnit().getPhysicalAddress().setCountry(trimmedText);
                        break;
                    }
                    if (tag.equals("Municipality")) {
                        this.identityData.getOrganizationUnit().getPhysicalAddress().setMunicipality(trimmedText);
                        break;
                    }
                    if (tag.equals("StreetName")) {
                        this.identityData.getOrganizationUnit().getPhysicalAddress().setStreetName(trimmedText);
                        break;
                    }
                    if (tag.equals("BuildingNumber")) {
                        this.identityData.getOrganizationUnit().getPhysicalAddress().setBuildingNumber(trimmedText);
                        break;
                    }
                    if (tag.equals("PropertyRegistrationNumber")) {
                        this.identityData.getOrganizationUnit().getPhysicalAddress().setPropertyRegistrationNumber(trimmedText);
                        break;
                    }
                    if (tag.equals("Country")) {
                        this.identityData.getOrganizationUnit().getPhysicalAddress().setCountry(trimmedText);
                        break;
                    }
                    if (!tag.equals("PhysicalAddress")) break;
                    this.state = STATE.ORGANIZATION_UNIT;
                    break;
                }
                case ORGANIZATION_UNIT_PHYSICAL_ADDRESS_DELIVERY_ADDRESS: {
                    if (tag.equals("PostalCode")) {
                        this.identityData.getOrganizationUnit().getPhysicalAddress().setPostalCode(trimmedText);
                        break;
                    }
                    if (!tag.equals("DeliveryAddress")) break;
                    this.state = STATE.ORGANIZATION_UNIT_PHYSICAL_ADDRESS;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.text = this.text == null ? String.copyValueOf(ch, start, length) : String.valueOf(this.text) + String.copyValueOf(ch, start, length);
        }
    }

    private static enum STATE {
        ROOT,
        IDENTITY_DATA,
        ORGANIZATION_UNIT,
        PHYSICAL_ADDRESS,
        PHYSICAL_ADDRESS_DELIVERY_ADDRESS,
        ORGANIZATION_UNIT_PHYSICAL_ADDRESS,
        ORGANIZATION_UNIT_PHYSICAL_ADDRESS_DELIVERY_ADDRESS;

    }
}

