/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.xmlparser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.localization.Localization;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.utils.Utility;
import sk.singularisdev.ekasask.xmlparser.PhysicalAddress;

public class OrganizationUnit {
    private String organizationUnitName;
    private PhysicalAddress physicalAddress;
    private String cashRegisterCode;
    private CASH_REGISTER_TYPE cashRegisterType;

    public String getOrganizationUnitName() {
        return this.organizationUnitName;
    }

    public void setOrganizationUnitName(String organizationUnitName) {
        this.organizationUnitName = organizationUnitName;
    }

    public PhysicalAddress getPhysicalAddress() {
        return this.physicalAddress;
    }

    public void setPhysicalAddress(PhysicalAddress physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    public String getCashRegisterCode() {
        return this.cashRegisterCode;
    }

    public void setCashRegisterCode(String cashRegisterCode) {
        this.cashRegisterCode = cashRegisterCode;
    }

    public CASH_REGISTER_TYPE getCashRegisterType() {
        return this.cashRegisterType;
    }

    public void setCashRegisterType(CASH_REGISTER_TYPE cashRegisterType) {
        this.cashRegisterType = cashRegisterType;
    }

    public synchronized List<String> getHeader(int width) {
        ArrayList<String> h = new ArrayList<String>();
        StringBuilder text = new StringBuilder();
        if (this.organizationUnitName != null && !this.organizationUnitName.equals("")) {
            Printer.splitText(h, this.organizationUnitName, width);
        }
        if (this.physicalAddress != null) {
            h.addAll(this.physicalAddress.getHeader(width));
        }
        if (this.cashRegisterType == CASH_REGISTER_TYPE.PORTABLE) {
            Printer.splitText(h, Localization.getString("paragon.portable"), width);
        }
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationUnit obj = (OrganizationUnit)o;
        return Utility.equals(this.cashRegisterCode, obj.cashRegisterCode) && Utility.equals((Object)this.cashRegisterType, (Object)obj.cashRegisterType) && Utility.equals(this.organizationUnitName, obj.organizationUnitName) && Utility.equals(this.physicalAddress, obj.physicalAddress);
    }

    public boolean isValid() {
        if (this.organizationUnitName != null && !Pattern.matches(".{1,1024}", this.organizationUnitName)) {
            return false;
        }
        if (this.physicalAddress != null && !this.physicalAddress.isValid()) {
            return false;
        }
        if (this.cashRegisterCode == null || !Pattern.matches("[0-9]{16,17}", this.cashRegisterCode)) {
            return false;
        }
        if (this.cashRegisterType == null) {
            return false;
        }
        return this.cashRegisterType != CASH_REGISTER_TYPE.PORTABLE || this.physicalAddress == null;
    }

    public static enum CASH_REGISTER_TYPE {
        STANDARD,
        PORTABLE;

    }
}

