/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.xmlparser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import sk.singularisdev.ekasask.printer.Printer;
import sk.singularisdev.ekasask.utils.Utility;

public class PhysicalAddress {
    private String country;
    private String municipality;
    private String streetName;
    private String buildingNumber;
    private String propertyRegistrationNumber;
    private String postalCode;
    private boolean deliveryAddress = false;

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getMunicipality() {
        return this.municipality;
    }

    public void setMunicipality(String municipality) {
        this.municipality = municipality;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public String getPropertyRegistrationNumber() {
        return this.propertyRegistrationNumber;
    }

    public void setPropertyRegistrationNumber(String propertyRegistrationNumber) {
        this.propertyRegistrationNumber = propertyRegistrationNumber;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public void setDeliveryAddress(boolean deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public synchronized List<String> getHeader(int width) {
        ArrayList<String> h = new ArrayList<String>();
        StringBuilder text = new StringBuilder();
        text.append(this.streetName);
        if (this.propertyRegistrationNumber != null && !this.propertyRegistrationNumber.equals("")) {
            text.append(" ");
            text.append(this.propertyRegistrationNumber);
            if (this.buildingNumber != null && !this.buildingNumber.equals("")) {
                text.append("/");
                text.append(this.buildingNumber);
            }
        } else if (this.buildingNumber != null && !this.buildingNumber.equals("")) {
            text.append(" ");
            text.append(this.buildingNumber);
        }
        Printer.splitText(h, text.toString(), width);
        text.setLength(0);
        if (this.postalCode != null && !this.postalCode.equals("")) {
            text.append(this.postalCode);
            text.append(" ");
        }
        text.append(this.municipality);
        Printer.splitText(h, text.toString(), width);
        Printer.splitText(h, this.country, width);
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalAddress obj = (PhysicalAddress)o;
        return Utility.equals(this.buildingNumber, obj.buildingNumber) && Utility.equals(this.country, obj.country) && Utility.equals(this.municipality, obj.municipality) && Utility.equals(this.deliveryAddress, obj.deliveryAddress) && Utility.equals(this.postalCode, obj.postalCode) && Utility.equals(this.propertyRegistrationNumber, obj.propertyRegistrationNumber) && Utility.equals(this.streetName, obj.streetName);
    }

    public boolean isValid() {
        if (this.country == null || !Pattern.matches(".{1,255}", this.country)) {
            return false;
        }
        if (this.municipality == null || !Pattern.matches(".{1,255}", this.municipality)) {
            return false;
        }
        if (this.streetName == null || !Pattern.matches(".{1,255}", this.streetName)) {
            return false;
        }
        if (this.buildingNumber != null && !Pattern.matches(".{1,255}", this.buildingNumber)) {
            return false;
        }
        if (this.propertyRegistrationNumber != null && !Pattern.matches(".{1,255}", this.propertyRegistrationNumber)) {
            return false;
        }
        if (this.deliveryAddress && this.postalCode == null) {
            return false;
        }
        return this.postalCode == null || Pattern.matches(".{1,255}", this.postalCode);
    }
}

