/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.xmlparser;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sk.singularisdev.ekasask.EKasaException;

public class ReceiptRequestXml
extends DefaultHandler {
    private STATE state = STATE.ROOT;
    private String okp;
    private String text = null;

    private ReceiptRequestXml() {
    }

    public String getOkp() {
        return this.okp;
    }

    public static ReceiptRequestXml parse(String xml) throws EKasaException {
        try {
            SAXParserFactory parserFactor = SAXParserFactory.newInstance();
            SAXParser parser = parserFactor.newSAXParser();
            ReceiptRequestXml handler = new ReceiptRequestXml();
            handler.state = STATE.ROOT;
            parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)handler);
            return handler;
        }
        catch (Exception e) {
            throw new EKasaException(19L, (Throwable)e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String[] d = qName.split(":");
        String tag = d[d.length - 1];
        switch (this.state) {
            case ROOT: {
                if (!tag.equals("Body")) break;
                this.state = STATE.BODY;
                break;
            }
            case BODY: {
                if (!tag.equals("RegisterReceiptRequest")) break;
                this.state = STATE.REGISTER_RECEIPT_REQUEST;
                break;
            }
            case REGISTER_RECEIPT_REQUEST: {
                if (!tag.equals("ValidationCode")) break;
                this.state = STATE.VALIDATION_CODE;
                break;
            }
            case VALIDATION_CODE: {
                if (!tag.equals("OKP")) break;
                this.state = STATE.OKP;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String[] d = qName.split(":");
        String tag = d[d.length - 1];
        switch (this.state) {
            case ROOT: {
                break;
            }
            case OKP: {
                if (!tag.equals("OKP")) break;
                this.okp = this.text;
                this.state = STATE.VALIDATION_CODE;
                break;
            }
            case VALIDATION_CODE: {
                if (!tag.equals("ValidationCode")) break;
                this.state = STATE.REGISTER_RECEIPT_REQUEST;
                break;
            }
            case REGISTER_RECEIPT_REQUEST: {
                if (!tag.equals("RegisterReceiptRequest")) break;
                this.state = STATE.BODY;
                break;
            }
            case BODY: {
                if (!tag.equals("Envelope")) break;
                this.state = STATE.ROOT;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text = String.copyValueOf(ch, start, length).trim();
    }

    private static enum STATE {
        ROOT,
        BODY,
        REGISTER_RECEIPT_REQUEST,
        VALIDATION_CODE,
        OKP;

    }
}

