/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLSocket;
import sk.singularisdev.chdu.exception.ChduException;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.layers.PhysicalDriver;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.platform.android.AndroidPlatform;
import sk.singularisdev.platform.desktop.DesktopPlatform;

public class Platform {
    private static final Logger logger = LoggerManager.getLogger(Platform.class.getName());

    public static void Init(Object ... objects) {
        if (System.getProperty("java.specification.vendor").toUpperCase().contains("ANDROID")) {
            AndroidPlatform.Init(0, objects);
        }
    }

    public static void CreateAndSetPrinterRendererInstance() throws EKasaException {
        if (System.getProperty("java.specification.vendor").toUpperCase().contains("ANDROID")) {
            AndroidPlatform.CreateAndSetPrinterRendererInstance();
        } else {
            DesktopPlatform.CreateAndSetPrinterRendererInstance();
        }
    }

    public static PhysicalDriver CreatePhysicalDriverInstance(String connectionString) throws ChduException {
        if (System.getProperty("java.specification.vendor").toUpperCase().contains("ANDROID")) {
            return AndroidPlatform.CreatePhysicalDriverInstance(connectionString);
        }
        return DesktopPlatform.CreatePhysicalDriverInstance(connectionString);
    }

    public static File GetDataDirectory() {
        if (System.getProperty("java.specification.vendor").toUpperCase().contains("ANDROID")) {
            return AndroidPlatform.GetDataDirectory();
        }
        return DesktopPlatform.GetDataDirectory();
    }

    public static String[] getAvailableConnectionPorts(String type) {
        if (System.getProperty("java.specification.vendor").toUpperCase().contains("ANDROID")) {
            return AndroidPlatform.getAvailableConnectionPorts(type);
        }
        return DesktopPlatform.getAvailableConnectionPorts(type);
    }

    public static SSLSocket createSLLSocket(String address, int port, int timeout) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        if (System.getProperty("java.specification.vendor").toUpperCase().contains("ANDROID")) {
            return AndroidPlatform.CreateSSLSocket(address, port, timeout);
        }
        return DesktopPlatform.CreateSSLSocket(address, port, timeout);
    }

    public static SSLSocket createSLLSocket(Socket tunnel, String url, int port, boolean autoclose) throws KeyManagementException, NoSuchAlgorithmException, IOException {
        if (System.getProperty("java.specification.vendor").toUpperCase().contains("ANDROID")) {
            return AndroidPlatform.CreateSSLSocket(tunnel, url, port, autoclose);
        }
        return DesktopPlatform.CreateSSLSocket(tunnel, url, port, autoclose);
    }
}

