/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sk.singularisdev.chdu.exception.ChduException;
import sk.singularisdev.cryptoprotocol.layers.PhysicalDriver;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.printer.PrinterRenderer;
import sk.singularisdev.ekasask.printer.RendererWorker;
import sk.singularisdev.platform.android.bluetooth.BluetoothDriver;
import sk.singularisdev.platform.android.printer.AndroidPrinterRenderer;
import sk.singularisdev.platform.android.rs232.FelhrRs232Driver;
import sk.singularisdev.platform.android.ssl.TLSSocketFactory;
import sk.singularisdev.platform.desktop.tcp.TcpDriver;

public class AndroidPlatform {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context;

    public static void Init(int i, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        context = ((Context)objects[0]).getApplicationContext();
    }

    public static void CreateAndSetPrinterRendererInstance() throws EKasaException {
        AndroidPrinterRenderer.Factory printerRendererFactory = new AndroidPrinterRenderer.Factory();
        PrinterRenderer printerRenderer = printerRendererFactory.createInstance();
        RendererWorker.setPrinterRenderer(printerRenderer);
    }

    public static PhysicalDriver CreatePhysicalDriverInstance(String connectionString) throws ChduException {
        String[] splitted = connectionString.split(":");
        if (splitted.length == 0) {
            throw new ChduException(5);
        }
        if (splitted[0].toLowerCase().contains("rs232")) {
            int pid;
            int vid;
            String[] splittedVidPid = splitted[1].split("\\|");
            try {
                int tvid = Integer.parseInt(splittedVidPid[0]);
                int tpid = Integer.parseInt(splittedVidPid[1]);
                vid = tvid;
                pid = tpid;
            }
            catch (Exception ex) {
                vid = 1027;
                pid = 24577;
            }
            return new FelhrRs232Driver(context, vid, pid, FelhrRs232Driver.BaudRate.fromString(splitted[2]), Configuration.getChduCommunicationTimeout(), 4096);
        }
        if (splitted[0].toLowerCase().contains("bt")) {
            return new BluetoothDriver(splitted[1], Configuration.getChduCommunicationTimeout());
        }
        if (splitted[0].toLowerCase().contains("tcp")) {
            String[] splittedIpPort = splitted[1].split("\\|");
            return new TcpDriver(splittedIpPort[0], Integer.parseInt(splittedIpPort[1]), Configuration.getChduCommunicationTimeout());
        }
        throw new ChduException(5);
    }

    public static File GetDataDirectory() {
        return context.getFilesDir();
    }

    public static String[] getAvailableConnectionPorts(String type) {
        if (type.toLowerCase().contains("rs232")) {
            return FelhrRs232Driver.getAvailableConnectionPorts(context);
        }
        if (type.toLowerCase().contains("bt")) {
            return BluetoothDriver.getAvailableConnectionPorts(context);
        }
        return new String[0];
    }

    public static SSLSocket CreateSSLSocket(String address, int port, int timeout) throws UnknownHostException, IOException, NoSuchAlgorithmException, KeyManagementException {
        if (Build.VERSION.SDK_INT <= 19) {
            SSLContext context = null;
            TLSSocketFactory noSSLv3Factory = null;
            context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            noSSLv3Factory = new TLSSocketFactory(context.getSocketFactory());
            SSLSocket sock = (SSLSocket)((SocketFactory)noSSLv3Factory).createSocket();
            sock.setSoTimeout(timeout);
            sock.connect(new InetSocketAddress(address, port), timeout);
            return sock;
        }
        SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sock = (SSLSocket)sslsocketfactory.createSocket();
        sock.setSoTimeout(timeout);
        sock.connect(new InetSocketAddress(address, port), timeout);
        return sock;
    }

    public static SSLSocket CreateSSLSocket(Socket tunnel, String url, int port, boolean autoclose) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        if (Build.VERSION.SDK_INT <= 19) {
            SSLContext context = null;
            TLSSocketFactory noSSLv3Factory = null;
            context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            noSSLv3Factory = new TLSSocketFactory(context.getSocketFactory());
            SSLSocket sock = (SSLSocket)((SSLSocketFactory)noSSLv3Factory).createSocket(tunnel, url, port, true);
            return sock;
        }
        SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sock = (SSLSocket)sslsocketfactory.createSocket(tunnel, url, port, true);
        return sock;
    }
}

