/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform.android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.os.SystemClock;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.UUID;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.exception.PhysicalDriverException;
import sk.singularisdev.cryptoprotocol.layers.PhysicalDriver;
import sk.singularisdev.cryptoprotocol.utils.Cobs;

public class BluetoothDriver
implements PhysicalDriver {
    private static final Logger logger = LoggerManager.getLogger(BluetoothDriver.class.getName());
    private BluetoothDevice device;
    private String address;
    private BluetoothSocket socket;
    private OutputStream outputStream;
    private InputStream inputStream;
    private int timeout;
    private ByteArrayOutputStream bos;
    private long receivedBytesTotal;
    private static final UUID SERIAL_PROFILE_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private boolean error = false;
    private boolean initialized = false;

    public BluetoothDriver(String address, int timeout) {
        this.timeout = timeout;
        this.address = address.replace("-", ":");
        this.device = null;
        this.bos = new ByteArrayOutputStream();
    }

    @Override
    public void init() throws PhysicalDriverException {
        BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();
        if (this.initialized && !this.error) {
            return;
        }
        this.initialized = true;
        this.error = true;
        if (bluetooth == null) {
            Log.d((String)"BowaBlt", (String)"Cannot get bluetooth adapter");
            throw new PhysicalDriverException(1);
        }
        if (!bluetooth.isEnabled()) {
            Log.d((String)"BowaBlt", (String)"Bluetooth is not Enabled.");
            throw new PhysicalDriverException(1);
        }
        Set devices = bluetooth.getBondedDevices();
        if (devices.size() == 0) {
            throw new PhysicalDriverException(5);
        }
        boolean found = false;
        for (BluetoothDevice bd : devices) {
            if (!bd.getAddress().equals(this.address)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new PhysicalDriverException(5);
        }
        try {
            this.device = bluetooth.getRemoteDevice(this.address);
        }
        catch (SecurityException ex) {
            Log.d((String)"BowaBlt", (String)ex.toString());
            throw new PhysicalDriverException(5);
        }
        catch (Exception ex) {
            throw new PhysicalDriverException(5);
        }
        if (this.device == null) {
            Log.d((String)"BowaBlt", (String)"device == null");
            throw new PhysicalDriverException(5);
        }
        this.initialized = true;
        this.error = false;
    }

    @Override
    public void connect() throws PhysicalDriverException {
        try {
            this.error = true;
            try {
                this.socket = this.device.createInsecureRfcommSocketToServiceRecord(SERIAL_PROFILE_UUID);
                this.socket.connect();
            }
            catch (Exception e) {
                Method m = this.device.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                this.socket = (BluetoothSocket)m.invoke((Object)this.device, 1);
                this.socket.connect();
            }
            if (!this.socket.isConnected()) {
                throw new PhysicalDriverException(5);
            }
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            this.error = false;
        }
        catch (IOException e) {
            throw new PhysicalDriverException(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PhysicalDriverException(1);
        }
    }

    @Override
    public void send(byte[] frame) throws PhysicalDriverException {
        try {
            if (this.error) {
                throw new PhysicalDriverException(2);
            }
            this.error = true;
            byte[] cobsFrame = Cobs.encode(frame);
            this.outputStream.write(cobsFrame);
            this.error = false;
        }
        catch (IOException e) {
            logger.error("Error sending frame", e);
            this.deinit();
            throw new PhysicalDriverException(2, (Throwable)e);
        }
        catch (Exception e) {
            this.deinit();
            throw new PhysicalDriverException(2, (Throwable)e);
        }
    }

    @Override
    public byte[] recv() throws PhysicalDriverException {
        try {
            if (this.error) {
                throw new PhysicalDriverException(2);
            }
            this.error = true;
            this.bos.reset();
            boolean waitForSof = true;
            int prevVal = -1;
            int copy = 0;
            int code = 255;
            byte[] codeArray = new byte[1];
            while (true) {
                if (copy > 0) {
                    byte[] b = new byte[copy];
                    int read = this.read(b);
                    this.receivedBytesTotal += (long)read;
                    if (read != copy) {
                        throw new PhysicalDriverException(4);
                    }
                    this.bos.write(b, 0, b.length);
                    copy = 0;
                    continue;
                }
                int read = this.read(codeArray);
                this.receivedBytesTotal += (long)read;
                if (read != codeArray.length) {
                    throw new PhysicalDriverException(4);
                }
                int val = codeArray[0] & 0xFF;
                if (waitForSof && prevVal == -1 && val == 0) {
                    prevVal = 0;
                    continue;
                }
                if (waitForSof && prevVal == 0 && val != 0) {
                    waitForSof = false;
                } else if (waitForSof) {
                    prevVal = -1;
                    continue;
                }
                if (val == 0) break;
                if (code != 255) {
                    this.bos.write(0);
                }
                copy = code = val;
                --copy;
            }
            this.error = false;
            byte[] byArray = this.bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            this.deinit();
            throw new PhysicalDriverException(3, (Throwable)e);
        }
        finally {
            logger.debug("Received total: " + this.receivedBytesTotal);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int read(byte[] buffer) {
        int toRead = buffer.length;
        long st = System.currentTimeMillis();
        try {
            while (true) {
                int available;
                if ((available = this.inputStream.available()) >= toRead) {
                    return this.inputStream.read(buffer, 0, buffer.length);
                }
                if (st + (long)this.timeout < System.currentTimeMillis()) {
                    return -1;
                }
                SystemClock.sleep((long)5L);
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                this.inputStream.close();
                this.outputStream.close();
                this.socket.close();
                this.initialized = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.info("Closing port");
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void deinit() {
        this.close();
        this.socket = null;
    }

    public static String[] getAvailableConnectionPorts(Context context) {
        BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();
        if (bluetooth == null) {
            Log.d((String)"BowaBlt", (String)"Cannot get bluetooth adapter");
            return new String[0];
        }
        if (!bluetooth.isEnabled()) {
            Log.d((String)"BowaBlt", (String)"Bluetooth is not Enabled.");
            return new String[0];
        }
        Set devices = bluetooth.getBondedDevices();
        boolean found = false;
        String[] ports = new String[devices.size()];
        int index = 0;
        for (BluetoothDevice bd : devices) {
            ports[index] = "BT:" + bd.getAddress();
            ++index;
        }
        return ports;
    }
}

