/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform.android.printer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import sk.singularisdev.common.image.Image;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.PrinterRenderer;
import sk.singularisdev.ekasask.printer.PrinterRendererFactory;

public class AndroidPrinterRenderer
implements PrinterRenderer {
    private CHAR_MODE charMode = CHAR_MODE.NORMAL;
    private LINE_MODE lineMode = LINE_MODE.NORMAL;
    private ALIGN_TYPE alignType = ALIGN_TYPE.LEFT;
    private static final int LEFT_MARGIN = 30;
    private AbstractPrinter printer;
    private Bitmap buffer;
    private int dataLength;
    private byte[] data;
    private int pos = 0;
    private int x = 30;
    private int y = 0;
    private int charWidth;
    private int charHeight;
    private int maxWidth;
    private Canvas canvas;
    private Paint paint;
    private int firstChar = 0;

    @Override
    public Image render(AbstractPrinter printer, byte[] data) {
        this.pos = 0;
        this.x = 30;
        this.y = 0;
        this.firstChar = 0;
        this.buffer = Bitmap.createBitmap((int)1200, (int)600, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas(this.buffer);
        this.paint = new Paint(1);
        Typeface monospace = Typeface.MONOSPACE;
        this.paint.setTypeface(monospace);
        this.paint.setTextSize(20.0f);
        this.paint.setColor(-1);
        this.paint.setStyle(Paint.Style.FILL);
        this.charWidth = 20;
        this.charHeight = 20;
        this.canvas.drawRect(0.0f, 0.0f, (float)this.buffer.getWidth(), (float)this.buffer.getHeight(), this.paint);
        this.paint.setColor(-16777216);
        this.y = this.charHeight;
        this.printer = printer;
        this.maxWidth = printer.getCharPerRow() * this.charWidth;
        this.render(data);
        int[] tmpBuffer = new int[this.buffer.getWidth() * this.buffer.getHeight()];
        this.buffer.getPixels(tmpBuffer, 0, this.buffer.getWidth(), 0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        return new Image(this.buffer.getWidth(), this.buffer.getHeight(), tmpBuffer, 1);
    }

    private void render(byte[] data) {
        this.data = data;
        this.dataLength = data.length;
        while (this.pos < this.dataLength) {
            if (this.reset() || this.crlf() || this.euro() || this.doubleCharOn() || this.doubleCharOff() || this.condenseCharOn() || this.condenseCharOff() || this.condenseLineOn() || this.condenseLineOff() || this.alignCenter() || this.alignLeft() || this.alignRight() || this.bmp()) continue;
            ++this.pos;
        }
        if (this.firstChar < this.pos - 1) {
            String line = new String(data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
        }
        this.buffer = Bitmap.createBitmap((Bitmap)this.buffer, (int)0, (int)0, (int)(this.printer.getCharPerRow() * this.charWidth + 60), (int)(this.y + this.charHeight));
    }

    private boolean reset() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DEFAULT);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.addY(this.charHeight);
            this.x = 30;
            this.pos += seq.length;
            this.firstChar = this.pos;
            this.charMode = CHAR_MODE.NORMAL;
            this.lineMode = LINE_MODE.NORMAL;
            return true;
        }
        return false;
    }

    private boolean crlf() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.addY(this.charHeight);
            this.x = 30;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean euro() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.EURO);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.drawText("\u20ac");
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean doubleCharOn() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_ON);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.charMode = CHAR_MODE.DOUBLE;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean doubleCharOff() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_OFF);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.charMode = CHAR_MODE.NORMAL;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean condenseCharOn() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_ON);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.charMode = CHAR_MODE.CONDENSE;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean condenseCharOff() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_OFF);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.charMode = CHAR_MODE.NORMAL;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean condenseLineOn() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_ON);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.lineMode = LINE_MODE.CONDENSE;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean condenseLineOff() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_OFF);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.lineMode = LINE_MODE.NORMAL;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean alignCenter() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.ALIGNMENT_CENTER);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.alignType = ALIGN_TYPE.CENTER;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean alignLeft() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.ALIGNMENT_LEFT);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.alignType = ALIGN_TYPE.LEFT;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean alignRight() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.ALIGNMENT_RIGHT);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.alignType = ALIGN_TYPE.RIGHT;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean bmp() {
        byte[] seq = new byte[]{29, 42};
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.addY(this.charHeight);
            this.pos += seq.length;
            int w = this.data[this.pos++] * 8;
            int h = this.data[this.pos++];
            int white = -1;
            int black = -16777216;
            int x1 = 30;
            switch (this.alignType) {
                case LEFT: {
                    x1 = 30;
                    break;
                }
                case CENTER: {
                    x1 = 30 + (this.printer.getCharPerRow() * this.charWidth - w) / 2;
                    break;
                }
                case RIGHT: {
                    x1 = 30 + this.printer.getCharPerRow() * this.charWidth - w;
                }
            }
            int posX = 0;
            while (posX < w) {
                int posY = 0;
                while (posY < h) {
                    byte b = this.data[this.pos++];
                    int bitPosition = 0;
                    while (bitPosition < 8) {
                        this.buffer.setPixel(x1 + posX, this.y + posY * 8 + bitPosition, (b >> 7 - bitPosition & 1) == 1 ? black : white);
                        ++bitPosition;
                    }
                    ++posY;
                }
                ++posX;
            }
            this.addY(h * 8 + this.charHeight);
            this.lineMode = LINE_MODE.NORMAL;
            this.pos += 3;
            this.firstChar = this.pos;
            this.x = 30;
            return true;
        }
        return false;
    }

    private void addY(int charHeight) {
        if (this.lineMode == LINE_MODE.NORMAL) {
            this.y += charHeight;
        } else if (this.lineMode == LINE_MODE.CONDENSE) {
            this.y += charHeight / 2;
        }
        if (this.y + charHeight > this.buffer.getHeight()) {
            Bitmap newBitmap = Bitmap.createBitmap((int)this.buffer.getWidth(), (int)(this.buffer.getHeight() + 600), (Bitmap.Config)this.buffer.getConfig());
            Canvas surface = new Canvas(newBitmap);
            Paint white = new Paint();
            white.setTypeface(Typeface.MONOSPACE);
            white.setTextSize(20.0f);
            white.setColor(-1);
            white.setStyle(Paint.Style.FILL);
            surface.drawRect(0.0f, 0.0f, (float)newBitmap.getWidth(), (float)newBitmap.getHeight(), white);
            surface.drawBitmap(this.buffer, 0.0f, 0.0f, white);
            this.buffer = newBitmap;
            this.canvas = new Canvas(this.buffer);
            this.paint = new Paint(1);
            this.paint.setTypeface(Typeface.MONOSPACE);
            this.paint.setTextSize(20.0f);
            this.paint.setColor(-16777216);
        }
    }

    private void drawText(String line) {
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        switch (this.charMode) {
            case NORMAL: {
                scaleX = 1.0f;
                break;
            }
            case CONDENSE: {
                scaleX = 0.5f;
                break;
            }
            case DOUBLE: {
                scaleX = 2.0f;
            }
        }
        switch (this.lineMode) {
            case NORMAL: {
                scaleY = 1.0f;
                break;
            }
            case CONDENSE: {
                scaleY = 0.5f;
            }
        }
        float textSize = this.paint.getTextSize();
        this.paint.setTextSize(textSize * scaleY);
        this.paint.setTextScaleX(scaleX / scaleY);
        int i = 0;
        while (i < line.length()) {
            this.canvas.drawText(line.substring(i, i + 1), (float)((int)((float)this.x / scaleX)), (float)((int)((float)this.y / scaleY)), this.paint);
            this.x += (int)((float)this.charWidth * scaleX);
            ++i;
        }
        this.paint.setTextSize(textSize * (1.0f / scaleY));
        this.paint.setTextScaleX(textSize * (1.0f / scaleX));
    }

    private boolean isSeq(byte[] data, int dataLength, int pos, byte[] escSequence) {
        int l = escSequence.length;
        if (pos + l > dataLength) {
            return false;
        }
        int i = 0;
        while (i < l) {
            if (data[pos + i] != escSequence[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static enum ALIGN_TYPE {
        LEFT,
        RIGHT,
        CENTER;

    }

    private static enum CHAR_MODE {
        CONDENSE,
        NORMAL,
        DOUBLE;

    }

    public static class Factory
    implements PrinterRendererFactory {
        @Override
        public PrinterRenderer createInstance() {
            return new AndroidPrinterRenderer();
        }
    }

    private static enum LINE_MODE {
        CONDENSE,
        NORMAL;

    }
}

