/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform.android.rs232;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.SystemClock;
import android.util.Log;
import com.felhr.usbserial.CDCSerialDevice;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.exception.PhysicalDriverException;
import sk.singularisdev.cryptoprotocol.layers.PhysicalDriver;
import sk.singularisdev.cryptoprotocol.utils.Cobs;

public class FelhrRs232Driver
implements PhysicalDriver {
    private static final Logger logger = LoggerManager.getLogger(FelhrRs232Driver.class.getName());
    private static final String TAG = "FelhrRs232Driver";
    private static final String ACTION_USB_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    private static final String ACTION_USB_DETACHED = "android.hardware.usb.action.USB_DEVICE_DETACHED";
    private static final String ACTION_USB_READY = "sk.singularisdev.connectivityservices.USB_READY";
    private static final String ACTION_USB_NOT_SUPPORTED = "sk.singularisdev.usbservice.USB_NOT_SUPPORTED";
    public static final String ACTION_NO_USB = "sk.singularisdev.usbservice.NO_USB";
    private static final String ACTION_USB_PERMISSION_GRANTED = "sk.singularisdev.usbservice.USB_PERMISSION_GRANTED";
    private static final String ACTION_USB_PERMISSION_NOT_GRANTED = "sk.singularisdev.usbservice.USB_PERMISSION_NOT_GRANTED";
    private static final String ACTION_USB_DISCONNECTED = "sk.singularisdev.usbservice.USB_DISCONNECTED";
    private static final String ACTION_CDC_DRIVER_NOT_WORKING = "sk.singularisdev.connectivityservices.ACTION_CDC_DRIVER_NOT_WORKING";
    private static final String ACTION_USB_DEVICE_NOT_WORKING = "sk.singularisdev.connectivityservices.ACTION_USB_DEVICE_NOT_WORKING";
    private static final String ACTION_USB_PERMISSION = "sk.singularisdev.USB_PERMISSION";
    private final int vid;
    private final int pid;
    private BaudRate baudRate;
    private Context context;
    private UsbManager usbManager;
    private UsbDevice device;
    private UsbDeviceConnection connection;
    private UsbSerialDevice serialPort;
    private BlockingQueue<Byte> receivedBytesQueue;
    private boolean serialPortConnected;
    private int timeout;
    private long receivedBytesTotal;
    private final BroadcastReceiver usbReceiver = new BroadcastReceiver(){

        public void onReceive(Context arg0, Intent arg1) {
            switch (Objects.requireNonNull(arg1.getAction())) {
                case "sk.singularisdev.USB_PERMISSION": {
                    boolean granted = arg1.getExtras().getBoolean("permission");
                    if (granted) {
                        Intent intent = new Intent(FelhrRs232Driver.ACTION_USB_PERMISSION_GRANTED);
                        arg0.sendBroadcast(intent);
                        break;
                    }
                    Intent intent = new Intent(FelhrRs232Driver.ACTION_USB_PERMISSION_NOT_GRANTED);
                    arg0.sendBroadcast(intent);
                    break;
                }
                case "android.hardware.usb.action.USB_DEVICE_ATTACHED": {
                    if (FelhrRs232Driver.this.serialPortConnected) break;
                    FelhrRs232Driver.this.findSerialPortDevice();
                    break;
                }
                case "android.hardware.usb.action.USB_DEVICE_DETACHED": {
                    Intent intent = new Intent(FelhrRs232Driver.ACTION_USB_DISCONNECTED);
                    arg0.sendBroadcast(intent);
                    if (FelhrRs232Driver.this.serialPortConnected) {
                        FelhrRs232Driver.this.serialPort.close();
                    }
                    FelhrRs232Driver.this.serialPortConnected = false;
                }
            }
        }
    };
    private UsbSerialInterface.UsbReadCallback mCallback = new UsbSerialInterface.UsbReadCallback(){

        public void onReceivedData(byte[] arg0) {
            byte[] byArray = arg0;
            int n = arg0.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                FelhrRs232Driver.this.receivedBytesQueue.add(b);
                ++n2;
            }
        }
    };

    public FelhrRs232Driver(Context context, int vid, int pid, BaudRate baudRate, int timeout, int internalQueueSize) {
        this.context = context.getApplicationContext();
        this.vid = vid;
        this.pid = pid;
        this.baudRate = baudRate;
        this.timeout = timeout;
        this.serialPortConnected = false;
        this.setFilter();
        this.usbManager = (UsbManager)this.context.getSystemService("usb");
        this.findSerialPortDevice();
        this.receivedBytesQueue = new ArrayBlockingQueue<Byte>(internalQueueSize);
    }

    @Override
    public void init() {
        this.receivedBytesQueue.clear();
        this.findSerialPortDevice();
    }

    @Override
    public void connect() throws PhysicalDriverException {
        ConnectionThread connectionThread = new ConnectionThread();
        connectionThread.start();
        try {
            connectionThread.join();
        }
        catch (InterruptedException e) {
            throw new PhysicalDriverException(1);
        }
        if (!connectionThread.connected) {
            throw new PhysicalDriverException(1);
        }
    }

    @Override
    public void send(byte[] frame) throws PhysicalDriverException {
        if (!this.serialPortConnected) {
            throw new PhysicalDriverException(5);
        }
        try {
            byte[] cobsFrame = Cobs.encode(frame);
            this.serialPort.write(cobsFrame);
        }
        catch (Exception e) {
            this.deinit();
            throw new PhysicalDriverException(2, (Throwable)e);
        }
    }

    @Override
    public byte[] recv() throws PhysicalDriverException {
        if (!this.serialPortConnected) {
            throw new PhysicalDriverException(5);
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.reset();
            boolean waitForSof = true;
            int prevVal = -1;
            int copy = 0;
            int code = 255;
            byte[] codeArray = new byte[1];
            while (true) {
                if (copy > 0) {
                    byte[] b = new byte[copy];
                    int read = this.read(b);
                    this.receivedBytesTotal += (long)read;
                    if (read != copy) {
                        throw new PhysicalDriverException(4);
                    }
                    bos.write(b, 0, b.length);
                    copy = 0;
                    continue;
                }
                int read = this.read(codeArray);
                this.receivedBytesTotal += (long)read;
                if (read != codeArray.length) {
                    throw new PhysicalDriverException(4);
                }
                int val = codeArray[0] & 0xFF;
                if (waitForSof && prevVal == -1 && val == 0) {
                    prevVal = 0;
                    continue;
                }
                if (waitForSof && prevVal == 0 && val != 0) {
                    waitForSof = false;
                } else if (waitForSof) {
                    prevVal = -1;
                    continue;
                }
                if (val == 0) break;
                if (code != 255) {
                    bos.write(0);
                }
                copy = code = val;
                --copy;
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            this.deinit();
            logger.error("Error receiving frame: " + e.getMessage());
            throw new PhysicalDriverException(3, (Throwable)e);
        }
        finally {
            logger.debug("Received total: " + this.receivedBytesTotal);
        }
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void deinit() {
    }

    private void setFilter() {
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_USB_PERMISSION);
        filter.addAction(ACTION_USB_DETACHED);
        filter.addAction(ACTION_USB_ATTACHED);
        this.context.registerReceiver(this.usbReceiver, filter);
    }

    private void requestUserPermission() {
        Log.d((String)TAG, (String)String.format("requestUserPermission(%X:%X)", this.device.getVendorId(), this.device.getProductId()));
        PendingIntent mPendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        this.usbManager.requestPermission(this.device, mPendingIntent);
    }

    private void findSerialPortDevice() {
        HashMap usbDevices = this.usbManager.getDeviceList();
        if (!usbDevices.isEmpty()) {
            for (Map.Entry entry : usbDevices.entrySet()) {
                this.device = (UsbDevice)entry.getValue();
                Log.d((String)TAG, (String)String.format("USBDevice.HashMap (vid:pid) (%X:%X)-%b class:%X:%X name:%s", this.device.getVendorId(), this.device.getProductId(), UsbSerialDevice.isSupported((UsbDevice)this.device), this.device.getDeviceClass(), this.device.getDeviceSubclass(), this.device.getDeviceName()));
            }
            for (Map.Entry entry : usbDevices.entrySet()) {
                this.device = (UsbDevice)entry.getValue();
                int deviceVID = this.device.getVendorId();
                int devicePID = this.device.getProductId();
                if (UsbSerialDevice.isSupported((UsbDevice)this.device) && this.vid == deviceVID && this.pid == devicePID) {
                    this.requestUserPermission();
                    break;
                }
                this.connection = null;
                this.device = null;
            }
            if (this.device == null) {
                Log.d((String)TAG, (String)"There are no USB devices connected (but usb host were listed). Send an intent to MainActivity.");
            }
        } else {
            Log.d((String)TAG, (String)"findSerialPortDevice() usbManager returned empty device list.");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int read(byte[] buffer) {
        int toRead = buffer.length;
        long st = System.currentTimeMillis();
        try {
            int available;
            while ((available = this.receivedBytesQueue.size()) < toRead) {
                if (st + (long)this.timeout < System.currentTimeMillis()) {
                    return -1;
                }
                SystemClock.sleep((long)5L);
            }
            int i = 0;
            while (i < buffer.length) {
                buffer[i] = this.receivedBytesQueue.take();
                ++i;
            }
            return buffer.length;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String[] getAvailableConnectionPorts(Context context) {
        UsbManager usbManager = (UsbManager)context.getSystemService("usb");
        HashMap usbDevices = usbManager.getDeviceList();
        ArrayList<String> ports = new ArrayList<String>();
        for (Map.Entry entry : usbDevices.entrySet()) {
            UsbDevice device = (UsbDevice)entry.getValue();
            int deviceVID = device.getVendorId();
            int devicePID = device.getProductId();
            if (!UsbSerialDevice.isSupported((UsbDevice)device)) continue;
            ports.add("RS232:" + deviceVID + "|" + devicePID);
            break;
        }
        return ports.toArray(new String[0]);
    }

    public static enum BaudRate {
        Rate_1200bd(1200),
        Rate_2400bd(2400),
        Rate_4800bd(4800),
        Rate_9600bd(9600),
        Rate_19200bd(19200),
        Rate_38400bd(38400),
        Rate_57600bd(57600),
        Rate_115200bd(115200),
        Rate_230400bd(230400),
        Rate_460800bd(460800),
        Rate_921600bd(921600),
        Rate_Unknown(-1);

        private int baudRate;

        private BaudRate(int rate) {
            this.baudRate = rate;
        }

        public static BaudRate fromString(String baudRate) {
            BaudRate[] baudRates;
            int baudRateInt = Integer.parseInt(baudRate);
            BaudRate[] baudRateArray = baudRates = BaudRate.values();
            int n = baudRates.length;
            int n2 = 0;
            while (n2 < n) {
                BaudRate item = baudRateArray[n2];
                if (item.baudRate == baudRateInt) {
                    return item;
                }
                ++n2;
            }
            return Rate_Unknown;
        }

        public int getBaudRate() {
            return this.baudRate;
        }
    }

    private class ConnectionThread
    extends Thread {
        boolean connected;

        private ConnectionThread() {
        }

        @Override
        public void run() {
            if (FelhrRs232Driver.this.device == null) {
                this.connected = false;
            } else {
                boolean hasPersmission;
                this.connected = true;
                long ts = System.currentTimeMillis() + (long)FelhrRs232Driver.this.timeout;
                while (!(hasPersmission = FelhrRs232Driver.this.usbManager.hasPermission(FelhrRs232Driver.this.device)) && ts > System.currentTimeMillis()) {
                }
                if (!hasPersmission) {
                    this.connected = false;
                    return;
                }
                FelhrRs232Driver.this.connection = FelhrRs232Driver.this.usbManager.openDevice(FelhrRs232Driver.this.device);
                FelhrRs232Driver.this.serialPort = UsbSerialDevice.createUsbSerialDevice((UsbDevice)FelhrRs232Driver.this.device, (UsbDeviceConnection)FelhrRs232Driver.this.connection);
                if (FelhrRs232Driver.this.serialPort != null) {
                    if (FelhrRs232Driver.this.serialPort.open()) {
                        FelhrRs232Driver.this.serialPortConnected = true;
                        FelhrRs232Driver.this.serialPort.setBaudRate(FelhrRs232Driver.this.baudRate.getBaudRate());
                        FelhrRs232Driver.this.serialPort.setDataBits(8);
                        FelhrRs232Driver.this.serialPort.setStopBits(1);
                        FelhrRs232Driver.this.serialPort.setParity(0);
                        FelhrRs232Driver.this.serialPort.setFlowControl(0);
                        FelhrRs232Driver.this.serialPort.read(FelhrRs232Driver.this.mCallback);
                        Intent intent = new Intent(FelhrRs232Driver.ACTION_USB_READY);
                        FelhrRs232Driver.this.context.sendBroadcast(intent);
                    } else if (FelhrRs232Driver.this.serialPort instanceof CDCSerialDevice) {
                        Intent intent = new Intent(FelhrRs232Driver.ACTION_CDC_DRIVER_NOT_WORKING);
                        FelhrRs232Driver.this.context.sendBroadcast(intent);
                        this.connected = false;
                    } else {
                        Intent intent = new Intent(FelhrRs232Driver.ACTION_USB_DEVICE_NOT_WORKING);
                        FelhrRs232Driver.this.context.sendBroadcast(intent);
                        this.connected = false;
                    }
                } else {
                    Intent intent = new Intent(FelhrRs232Driver.ACTION_USB_NOT_SUPPORTED);
                    FelhrRs232Driver.this.context.sendBroadcast(intent);
                    this.connected = false;
                }
            }
        }
    }
}

