/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform.android.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TLSSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory internalSSLSocketFactory;

    public TLSSocketFactory(SSLSocketFactory delegate) throws KeyManagementException, NoSuchAlgorithmException {
        this.internalSSLSocketFactory = delegate;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.internalSSLSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.internalSSLSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return TLSSocketFactory.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return TLSSocketFactory.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return TLSSocketFactory.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return TLSSocketFactory.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return TLSSocketFactory.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket() throws IOException {
        return TLSSocketFactory.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket());
    }

    private static Socket enableTLSOnSocket(Socket socket) {
        if (socket != null && socket instanceof SSLSocket && TLSSocketFactory.isTLSServerEnabled((SSLSocket)socket)) {
            ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
        }
        return socket;
    }

    private static boolean isTLSServerEnabled(SSLSocket sslSocket) {
        System.out.println("__prova__ :: " + sslSocket.getSupportedProtocols().toString());
        String[] stringArray = sslSocket.getSupportedProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String protocol = stringArray[n2];
            if (protocol.equals("TLSv1.1") || protocol.equals("TLSv1.2")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

