/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform.desktop;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sk.singularisdev.chdu.exception.ChduException;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.layers.PhysicalDriver;
import sk.singularisdev.ekasask.Configuration;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.printer.PrinterRenderer;
import sk.singularisdev.ekasask.printer.RendererWorker;
import sk.singularisdev.platform.desktop.printer.AwtPrinterRenderer;
import sk.singularisdev.platform.desktop.rs232.Rs232Driver;
import sk.singularisdev.platform.desktop.tcp.TcpDriver;

public class DesktopPlatform {
    private static final Logger logger = LoggerManager.getLogger(DesktopPlatform.class.getName());

    public static void Init(int i, Object ... objects) {
    }

    public static void CreateAndSetPrinterRendererInstance() throws EKasaException {
        AwtPrinterRenderer.Factory printerRendererFactory = new AwtPrinterRenderer.Factory();
        PrinterRenderer printerRenderer = printerRendererFactory.createInstance();
        RendererWorker.setPrinterRenderer(printerRenderer);
    }

    public static PhysicalDriver CreatePhysicalDriverInstance(String connectionString) throws ChduException {
        String[] splitted = connectionString.split(":");
        if (splitted.length == 0) {
            throw new ChduException(5);
        }
        if (splitted[0].toLowerCase().contains("rs232")) {
            return new Rs232Driver(splitted[1], Rs232Driver.BaudRate.fromString(splitted[2]), Configuration.getChduCommunicationTimeout(), Configuration.getRS232WaitForData());
        }
        if (splitted[0].toLowerCase().contains("tcp")) {
            String[] splittedIpPort = splitted[1].split("\\|");
            return new TcpDriver(splittedIpPort[0], Integer.parseInt(splittedIpPort[1]), Configuration.getChduCommunicationTimeout());
        }
        throw new ChduException(5);
    }

    public static File GetDataDirectory() {
        return new File("");
    }

    public static String[] getAvailableConnectionPorts(String type) {
        if (type.toLowerCase().contains("rs232")) {
            return Rs232Driver.getAvailableConnectionPorts();
        }
        return new String[0];
    }

    public static SSLSocket CreateSSLSocket(String address, int port, int timeout) throws IOException {
        InetAddress addr = InetAddress.getByName(address);
        SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sock = (SSLSocket)sslsocketfactory.createSocket();
        sock.setSoTimeout(timeout);
        sock.connect(new InetSocketAddress(addr, port), timeout);
        return sock;
    }

    public static SSLSocket CreateSSLSocket(Socket tunnel, String url, int port, boolean autoclose) throws IOException {
        SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sock = (SSLSocket)sslsocketfactory.createSocket(tunnel, url, port, true);
        return sock;
    }
}

