/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform.desktop.printer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import sk.singularisdev.common.image.Image;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.PrinterRenderer;
import sk.singularisdev.ekasask.printer.PrinterRendererFactory;

public class AwtPrinterRenderer
implements PrinterRenderer {
    private static final int LEFT_MARGIN = 30;
    private AbstractPrinter printer;
    private Graphics2D g2;
    private BufferedImage buffer;
    private int dataLength;
    private byte[] data;
    private int pos = 0;
    private int x = 30;
    private int y = 0;
    private int charWidth;
    private int charHeight;
    private int maxWidth;
    private CHAR_MODE charMode = CHAR_MODE.NORMAL;
    private LINE_MODE lineMode = LINE_MODE.NORMAL;
    private ALIGN_TYPE alignType = ALIGN_TYPE.LEFT;
    private int firstChar = 0;

    @Override
    public Image render(AbstractPrinter printer, byte[] data) {
        this.firstChar = 0;
        this.pos = 0;
        this.x = 30;
        this.y = 0;
        this.charMode = CHAR_MODE.NORMAL;
        this.lineMode = LINE_MODE.NORMAL;
        this.alignType = ALIGN_TYPE.LEFT;
        this.firstChar = 0;
        this.buffer = new BufferedImage(1200, 1200, 1);
        this.g2 = this.buffer.createGraphics();
        this.g2.setFont(new Font("Monospaced", 0, 20));
        this.g2.setBackground(Color.WHITE);
        this.g2.clearRect(0, 0, 1200, 1200);
        this.g2.setColor(Color.BLACK);
        this.charWidth = this.g2.getFontMetrics().stringWidth("x");
        this.y = this.charHeight = this.g2.getFontMetrics().getHeight();
        this.printer = printer;
        this.maxWidth = printer.getCharPerRow() * this.charWidth;
        this.render(data);
        int[] ib = ((DataBufferInt)this.buffer.getRaster().getDataBuffer()).getData();
        return new Image(this.buffer.getWidth(), this.buffer.getHeight(), ib, 1);
    }

    private void render(byte[] data) {
        this.data = data;
        this.dataLength = data.length;
        while (this.pos < this.dataLength) {
            if (this.reset() || this.crlf() || this.euro() || this.doubleCharOn() || this.doubleCharOff() || this.condenseCharOn() || this.condenseCharOff() || this.condenseLineOn() || this.condenseLineOff() || this.alignCenter() || this.alignLeft() || this.alignRight() || this.bmp()) continue;
            ++this.pos;
        }
        if (this.firstChar < this.pos - 1) {
            String line = new String(data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
        }
        BufferedImage newBuffer = new BufferedImage(this.printer.getCharPerRow() * this.charWidth + 60, this.y + this.charHeight, 1);
        Graphics2D newG2 = newBuffer.createGraphics();
        newG2.setFont(new Font("Monospaced", 0, 20));
        newG2.setBackground(Color.WHITE);
        newG2.clearRect(0, 0, this.printer.getCharPerRow() * this.charWidth + 60, this.y + this.charHeight);
        newG2.setColor(Color.BLACK);
        newG2.drawImage(this.buffer, null, 0, 0);
        this.buffer = newBuffer;
        this.g2 = newG2;
    }

    private boolean reset() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DEFAULT);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.addY(this.charHeight);
            this.x = 30;
            this.pos += seq.length;
            this.firstChar = this.pos;
            this.charMode = CHAR_MODE.NORMAL;
            this.lineMode = LINE_MODE.NORMAL;
            return true;
        }
        return false;
    }

    private boolean crlf() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.CRLF);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.addY(this.charHeight);
            this.x = 30;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean euro() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.EURO);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.drawText("\u20ac");
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean doubleCharOn() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_ON);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.charMode = CHAR_MODE.DOUBLE;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean doubleCharOff() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_OFF);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.charMode = CHAR_MODE.NORMAL;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean condenseCharOn() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_ON);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.charMode = CHAR_MODE.CONDENSE;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean condenseCharOff() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_OFF);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.charMode = CHAR_MODE.NORMAL;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean condenseLineOn() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_ON);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.lineMode = LINE_MODE.CONDENSE;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean condenseLineOff() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_OFF);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.lineMode = LINE_MODE.NORMAL;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean alignCenter() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.ALIGNMENT_CENTER);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.alignType = ALIGN_TYPE.CENTER;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean alignLeft() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.ALIGNMENT_LEFT);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.alignType = ALIGN_TYPE.LEFT;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean alignRight() {
        byte[] seq = this.printer.getEscSequence(PRINT_SEQUENCE_TYPE.ALIGNMENT_RIGHT);
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.alignType = ALIGN_TYPE.RIGHT;
            this.pos += seq.length;
            this.firstChar = this.pos;
            return true;
        }
        return false;
    }

    private boolean bmp() {
        byte[] seq = new byte[]{29, 42};
        if (this.isSeq(this.data, this.dataLength, this.pos, seq)) {
            String line = new String(this.data, this.firstChar, this.pos - this.firstChar, this.printer.getCharset());
            this.drawText(line);
            this.pos += seq.length;
            int w = this.data[this.pos++] * 8;
            int h = this.data[this.pos++];
            int white = Color.WHITE.getRGB();
            int black = Color.BLACK.getRGB();
            BufferedImage image = new BufferedImage(w, h * 8, 1);
            int posX = 0;
            while (posX < w) {
                int posY = 0;
                while (posY < h) {
                    byte b = this.data[this.pos++];
                    int bitPosition = 0;
                    while (bitPosition < 8) {
                        image.setRGB(posX, posY * 8 + bitPosition, (b >> 7 - bitPosition & 1) == 1 ? black : white);
                        ++bitPosition;
                    }
                    ++posY;
                }
                ++posX;
            }
            int x1 = 30;
            switch (this.alignType) {
                case LEFT: {
                    x1 = 30;
                    break;
                }
                case CENTER: {
                    x1 = 30 + (this.printer.getCharPerRow() * this.charWidth - w) / 2;
                    break;
                }
                case RIGHT: {
                    x1 = 30 + this.printer.getCharPerRow() * this.charWidth - w;
                }
            }
            int qrCodeY = this.y;
            this.addY(h * 8 + this.charHeight);
            this.g2.drawImage(image, x1, qrCodeY, w, h * 8, null);
            this.lineMode = LINE_MODE.NORMAL;
            this.pos += 3;
            this.firstChar = this.pos;
            this.x = 30;
            return true;
        }
        return false;
    }

    private void addY(int charHeight) {
        if (this.lineMode == LINE_MODE.NORMAL) {
            this.y += charHeight;
        } else if (this.lineMode == LINE_MODE.CONDENSE) {
            this.y += charHeight / 2;
        }
        if (this.y > this.buffer.getHeight()) {
            BufferedImage newBuffer = new BufferedImage(1200, this.buffer.getHeight() + 1200, 1);
            Graphics2D newG2 = newBuffer.createGraphics();
            newG2.setFont(new Font("Monospaced", 0, 20));
            newG2.setBackground(Color.WHITE);
            newG2.clearRect(0, 0, 1200, this.buffer.getHeight() + 1200);
            newG2.setColor(Color.BLACK);
            newG2.drawImage(this.buffer, null, 0, 0);
            this.buffer = newBuffer;
            this.g2 = newG2;
        }
    }

    private void drawText(String line) {
        double scaleX = 1.0;
        double scaleY = 1.0;
        switch (this.charMode) {
            case NORMAL: {
                scaleX = 1.0;
                break;
            }
            case CONDENSE: {
                scaleX = 0.5;
                break;
            }
            case DOUBLE: {
                scaleX = 2.0;
            }
        }
        switch (this.lineMode) {
            case NORMAL: {
                scaleY = 1.0;
                break;
            }
            case CONDENSE: {
                scaleY = 0.5;
            }
        }
        this.g2.scale(scaleX, scaleY);
        int i = 0;
        while (i < line.length()) {
            this.g2.drawString(line.substring(i, i + 1), (int)((double)this.x / scaleX), (int)((double)this.y / scaleY));
            this.x += (int)((double)this.charWidth * scaleX);
            ++i;
        }
        this.g2.scale(1.0 / scaleX, 1.0 / scaleY);
    }

    private boolean isSeq(byte[] data, int dataLength, int pos, byte[] escSequence) {
        int l = escSequence.length;
        if (pos + l > dataLength) {
            return false;
        }
        int i = 0;
        while (i < l) {
            if (data[pos + i] != escSequence[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static enum ALIGN_TYPE {
        LEFT,
        RIGHT,
        CENTER;

    }

    private static enum CHAR_MODE {
        CONDENSE,
        NORMAL,
        DOUBLE;

    }

    public static class Factory
    implements PrinterRendererFactory {
        @Override
        public PrinterRenderer createInstance() {
            return new AwtPrinterRenderer();
        }
    }

    private static enum LINE_MODE {
        CONDENSE,
        NORMAL;

    }
}

