/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform.desktop.rs232;

import com.fazecast.jSerialComm.SerialPort;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.exception.PhysicalDriverException;
import sk.singularisdev.cryptoprotocol.layers.PhysicalDriver;
import sk.singularisdev.cryptoprotocol.utils.Cobs;

public class Rs232Driver
implements PhysicalDriver {
    private final Logger logger = LoggerManager.getLogger(Rs232Driver.class.getName());
    private boolean waitForDataFirst;
    private String portName;
    private SerialPort serialPort;
    private ByteArrayOutputStream bos;
    private BaudRate baudRate;
    private int timeout;
    private InputStream inputStream;
    private OutputStream outputStream;
    private long receivedBytesTotal;

    public static List<SerialPortName> getOpenedPorts() {
        SerialPort[] ports = SerialPort.getCommPorts();
        ArrayList<SerialPortName> portsNames = new ArrayList<SerialPortName>();
        SerialPort[] serialPortArray = ports;
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            SerialPort s = serialPortArray[n2];
            portsNames.add(new SerialPortName(s.getDescriptivePortName(), s.getSystemPortName()));
            ++n2;
        }
        return portsNames;
    }

    public Rs232Driver(String portName, BaudRate baudRate, int timeout, boolean waitForData) {
        this.portName = portName;
        this.baudRate = baudRate;
        this.timeout = timeout;
        this.receivedBytesTotal = 0L;
        this.bos = new ByteArrayOutputStream();
        this.waitForDataFirst = waitForData;
    }

    public Rs232Driver(SerialPortName portName, BaudRate baudRate, int timeout) {
        this.portName = portName.getSystemPortName();
        this.baudRate = baudRate;
        this.timeout = timeout;
        this.bos = new ByteArrayOutputStream();
    }

    @Override
    public void init() {
        SerialPort[] ports;
        SerialPort[] serialPortArray = ports = SerialPort.getCommPorts();
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            SerialPort s = serialPortArray[n2];
            if (s.getSystemPortName().equals(this.portName)) {
                this.serialPort = s;
                break;
            }
            ++n2;
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void connect() throws PhysicalDriverException {
        if (this.serialPort == null) {
            throw new PhysicalDriverException(5);
        }
        try {
            this.logger.info("Openning port: " + this.serialPort.getSystemPortName() + ":" + this.baudRate.baudRate + "With timeout: " + this.timeout);
            if (!this.serialPort.isOpen() && !this.serialPort.openPort()) {
                this.serialPort.closePort();
                if (!this.serialPort.openPort()) {
                    throw new PhysicalDriverException(1);
                }
            }
            this.logger.info("Port opened");
            this.serialPort.clearDTR();
            this.serialPort.clearRTS();
            this.serialPort.setFlowControl(0);
            this.serialPort.setComPortParameters(this.baudRate.getBaudRate(), 8, 1, 0);
            this.serialPort.setComPortTimeouts(4352, this.timeout, this.timeout);
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            while (this.inputStream.available() > 0) {
                int n = this.inputStream.read();
            }
        }
        catch (PhysicalDriverException e) {
            this.deinit();
            throw e;
        }
        catch (Exception e) {
            this.deinit();
            throw new PhysicalDriverException(1, (Throwable)e);
        }
    }

    @Override
    public void send(byte[] frame) throws PhysicalDriverException {
        try {
            byte[] cobsFrame = Cobs.encode(frame);
            this.outputStream.write(cobsFrame);
        }
        catch (IOException e) {
            this.logger.error("Error sending frame", e);
            this.deinit();
            throw new PhysicalDriverException(2, (Throwable)e);
        }
        catch (Exception e) {
            this.deinit();
            throw new PhysicalDriverException(2, (Throwable)e);
        }
    }

    @Override
    public byte[] recv() throws PhysicalDriverException {
        try {
            this.bos.reset();
            boolean waitForSof = true;
            int prevVal = -1;
            int copy = 0;
            int code = 255;
            byte[] codeArray = new byte[1];
            long ts = System.currentTimeMillis();
            while (this.waitForDataFirst) {
                if (this.inputStream.available() > 0) break;
                if (ts + (long)this.timeout < System.currentTimeMillis()) {
                    throw new PhysicalDriverException(4);
                }
                Thread.sleep(20L);
            }
            while (true) {
                if (copy > 0) {
                    byte[] b = new byte[copy];
                    int read = this.inputStream.read(b, 0, copy);
                    this.receivedBytesTotal += (long)read;
                    if (read != copy) {
                        throw new PhysicalDriverException(4);
                    }
                    this.bos.write(b, 0, b.length);
                    copy = 0;
                    continue;
                }
                int read = this.inputStream.read(codeArray, 0, 1);
                this.receivedBytesTotal += (long)read;
                if (read != codeArray.length) {
                    throw new PhysicalDriverException(4);
                }
                int val = codeArray[0] & 0xFF;
                if (waitForSof && prevVal == -1 && val == 0) {
                    prevVal = 0;
                    continue;
                }
                if (waitForSof && prevVal == 0 && val != 0) {
                    waitForSof = false;
                } else if (waitForSof) {
                    prevVal = -1;
                    continue;
                }
                if (val == 0) break;
                if (code != 255) {
                    this.bos.write(0);
                }
                copy = code = val;
                --copy;
            }
            byte[] byArray = this.bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            this.deinit();
            this.logger.error("Error receiving frame: " + e.getMessage());
            throw new PhysicalDriverException(4, (Throwable)e);
        }
        catch (Exception e) {
            this.deinit();
            throw new PhysicalDriverException(3, (Throwable)e);
        }
        finally {
            this.logger.debug("Received total: " + this.receivedBytesTotal);
        }
    }

    @Override
    public void close() {
        if (this.serialPort != null) {
            this.serialPort.closePort();
            this.logger.info("Closing port");
        }
    }

    @Override
    public void deinit() {
        this.close();
        this.serialPort = null;
    }

    public static String[] getAvailableConnectionPorts() {
        SerialPort[] ports = SerialPort.getCommPorts();
        StringBuilder sb = new StringBuilder();
        String[] p = new String[ports.length];
        int i = 0;
        while (i < p.length) {
            p[i] = "RS232:" + ports[i].getSystemPortName();
            ++i;
        }
        return p;
    }

    public static enum BaudRate {
        Rate_1200bd(1200),
        Rate_2400bd(2400),
        Rate_4800bd(4800),
        Rate_9600bd(9600),
        Rate_19200bd(19200),
        Rate_38400bd(38400),
        Rate_57600bd(57600),
        Rate_115200bd(115200),
        Rate_230400bd(230400),
        Rate_460800bd(460800),
        Rate_921600bd(921600),
        Rate_Unknown(-1);

        private int baudRate;

        private BaudRate(int rate) {
            this.baudRate = rate;
        }

        public static BaudRate fromString(String baudRate) {
            BaudRate[] baudRates;
            int baudRateInt = Integer.parseInt(baudRate);
            BaudRate[] baudRateArray = baudRates = BaudRate.values();
            int n = baudRates.length;
            int n2 = 0;
            while (n2 < n) {
                BaudRate item = baudRateArray[n2];
                if (item.baudRate == baudRateInt) {
                    return item;
                }
                ++n2;
            }
            return Rate_Unknown;
        }

        public int getBaudRate() {
            return this.baudRate;
        }
    }

    public static class SerialPortName {
        private String portName;
        private String systemPortName;

        SerialPortName(String portName, String systemPortName) {
            this.portName = portName;
            this.systemPortName = systemPortName;
        }

        public String getPortName() {
            return this.portName;
        }

        String getSystemPortName() {
            return this.systemPortName;
        }

        public String toString() {
            return this.portName;
        }
    }
}

