/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.platform.desktop.tcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import sk.singularisdev.common.logs.Logger;
import sk.singularisdev.common.logs.LoggerManager;
import sk.singularisdev.cryptoprotocol.ciphers.Util;
import sk.singularisdev.cryptoprotocol.exception.PhysicalDriverException;
import sk.singularisdev.cryptoprotocol.layers.PhysicalDriver;
import sk.singularisdev.cryptoprotocol.utils.Cobs;

public class TcpDriver
implements PhysicalDriver {
    private final Logger logger = LoggerManager.getLogger(TcpDriver.class.getName());
    private Socket socket;
    private ByteArrayOutputStream bos;
    private String ip;
    private int port;
    private int timeout;
    private InputStream inputStream;
    private OutputStream outputStream;
    private long receivedBytesTotal;

    public TcpDriver(String ip, int port, int timeout) {
        this.ip = ip;
        this.port = port;
        this.timeout = timeout;
        this.receivedBytesTotal = 0L;
        this.bos = new ByteArrayOutputStream();
    }

    @Override
    public void init() {
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void connect() throws PhysicalDriverException {
        try {
            this.logger.info("Openning socket: " + this.ip + ":" + this.port + "With timeout: " + this.timeout);
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            this.socket.connect(new InetSocketAddress(this.ip, this.port), 5000);
            this.socket.setSoTimeout(this.timeout);
            this.logger.info("Port opened");
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            while (this.inputStream.available() > 0) {
                int n = this.inputStream.read();
            }
        }
        catch (Exception e) {
            this.deinit();
            throw new PhysicalDriverException(1, (Throwable)e);
        }
    }

    @Override
    public void send(byte[] frame) throws PhysicalDriverException {
        try {
            byte[] cobsFrame = Cobs.encode(frame);
            this.outputStream.write(cobsFrame);
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.logger.error("Error sending frame", e);
            this.deinit();
            throw new PhysicalDriverException(2, (Throwable)e);
        }
        catch (Exception e) {
            this.deinit();
            throw new PhysicalDriverException(2, (Throwable)e);
        }
    }

    @Override
    public byte[] recv() throws PhysicalDriverException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.bos.reset();
            boolean waitForSof = true;
            int prevVal = -1;
            int copy = 0;
            int code = 255;
            byte[] codeArray = new byte[1];
            while (true) {
                if (copy > 0) {
                    byte[] b = new byte[copy];
                    int read = this.inputStream.read(b, 0, copy);
                    baos.write(b, 0, read);
                    this.receivedBytesTotal += (long)read;
                    if (read != copy) {
                        throw new PhysicalDriverException(4);
                    }
                    this.bos.write(b, 0, b.length);
                    copy = 0;
                    continue;
                }
                int read = this.inputStream.read(codeArray, 0, 1);
                ++this.receivedBytesTotal;
                if (read != codeArray.length) {
                    throw new PhysicalDriverException(4);
                }
                baos.write(codeArray);
                int val = codeArray[0] & 0xFF;
                if (waitForSof && prevVal == -1 && val == 0) {
                    prevVal = 0;
                    continue;
                }
                if (waitForSof && prevVal == 0 && val != 0) {
                    waitForSof = false;
                } else if (waitForSof) {
                    prevVal = -1;
                    continue;
                }
                if (val == 0) break;
                if (code != 255) {
                    this.bos.write(0);
                }
                copy = code = val;
                --copy;
            }
            byte[] byArray = this.bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            this.deinit();
            this.logger.error("Error receiving frame: " + e.getMessage());
            throw new PhysicalDriverException(4, (Throwable)e);
        }
        catch (Exception e) {
            this.deinit();
            throw new PhysicalDriverException(3, (Throwable)e);
        }
        finally {
            this.logger.debug("Received total: " + this.receivedBytesTotal);
            this.logger.debug("Data: " + Util.bytesToHex(baos.toByteArray()));
        }
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                this.logger.info("Closing port");
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void deinit() {
        this.close();
        this.socket = null;
    }
}

