/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import sk.singularisdev.ekasask.EKasaException;
import sk.singularisdev.ekasask.enumeration.BARCODE_FONT_SIZE;
import sk.singularisdev.ekasask.enumeration.BARCODE_TEXT_POSITION;
import sk.singularisdev.ekasask.enumeration.BARCODE_TYPE;
import sk.singularisdev.ekasask.enumeration.PRINT_ALIGNMENT;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.enumeration.QR_CODE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.PrinterEsc;
import sk.singularisdev.ekasask.printer.PrinterStatus;
import sk.singularisdev.ekasask.printer.driver.SRP350IINRewriter;
import sk.singularisdev.ekasask.printer.utility.AbstractPrinterInterface;

public class SRP350IIN
extends AbstractPrinterInterface {
    public static String CHARSET_NAME = "CP852";
    private static final byte[] PRINTER_INIT = new byte[0];
    private static final byte[] PRINTER_STATUS = new byte[]{16, 4, 1};
    private static final byte[] OFFLINE_STATUS = new byte[]{16, 4, 2};
    private static final byte[] ERROR_STATUS = new byte[]{16, 4, 3};
    private static final byte[] PAPER_SENSOR_STATUS = new byte[]{16, 4, 4};
    private static final byte[] DEFAULT_ESC_CR = new byte[]{13};
    private static final byte[] DEFAULT_ESC_LF = new byte[]{10};
    private static final byte[] DEFAULT_ESC_CRLF = new byte[]{13, 10};
    private static final byte[] DEFAULT_ESC_OREZ = new byte[]{29, 86, 66, -112};
    private static final byte[] DEFAULT_ESC_LINE_PREFIX = new byte[0];
    private static final byte[] DEFAULT_ESC_FONT_CONDENSE_ON = new byte[]{27, 33, 1};
    private static final byte[] DEFAULT_ESC_FONT_CONDENSE_OFF;
    private static final byte[] DEFAULT_ESC_LINE_CONDENSE_ON;
    private static final byte[] DEFAULT_ESC_LINE_CONDENSE_OFF;
    private static final byte[] DEFAULT_ESC_FONT_SLOVAK;
    private static final byte[] DEFAULT_ESC_EURO;
    private static final byte[] DEFAULT_ESC_DOUBLE_CHAR_ON;
    private static final byte[] DEFAULT_ESC_DOUBLE_CHAR_OFF;
    private static final byte[] DEFAULT_ESC_DEFAULT;
    private static final byte[] DEFAULT_ESC_ALIGNMENT_LEFT;
    private static final byte[] DEFAULT_ESC_ALIGNMENT_CENTER;
    private static final byte[] DEFAULT_ESC_ALIGNMENT_RIGHT;
    private static final byte[] DEFAULT_ESC_SPACE;

    static {
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 33;
        DEFAULT_ESC_FONT_CONDENSE_OFF = byArray;
        DEFAULT_ESC_LINE_CONDENSE_ON = new byte[]{27, 51, 8};
        DEFAULT_ESC_LINE_CONDENSE_OFF = new byte[]{27, 50};
        DEFAULT_ESC_FONT_SLOVAK = new byte[]{27, 116, -1};
        DEFAULT_ESC_EURO = new byte[]{27, 116, 19, -43, 27, 116, -1};
        DEFAULT_ESC_DOUBLE_CHAR_ON = new byte[]{29, 33, 16};
        byte[] byArray2 = new byte[3];
        byArray2[0] = 29;
        byArray2[1] = 33;
        DEFAULT_ESC_DOUBLE_CHAR_OFF = byArray2;
        byte[] byArray3 = new byte[35];
        byArray3[0] = 27;
        byArray3[1] = 97;
        byArray3[3] = 27;
        byArray3[4] = 32;
        byArray3[6] = 27;
        byArray3[7] = 45;
        byArray3[9] = 27;
        byArray3[10] = 50;
        byArray3[11] = 27;
        byArray3[12] = 69;
        byArray3[14] = 27;
        byArray3[15] = 71;
        byArray3[17] = 29;
        byArray3[18] = 33;
        byArray3[20] = 29;
        byArray3[21] = 80;
        byArray3[24] = 27;
        byArray3[25] = 37;
        byArray3[27] = 27;
        byArray3[28] = 33;
        byArray3[30] = 27;
        byArray3[31] = 50;
        byArray3[32] = 27;
        byArray3[33] = 116;
        byArray3[34] = -1;
        DEFAULT_ESC_DEFAULT = byArray3;
        byte[] byArray4 = new byte[3];
        byArray4[0] = 27;
        byArray4[1] = 97;
        DEFAULT_ESC_ALIGNMENT_LEFT = byArray4;
        DEFAULT_ESC_ALIGNMENT_CENTER = new byte[]{27, 97, 1};
        DEFAULT_ESC_ALIGNMENT_RIGHT = new byte[]{27, 97, 2};
        DEFAULT_ESC_SPACE = new byte[]{32};
    }

    private SRP350IIN() {
        this.charset = Charset.forName(CHARSET_NAME);
    }

    public static SRP350IIN getInstance() {
        return new SRP350IIN();
    }

    public byte[] getEscSequence(PRINT_SEQUENCE_TYPE sequenceType) {
        switch (sequenceType) {
            case CR: {
                return DEFAULT_ESC_CR;
            }
            case LF: {
                return DEFAULT_ESC_LF;
            }
            case CRLF: {
                return DEFAULT_ESC_CRLF;
            }
            case OREZ: {
                return DEFAULT_ESC_OREZ;
            }
            case INIT_PRN: {
                return PRINTER_INIT;
            }
            case LINE_PREFIX: {
                return DEFAULT_ESC_LINE_PREFIX;
            }
            case FONT_CONDENSE_ON: {
                return DEFAULT_ESC_FONT_CONDENSE_ON;
            }
            case FONT_CONDENSE_OFF: {
                return DEFAULT_ESC_FONT_CONDENSE_OFF;
            }
            case LINE_CONDENSE_ON: {
                return DEFAULT_ESC_LINE_CONDENSE_ON;
            }
            case LINE_CONDENSE_OFF: {
                return DEFAULT_ESC_LINE_CONDENSE_OFF;
            }
            case FONT_SLOVAK: {
                return DEFAULT_ESC_FONT_SLOVAK;
            }
            case EURO: {
                return DEFAULT_ESC_EURO;
            }
            case DOUBLE_CHAR_ON: {
                return DEFAULT_ESC_DOUBLE_CHAR_ON;
            }
            case DOUBLE_CHAR_OFF: {
                return DEFAULT_ESC_DOUBLE_CHAR_OFF;
            }
            case DEFAULT: {
                return DEFAULT_ESC_DEFAULT;
            }
            case ALIGNMENT_LEFT: {
                return DEFAULT_ESC_ALIGNMENT_LEFT;
            }
            case ALIGNMENT_CENTER: {
                return DEFAULT_ESC_ALIGNMENT_CENTER;
            }
            case ALIGNMENT_RIGHT: {
                return DEFAULT_ESC_ALIGNMENT_RIGHT;
            }
            case SPACE: {
                return DEFAULT_ESC_SPACE;
            }
        }
        return new byte[0];
    }

    public byte[] getAlignment(PRINT_ALIGNMENT alignment) {
        switch (alignment) {
            case LEFT: {
                return DEFAULT_ESC_ALIGNMENT_LEFT;
            }
            case CENTER: {
                return DEFAULT_ESC_ALIGNMENT_CENTER;
            }
            case RIGHT: {
                return DEFAULT_ESC_ALIGNMENT_RIGHT;
            }
        }
        return new byte[0];
    }

    @Override
    public int getCharPerRow() {
        if (super.getCharPerRow() == 0) {
            return 40;
        }
        return super.getCharPerRow();
    }

    public boolean isQRsupport() {
        return true;
    }

    public int getDotsPerLine() {
        return 512;
    }

    public byte[] getBarcode(String barcode, BARCODE_TYPE barcodeType, BARCODE_TEXT_POSITION textPosition, BARCODE_FONT_SIZE fontSize, int bcHeight, int bcWidth) throws EKasaException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(new byte[]{29, 102});
            switch (fontSize) {
                case SMALL: {
                    baos.write(1);
                    break;
                }
                case LARGE: {
                    baos.write(0);
                }
            }
            baos.write(new byte[]{29, 104, (byte)bcHeight});
            baos.write(new byte[]{29, 119, (byte)bcWidth});
            baos.write(new byte[]{29, 72});
            switch (textPosition) {
                case NONE: {
                    baos.write(0);
                    break;
                }
                case ABOVE: {
                    baos.write(1);
                    break;
                }
                case BELOW: {
                    baos.write(2);
                    break;
                }
                case BOTH: {
                    baos.write(3);
                }
            }
            baos.write(new byte[]{29, 107});
            switch (barcodeType) {
                case UPC_A: {
                    baos.write(0);
                    break;
                }
                case UPC_E: {
                    baos.write(1);
                    break;
                }
                case EAN13: {
                    baos.write(2);
                    break;
                }
                case EAN8: {
                    baos.write(3);
                    break;
                }
                case CODE39: {
                    baos.write(4);
                    break;
                }
                case ITF: {
                    baos.write(5);
                    break;
                }
                case CODABAR: {
                    baos.write(6);
                    break;
                }
                case UPC_Ax: {
                    baos.write(65);
                    break;
                }
                case UPC_Ex: {
                    baos.write(66);
                    break;
                }
                case EAN13x: {
                    baos.write(67);
                    break;
                }
                case EANS: {
                    baos.write(68);
                    break;
                }
                case CODE39x: {
                    baos.write(69);
                    break;
                }
                case ITFx: {
                    baos.write(70);
                    break;
                }
                case CODABARx: {
                    baos.write(71);
                    break;
                }
                case CODE93: {
                    baos.write(72);
                    break;
                }
                case CODE128: {
                    baos.write(73);
                }
            }
            baos.write(barcode.getBytes(this.charset));
            baos.write(0);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    public byte[] loadNvImage(int count, byte[] data) throws EKasaException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(28);
            baos.write(113);
            baos.write((byte)count);
            baos.write(data);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    public byte[] printNvImage(int index) throws EKasaException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(28);
        baos.write(112);
        baos.write((byte)index);
        baos.write(0);
        return baos.toByteArray();
    }

    public byte[] printImage(int width, int height, byte[] bmp) throws EKasaException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int w = (width + 7) / 8 * 8;
        int h = (height + 7) / 8;
        int firstY = 0;
        while (firstY < h) {
            int lengthY = firstY + 48 < h ? 48 : h - firstY;
            baos.write(29);
            baos.write(42);
            baos.write((byte)((width + 7) / 8));
            baos.write((byte)lengthY);
            int x = 0;
            while (x < w) {
                int y = 0;
                while (y < lengthY) {
                    int p = (firstY + y) * w + x;
                    baos.write(bmp[p]);
                    ++p;
                    ++y;
                }
                ++x;
            }
            baos.write(29);
            baos.write(47);
            baos.write(3);
            firstY += 48;
        }
        return baos.toByteArray();
    }

    public PrinterEsc[] getPrinterStatusEsc() {
        PrinterEsc[] esc = new PrinterEsc[]{new PrinterEsc(PRINTER_STATUS, 1), new PrinterEsc(OFFLINE_STATUS, 1), new PrinterEsc(ERROR_STATUS, 1), new PrinterEsc(PAPER_SENSOR_STATUS, 1)};
        return esc;
    }

    public PrinterEsc getPrinterConnectionStatus() {
        return null;
    }

    public PrinterStatus parsePrinterStatus(PrinterEsc[] esc) {
        PrinterStatus status = new PrinterStatus();
        try {
            PrinterEsc[] printerEscArray = esc;
            int n = esc.length;
            int n2 = 0;
            while (n2 < n) {
                PrinterEsc e = printerEscArray[n2];
                if (Arrays.equals(e.getEsc(), PRINTER_STATUS)) {
                    if ((e.getResponse()[0] & 8) == 8) {
                        status.setOnline(false);
                    } else {
                        status.setOnline(true);
                    }
                } else if (Arrays.equals(e.getEsc(), OFFLINE_STATUS)) {
                    if ((e.getResponse()[0] & 4) == 4) {
                        status.setCoverOpen(true);
                    } else {
                        status.setCoverOpen(false);
                    }
                    if ((e.getResponse()[0] & 0x20) == 32) {
                        status.setEndOfPaper(true);
                    } else {
                        status.setEndOfPaper(false);
                    }
                } else if (Arrays.equals(e.getEsc(), ERROR_STATUS)) {
                    if ((e.getResponse()[0] & 8) == 8) {
                        status.setAutoCutterError(true);
                    } else {
                        status.setAutoCutterError(false);
                    }
                } else if (Arrays.equals(e.getEsc(), PAPER_SENSOR_STATUS)) {
                    if ((e.getResponse()[0] & 0xC) == 12) {
                        status.setPaperNearToEnd(true);
                    } else {
                        status.setPaperNearToEnd(false);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            status.setPrinterResponseError(e.getMessage());
        }
        return status;
    }

    public byte[] getQrCode(String qrCode, QR_CODE_TYPE qrCodeType) throws EKasaException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(27);
            baos.write(97);
            baos.write(1);
            baos.write(29);
            baos.write(40);
            baos.write(107);
            int l = qrCode.length() + 3;
            ByteBuffer bBuff = ByteBuffer.allocate(4);
            bBuff.order(ByteOrder.LITTLE_ENDIAN);
            baos.write(bBuff.putInt(l).array(), 0, 2);
            baos.write(49);
            baos.write(80);
            baos.write(48);
            baos.write(qrCode.getBytes(this.charset));
            baos.write(29);
            baos.write(40);
            baos.write(107);
            baos.write(3);
            baos.write(0);
            baos.write(49);
            baos.write(69);
            switch (qrCodeType) {
                case V4_CLL: {
                    baos.write(48);
                    break;
                }
                case V5_CLM: {
                    baos.write(49);
                    break;
                }
                case V3_CLM: {
                    baos.write(49);
                }
            }
            byte[] byArray = new byte[8];
            byArray[0] = 29;
            byArray[1] = 40;
            byArray[2] = 107;
            byArray[3] = 3;
            byArray[5] = 49;
            byArray[6] = 67;
            byArray[7] = 6;
            baos.write(byArray);
            byte[] byArray2 = new byte[8];
            byArray2[0] = 29;
            byArray2[1] = 40;
            byArray2[2] = 107;
            byArray2[3] = 3;
            byArray2[5] = 49;
            byArray2[6] = 81;
            byArray2[7] = 48;
            baos.write(byArray2);
            baos.write(27);
            baos.write(97);
            baos.write(0);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new EKasaException(13L, (Throwable)e);
        }
    }

    public String rewriteEscSequence(String text, boolean printable, boolean announcement) {
        text = SRP350IINRewriter.REWRITER_ALLOW_PANEL_BUTTON.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_CR.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_CUTTER.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_DOUBLE_STRIKE.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_DOUBLE_WIDTH.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_EMPHASIZED.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_LF.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_REVERSE.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_ROTATE.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_LOGO.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_SHUFFLE.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_UNDERLINE.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_UPSIDE_DOWN.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_EURO.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        text = SRP350IINRewriter.REWRITER_DOUBLE_WIDTH_HEIGHT.rewrite((CharSequence)text, this.getCharset(), printable, (AbstractPrinter)this);
        return text;
    }

    public int[] getVatTableCols() {
        int[] nArray = new int[6];
        nArray[1] = 6;
        nArray[2] = 11;
        nArray[3] = 11;
        nArray[4] = 11;
        return nArray;
    }

    public boolean printEmptyVatTableRow() {
        return false;
    }

    @Override
    public int getCharPerRowInternalReceipt() {
        return 41;
    }

    @Override
    public int getCharPerRowReceipt() {
        return 40;
    }
}

