/*
 * Decompiled with CFR 0.152.
 */
package sk.singularisdev.ekasask.printer.driver;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import sk.singularisdev.ekasask.enumeration.PRINT_SEQUENCE_TYPE;
import sk.singularisdev.ekasask.printer.AbstractPrinter;
import sk.singularisdev.ekasask.printer.utility.Rewriter;

public class UniversalRewriter {
    public static final Rewriter REWRITER_LF = new Rewriter("(~0A)", ""){

        public String replacement(AbstractPrinter printer) {
            return new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.LF), printer.getCharset());
        }
    };
    public static final Rewriter REWRITER_CR = new Rewriter("(~0D)", ""){

        public String replacement(AbstractPrinter printer) {
            return new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.CR), printer.getCharset());
        }
    };
    public static final Rewriter REWRITER_UNDERLINE = new Rewriter("(~1B~2D~0[0-2])", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            char ch = g.charAt(g.length() - 1);
            return "\u001b-" + ch;
        }
    };
    public static final Rewriter REWRITER_EMPHASIZED = new Rewriter("(~1B~45~[0-9A-F]{2})", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001bE" + b;
        }
    };
    public static final Rewriter REWRITER_DOUBLE_STRIKE = new Rewriter("(~1B~47~[0-9A-F]{2})", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001bG" + b;
        }
    };
    public static final Rewriter REWRITER_ROTATE = new Rewriter("(~1B~56~0[0-1])", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            char ch = g.charAt(g.length() - 1);
            return "\u001bV" + ch;
        }
    };
    public static final Rewriter REWRITER_ALLOW_PANEL_BUTTON = new Rewriter("(~1B~63~35~[0-9A-F]{2})", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001bc5" + b;
        }
    };
    public static final Rewriter REWRITER_SHUFFLE = new Rewriter("(~1B~70~0[0-1]~[0-9A-F]{2}~[0-9A-F]{2})", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            int l = g.length();
            char ch = g.charAt(l - 7);
            String ch1 = g.substring(l - 5, l - 3);
            String b1 = new String(new byte[]{(byte)Integer.parseInt(ch1, 16)}, this.getCharset());
            String ch2 = g.substring(l - 2, l);
            String b2 = new String(new byte[]{(byte)Integer.parseInt(ch2, 16)}, this.getCharset());
            return "\u001bp" + ch + b1 + b2;
        }
    };
    public static final Rewriter REWRITER_LOGO = new Rewriter("(~1C~70~0[0-1]~0[0-1])", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            int l = g.length();
            String ch1 = g.substring(l - 5, l - 3);
            String b1 = new String(new byte[]{(byte)Integer.parseInt(ch1, 16)}, this.getCharset());
            String ch2 = g.substring(l - 2, l);
            String b2 = new String(new byte[]{(byte)Integer.parseInt(ch2, 16)}, this.getCharset());
            return "\u001cp" + b1 + b2;
        }
    };
    public static final Rewriter REWRITER_UPSIDE_DOWN = new Rewriter("(~1B~7B~[0-9A-F]{2})", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001b{" + b;
        }
    };
    public static final Rewriter REWRITER_CUTTER = new Rewriter("(~1D~56~42~(00|01|66))", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001dVB" + b;
        }
    };
    public static final Rewriter REWRITER_REVERSE = new Rewriter("(~1D~42~[0-9A-F]{2})", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001dB" + b;
        }
    };
    public static final Rewriter REWRITER_DOUBLE_WIDTH = new Rewriter("(~1F.)", "  "){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            int l = g.length();
            char ch = g.charAt(l - 1);
            return String.valueOf(new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_ON), printer.getCharset())) + ch + new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.DOUBLE_CHAR_OFF), printer.getCharset());
        }
    };
    public static final Rewriter REWRITER_EURO = new Rewriter("(\u20ac)", " "){

        public String replacement(AbstractPrinter printer) {
            return new String(printer.getEscSequence(PRINT_SEQUENCE_TYPE.EURO), printer.getCharset());
        }
    };
    public static final Rewriter REWRITER_DOUBLE_WIDTH_HEIGHT = new Rewriter("(~1B~21~[0-9A-F]{2})", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001b!" + b;
        }
    };
    public static final Rewriter REWRITER_DOUBLE_WIDTH_HEIGHT_GS = new Rewriter("(~1D~21~[0-9A-F]{2})", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001d!" + b;
        }
    };
    public static final Rewriter REWRITER_ALIGNMENT = new Rewriter("(~1B~61~(00|01))", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001ba" + b;
        }
    };
    public static final Rewriter REWRITE_DISP = new Rewriter("(~1B~3D~(01|02|03))", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001b=" + b;
        }
    };
    public static final Rewriter REWRITER_QR_CORRECTION_LEVEL = new Rewriter("(~1D~28~6B~03~00~31~45~(30|31))", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001d(k\u0003\u00001E" + b;
        }
    };
    public static final Rewriter REWRITER_QR_SIZE = new Rewriter("(~1D~28~6B~03~00~31~43~[0-9A-F]{2})", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String ch = g.substring(g.length() - 2);
            String b = new String(new byte[]{(byte)Integer.parseInt(ch, 16)}, this.getCharset());
            return "\u001d(k\u0003\u00001C" + b;
        }
    };
    public static final Rewriter REWRITER_QR_PRINT = new Rewriter("(~1D~28~6B~03~00~31~51~30)", ""){

        public String replacement(AbstractPrinter printer) {
            return "\u001d(k\u0003\u00001Q0";
        }
    };
    public static final Rewriter REWRITER_QR_DATA = new Rewriter("(~QRCODESTART[\\x00-\\xFF]{1,3000}~QRCODESTOP)", ""){

        public String replacement(AbstractPrinter printer) {
            String g = this.group(1);
            String qrData = g.replace("~QRCODESTART", "").replace("~QRCODESTOP", "");
            int l = qrData.length() + 3;
            ByteBuffer bBuff = ByteBuffer.allocate(4);
            bBuff.order(ByteOrder.LITTLE_ENDIAN);
            String lng = new String(Arrays.copyOfRange(bBuff.putInt(l).array(), 0, 2), this.getCharset());
            String data = new String(qrData.getBytes(this.getCharset()), this.getCharset());
            return "\u001d(k" + lng + "1P0" + data;
        }
    };
}

