/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.util.Collections;
import java.util.List;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.CallbackLookup;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMCallbackLookup
implements CallbackLookup {
    protected Document doc;

    public DOMCallbackLookup(Document doc) {
        this.doc = doc;
    }

    @Override
    public Element getElement(String id, String valueType, boolean checkMultipleElements) throws WSSecurityException {
        String cId;
        String idToMatch = WSSecurityUtil.getIDFromReference(id);
        Element bodyElement = WSSecurityUtil.findBodyElement(this.doc);
        if (bodyElement != null && (cId = bodyElement.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")).equals(idToMatch)) {
            return bodyElement;
        }
        Element foundElement = WSSecurityUtil.findElementById(this.doc.getDocumentElement(), idToMatch, checkMultipleElements);
        if (foundElement != null) {
            return foundElement;
        }
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType) || "".equals(valueType) || valueType == null) {
            return WSSecurityUtil.findSAMLAssertionElementById(this.doc.getDocumentElement(), idToMatch);
        }
        return null;
    }

    @Override
    public List<Element> getElements(String localname, String namespace) throws WSSecurityException {
        Element bodyElement = WSSecurityUtil.findBodyElement(this.doc);
        if ("Body".equals(localname) && bodyElement.getNamespaceURI().equals(namespace)) {
            return Collections.singletonList(bodyElement);
        }
        return WSSecurityUtil.findElements(this.doc.getDocumentElement(), localname, namespace);
    }
}

